/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM - Rational Software and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v0.5 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors:
 *     IBM - Rational Software - initial implementation
 * 
 */
package org.eclipse.cdt.internal.core.parser.scanner;

/**
 * @author ddaoust
 *
 */
public class ScannerContextTopString  implements IScannerContext {
    int position=0;
    int line = 1;
    int length;
    String reader;
    String textName;
    int extra = -1;
    boolean stop = false;
    
	public ScannerContextTopString(String in, String contextName, boolean stop)
	{
		textName = contextName;
		reader = in;
		length = in.length();
		this.stop = stop;
	}
	public ScannerContextTopString(String in, String contextName, char e, boolean stop)
	{
		textName = contextName;
		reader = in;
		length = in.length();
		this.stop = stop;
		extra = e;
	}
	
    
	public boolean isFinal() { return stop;}
	public final String getContextName() {
		return textName;
	}
	public int getChar() {
		int c;
		if (position < length)
			c = reader.charAt(position++);
		else if (position++ == length)
			c = extra;
		else c = -1;
		if (c == '\n') line++;
		return c;
	}
	
	public void close() {
		
	}
	
	public int getFilenameIndex() { return 0; }
	
	public final void ungetChar(int c)
	{
		position--;
		if (c == '\n') line--;
		// may want to assert that reader.charAt(position) == c
	}


	/* (non-Javadoc)
     * @see org.eclipse.cdt.internal.core.parser.IScannerContext#getOffset()
     */
	public int getOffset()
	{
        // All the tokens generated by the macro expansion 
        // will have dimensions (offset and length) equal to the expanding symbol.
		return position;
	}
	public int getLine()
	{
		return line;
	}

	/**
	 * Returns the kind.
	 * @return int
	 */
	public int getKind() {
		return IScannerContext.ContextKind.TOP;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append( getContextName() );
		if (position <= length) {
			buffer.append( reader.substring(0, position ));
			buffer.append( '*' );
			buffer.append( reader.substring(position, length-position));
			if (extra != -1 ) buffer.append( (char)extra );
		}
		else {
			buffer.append( reader.substring(0, length ));
			if ( extra != -1 ) buffer.append( (char)extra );
			buffer.append( '*' );
		}
		return buffer.toString();
	}
}
