/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.impl.Block;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;

public abstract class IndexBlock
extends Block {
    public IndexBlock(int blockSize) {
        super(blockSize);
    }

    public abstract boolean addEntry(WordEntry var1);

    public abstract boolean addIncludeEntry(IncludeEntry var1);

    public void clear() {
        this.reset();
        super.clear();
    }

    public WordEntry findEntryMatching(char[] pattern, boolean isCaseSensitive) {
        this.reset();
        WordEntry entry = new WordEntry();
        while (this.nextEntry(entry)) {
            if (!CharOperation.match(pattern, entry.getWord(), isCaseSensitive)) continue;
            return entry;
        }
        return null;
    }

    public WordEntry findEntryPrefixedBy(char[] word, boolean isCaseSensitive) {
        this.reset();
        WordEntry entry = new WordEntry();
        while (this.nextEntry(entry)) {
            if (!CharOperation.prefixEquals(entry.getWord(), word, isCaseSensitive)) continue;
            return entry;
        }
        return null;
    }

    public WordEntry findExactEntry(char[] word) {
        this.reset();
        WordEntry entry = new WordEntry();
        while (this.nextEntry(entry)) {
            if (!CharOperation.equals(entry.getWord(), word)) continue;
            return entry;
        }
        return null;
    }

    public abstract boolean isEmpty();

    public abstract boolean nextEntry(WordEntry var1);

    public abstract boolean nextEntry(IncludeEntry var1);

    public void reset() {
    }
}

