/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.cdt.internal.corext.template.ITemplateEditor;
import org.eclipse.cdt.internal.corext.template.TemplateBuffer;
import org.eclipse.cdt.internal.corext.template.TemplateContext;
import org.eclipse.cdt.internal.corext.template.TemplatePosition;
import org.eclipse.cdt.internal.corext.template.c.CContext;
import org.eclipse.cdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.NopTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.cdt.internal.corext.textmanipulation.TextUtil;
import org.eclipse.core.runtime.CoreException;

public class CFormatter
implements ITemplateEditor {
    private static final String CURSOR = "cursor";
    private static final String MARKER = "/*${cursor}*/";

    public void edit(TemplateBuffer buffer, TemplateContext context) throws CoreException {
        int indentationLevel = ((CContext)context).getIndentationLevel();
        CFormatter.indentate(buffer, indentationLevel);
        CFormatter.trimBegin(buffer);
    }

    private static int getCaretOffset(TemplatePosition[] variables) {
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            if (variable.getName().equals(CURSOR)) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return -1;
    }

    private static void indentate(TemplateBuffer templateBuffer, int indentationLevel) throws CoreException {
        String string = templateBuffer.getString();
        TemplatePosition[] variables = templateBuffer.getVariables();
        String indentation = TextUtil.createIndentString(indentationLevel);
        MultiTextEdit positions = CFormatter.variablesToPositions(variables);
        MultiTextEdit multiEdit = new MultiTextEdit();
        TextBuffer textBuffer = TextBuffer.create(string);
        int lineCount = textBuffer.getNumberOfLines();
        int i = 0;
        while (i < lineCount) {
            TextRegion region = textBuffer.getLineInformation(i);
            multiEdit.add(SimpleTextEdit.createInsert(region.getOffset(), indentation));
            ++i;
        }
        string = CFormatter.edit(string, positions, multiEdit);
        CFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(string, variables);
    }

    private static void trimBegin(TemplateBuffer templateBuffer) throws CoreException {
        String string = templateBuffer.getString();
        TemplatePosition[] variables = templateBuffer.getVariables();
        MultiTextEdit positions = CFormatter.variablesToPositions(variables);
        int i = 0;
        while (i != string.length() && Character.isWhitespace(string.charAt(i))) {
            ++i;
        }
        string = CFormatter.edit(string, positions, SimpleTextEdit.createDelete(0, i));
        CFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(string, variables);
    }

    private static String edit(String string, MultiTextEdit positions, MultiTextEdit multiEdit) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(string);
        TextBufferEditor editor = new TextBufferEditor(textBuffer);
        editor.add(positions);
        editor.add(multiEdit);
        editor.performEdits(null);
        return textBuffer.getContent();
    }

    private static String edit(String string, MultiTextEdit positions, TextEdit singleEdit) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(string);
        TextBufferEditor editor = new TextBufferEditor(textBuffer);
        editor.add(positions);
        editor.add(singleEdit);
        editor.performEdits(null);
        return textBuffer.getContent();
    }

    private static int[] variablesToOffsets(TemplatePosition[] variables) {
        Vector<Integer> vector = new Vector<Integer>();
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            int j = 0;
            while (j != offsets.length) {
                vector.add(new Integer(offsets[j]));
                ++j;
            }
            ++i;
        }
        int[] offsets = new int[vector.size()];
        int i2 = 0;
        while (i2 != offsets.length) {
            offsets[i2] = (Integer)vector.get(i2);
            ++i2;
        }
        Arrays.sort(offsets);
        return offsets;
    }

    private static void offsetsToVariables(int[] allOffsets, TemplatePosition[] variables) {
        int[] currentIndices = new int[variables.length];
        int i = 0;
        while (i != currentIndices.length) {
            currentIndices[i] = 0;
            ++i;
        }
        int[][] offsets = new int[variables.length][];
        int i2 = 0;
        while (i2 != variables.length) {
            offsets[i2] = variables[i2].getOffsets();
            ++i2;
        }
        i2 = 0;
        while (i2 != allOffsets.length) {
            int min = Integer.MAX_VALUE;
            int minVariableIndex = -1;
            int j = 0;
            while (j != variables.length) {
                int offset;
                int currentIndex = currentIndices[j];
                if (currentIndex != offsets[j].length && (offset = offsets[j][currentIndex]) < min) {
                    min = offset;
                    minVariableIndex = j;
                }
                ++j;
            }
            offsets[minVariableIndex][currentIndices[minVariableIndex]] = allOffsets[i2];
            int n = minVariableIndex;
            currentIndices[n] = currentIndices[n] + 1;
            ++i2;
        }
        i2 = 0;
        while (i2 != variables.length) {
            variables[i2].setOffsets(offsets[i2]);
            ++i2;
        }
    }

    private static MultiTextEdit variablesToPositions(TemplatePosition[] variables) {
        MultiTextEdit positions = new MultiTextEdit();
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            int j = 0;
            while (j != offsets.length) {
                positions.add(new NopTextEdit(offsets[j], 0));
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private static void positionsToVariables(MultiTextEdit positions, TemplatePosition[] variables) {
        Iterator iterator = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((TextEdit)iterator.next()).getTextRange().getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }
}

