/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleDocument;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStream;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class BuildConsolePartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IConsole,
IPropertyChangeListener {
    List fPartitions = new ArrayList(5);
    private int fMaxLines;
    BuildConsoleStream fLastStream = null;
    BuildConsoleDocument fDocument;
    boolean killed;
    BuildConsoleManager fManager;

    public BuildConsolePartitioner(BuildConsoleManager manager) {
        this.fManager = manager;
        this.fMaxLines = BuildConsolePreferencePage.buildConsoleLines();
        this.fDocument = new BuildConsoleDocument();
        this.fDocument.setDocumentPartitioner(this);
        this.connect((IDocument)this.fDocument);
    }

    public void appendToDocument(final String text, final BuildConsoleStream stream) {
        Runnable r = new Runnable(){

            public void run() {
                BuildConsolePartitioner.this.fLastStream = stream;
                try {
                    if (stream == null) {
                        BuildConsolePartitioner.this.fDocument.set(text);
                    } else {
                        BuildConsolePartitioner.this.fDocument.replace(BuildConsolePartitioner.this.fDocument.getLength(), 0, text);
                        BuildConsolePartitioner.this.checkOverflow();
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        };
        Display display = CUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(r);
        }
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocumentSize(int nLines) {
        this.fMaxLines = nLines;
        nLines = this.fDocument.getNumberOfLines();
        this.checkOverflow();
    }

    public void connect(IDocument document) {
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void disconnect() {
        this.fDocument.setDocumentPartitioner(null);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.killed = true;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{BuildConsolePartition.CONSOLE_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        ITypedRegion partition = this.getPartition(offset);
        if (partition != null) {
            return partition.getType();
        }
        return null;
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        if (offset == 0 && length == this.fDocument.getLength()) {
            return this.fPartitions.toArray(new ITypedRegion[this.fPartitions.size()]);
        }
        int end = offset + length;
        ArrayList<ITypedRegion> list = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = (ITypedRegion)this.fPartitions.get(i);
            int partitionStart = partition.getOffset();
            int partitionEnd = partitionStart + partition.getLength();
            if (offset >= partitionStart && offset <= partitionEnd || offset < partitionStart && end >= partitionStart) {
                list.add(partition);
            }
            ++i;
        }
        return list.toArray(new ITypedRegion[list.size()]);
    }

    public ITypedRegion getPartition(int offset) {
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = (ITypedRegion)this.fPartitions.get(i);
            int start = partition.getOffset();
            int end = start + partition.getLength();
            if (offset >= start && offset < end) {
                return partition;
            }
            ++i;
        }
        return null;
    }

    public IRegion documentChanged2(DocumentEvent event) {
        String text = event.getText();
        if (this.getDocument().getLength() == 0) {
            this.fPartitions.clear();
            return new Region(0, 0);
        }
        this.addPartition(new BuildConsolePartition(this.fLastStream, event.getOffset(), text.length()));
        ITypedRegion[] affectedRegions = this.computePartitioning(event.getOffset(), text.length());
        if (affectedRegions.length == 0) {
            return null;
        }
        if (affectedRegions.length == 1) {
            return affectedRegions[0];
        }
        int affectedLength = affectedRegions[0].getLength();
        int i = 1;
        while (i < affectedRegions.length) {
            ITypedRegion region = affectedRegions[i];
            affectedLength += region.getLength();
            ++i;
        }
        return new Region(affectedRegions[0].getOffset(), affectedLength);
    }

    protected void checkOverflow() {
        int nLines;
        if (this.fMaxLines >= 0 && (nLines = this.fDocument.getNumberOfLines()) > this.fMaxLines + 1) {
            int overflow = 0;
            try {
                overflow = this.fDocument.getLineOffset(nLines - this.fMaxLines);
            }
            catch (BadLocationException badLocationException) {}
            ArrayList<BuildConsolePartition> newParitions = new ArrayList<BuildConsolePartition>(this.fPartitions.size());
            Iterator partitions = this.fPartitions.iterator();
            while (partitions.hasNext()) {
                ITypedRegion region = (ITypedRegion)partitions.next();
                if (!(region instanceof BuildConsolePartition)) continue;
                BuildConsolePartition messageConsolePartition = (BuildConsolePartition)region;
                BuildConsolePartition newPartition = null;
                int offset = region.getOffset();
                if (offset < overflow) {
                    int endOffset = offset + region.getLength();
                    if (endOffset >= overflow) {
                        int length = endOffset - overflow;
                        newPartition = messageConsolePartition.createNewPartition(0, length);
                    }
                } else {
                    newPartition = messageConsolePartition.createNewPartition(messageConsolePartition.getOffset() - overflow, messageConsolePartition.getLength());
                }
                if (newPartition == null) continue;
                newParitions.add(newPartition);
            }
            this.fPartitions = newParitions;
            try {
                this.fDocument.replace(0, overflow, "");
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private BuildConsolePartition addPartition(BuildConsolePartition partition) {
        if (this.fPartitions.isEmpty()) {
            this.fPartitions.add(partition);
        } else {
            int index = this.fPartitions.size() - 1;
            BuildConsolePartition last = (BuildConsolePartition)((Object)this.fPartitions.get(index));
            if (last.canBeCombinedWith(partition)) {
                partition = last.combineWith(partition);
                this.fPartitions.set(index, partition);
            } else {
                this.fPartitions.add(partition);
            }
        }
        return partition;
    }

    public IConsole getConsole() {
        return this;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "buildConsoleLines") {
            this.setDocumentSize(BuildConsolePreferencePage.buildConsoleLines());
        }
    }

    public void start(IProject project) {
        if (BuildConsolePreferencePage.isClearBuildConsole()) {
            this.appendToDocument("", null);
        }
        this.fManager.startConsoleActivity(project);
    }

    public ConsoleOutputStream getOutputStream() throws CoreException {
        return new BuildOutputStream(this.fManager.getStream(1));
    }

    public ConsoleOutputStream getInfoStream() throws CoreException {
        return new BuildOutputStream(this.fManager.getStream(0));
    }

    public ConsoleOutputStream getErrorStream() throws CoreException {
        return new BuildOutputStream(this.fManager.getStream(2));
    }

    public class BuildOutputStream
    extends ConsoleOutputStream {
        final BuildConsoleStream fStream;

        public BuildOutputStream(BuildConsoleStream stream) {
            this.fStream = stream;
        }

        public void flush() throws IOException {
            BuildConsolePartitioner.this.appendToDocument(this.readBuffer(), this.fStream);
            BuildConsolePartitioner.this.fManager.showConsole();
        }

        public void close() throws IOException {
            this.flush();
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.flush();
        }
    }
}

