/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.StandardCElementLabelProvider;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.LexicalSortingAction;
import org.eclipse.cdt.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.internal.ui.editor.TogglePresentationAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.cdt.ui.actions.RefactoringActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CContentOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    private CEditor fEditor;
    private ITranslationUnit fInput;
    private ProblemTreeViewer treeViewer;
    private ListenerList selectionChangedListeners = new ListenerList();
    private TogglePresentationAction fTogglePresentation;
    private String fContextMenuId;
    private OpenIncludeAction fOpenIncludeAction;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ActionGroup fSelectionSearchGroup;
    private ActionGroup fRefactoringActionGroup;

    public CContentOutlinePage(CEditor editor) {
        this("#TranslationUnitOutlinerContext", editor);
    }

    public CContentOutlinePage(String contextMenuID, CEditor editor) {
        this.fEditor = editor;
        this.fInput = null;
        this.fContextMenuId = contextMenuID;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)editor);
        this.fOpenIncludeAction = new OpenIncludeAction((ISelectionProvider)this);
    }

    public ICElement getRoot() {
        return this.fInput;
    }

    public void contentUpdated() {
        TreeViewer treeViewer;
        if (this.fInput != null && (treeViewer = this.getTreeViewer()) != null && !treeViewer.getControl().isDisposed()) {
            treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!treeViewer.getControl().isDisposed()) {
                        ISelection sel = treeViewer.getSelection();
                        treeViewer.getControl().setRedraw(false);
                        treeViewer.refresh();
                        treeViewer.setSelection(CContentOutlinePage.this.updateSelection(sel));
                        treeViewer.getControl().setRedraw(true);
                    }
                }
            });
        }
    }

    protected ISelection updateSelection(ISelection sel) {
        ArrayList<ICElement> newSelection = new ArrayList<ICElement>();
        if (sel instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)sel).iterator();
            while (iter.hasNext()) {
                ICElement elem = (ICElement)iter.next();
                if (elem == null) continue;
                newSelection.add(elem);
            }
        }
        return new StructuredSelection(newSelection);
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        CUIPlugin.createStandardGroups(menu);
        if (OpenIncludeAction.canActionBeAdded(this.getSelection())) {
            menu.add((IAction)this.fOpenIncludeAction);
        }
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        if (SelectionSearchGroup.canActionBeAdded(this.getSelection())) {
            MenuManager search = new MenuManager(CViewMessages.getString("SearchAction.label"), "group.search");
            this.fSelectionSearchGroup.fillContextMenu((IMenuManager)search);
            menu.add((IContributionItem)search);
            menu.add((IContributionItem)new Separator("additions"));
        }
        this.fRefactoringActionGroup.fillContextMenu(menu);
    }

    public void createControl(Composite parent) {
        this.treeViewer = new ProblemTreeViewer(parent, 770);
        this.treeViewer.setContentProvider((IContentProvider)new CElementContentProvider(true, true));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new StandardCElementLabelProvider());
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.addSelectionChangedListener(this);
        CUIPlugin.getDefault().getProblemMarkerManager().addListener(this.treeViewer);
        MenuManager manager = new MenuManager(this.fContextMenuId);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CContentOutlinePage.this.contextMenuAboutToShow(manager);
            }
        });
        Control control = this.treeViewer.getControl();
        Menu menu = manager.createContextMenu(control);
        control.setMenu(menu);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (CContentOutlinePage.this.fOpenIncludeAction != null) {
                    CContentOutlinePage.this.fOpenIncludeAction.run();
                }
            }
        });
        IPageSite site = this.getSite();
        site.registerContextMenu(this.fContextMenuId, manager, (ISelectionProvider)this.treeViewer);
        site.setSelectionProvider((ISelectionProvider)this.treeViewer);
        IActionBars bars = site.getActionBars();
        bars.setGlobalActionHandler("org.eclipse.cdt.ui.edit.text.c.toggle.presentation", (IAction)this.fTogglePresentation);
        this.fSelectionSearchGroup = new SelectionSearchGroup(this);
        this.fRefactoringActionGroup = new RefactoringActionGroup(this, null);
        this.treeViewer.setInput(this.fInput);
        WorkbenchHelp.setHelp((Control)control, (String)"org.eclipse.cdt.ui.outline_view");
    }

    public void dispose() {
        CUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.treeViewer);
        if (this.treeViewer != null) {
            this.treeViewer.removeSelectionChangedListener(this);
        }
        if (this.fTogglePresentation != null) {
            this.fTogglePresentation.setEditor(null);
            this.fTogglePresentation = null;
        }
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.dispose();
            this.fRefactoringActionGroup = null;
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.dispose();
            this.fSelectionSearchGroup = null;
        }
        if (this.selectionChangedListeners != null) {
            this.selectionChangedListeners.clear();
            this.selectionChangedListeners = null;
        }
        this.fInput = null;
        super.dispose();
    }

    public void setActionBars(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        LexicalSortingAction action = new LexicalSortingAction(this.getTreeViewer());
        toolBarManager.add((IAction)action);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.treeViewer, "COutlineViewer");
        this.fMemberFilterActionGroup.fillActionBars(actionBars);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    protected void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    public Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(selection);
        }
    }

    public void setInput(ITranslationUnit unit) {
        this.fInput = unit;
        if (this.treeViewer != null) {
            this.treeViewer.setInput(this.fInput);
        }
        this.contentUpdated();
    }
}

