/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class CSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    CSearchQuery cQuery;
    private static final Match[] NO_MATCHES = new Match[0];

    public CSearchResult(CSearchQuery query) {
        this.cQuery = query;
    }

    public Match[] findContainedMatches(IFile file) {
        ICElement cElement = this.create(file);
        HashSet matches = new HashSet();
        this.collectMatches(matches, cElement);
        return matches.toArray(new Match[matches.size()]);
    }

    private ICElement create(IFile file) {
        IProject project = file.getProject();
        ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
        return cProject;
    }

    private void collectMatches(Set matches, ICElement element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                ICElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.collectMatches(matches, children[i]);
                    ++i;
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof ICElement) {
            ICElement cElement = (ICElement)element;
            element = cElement.getUnderlyingResource();
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (match.getElement() instanceof BasicSearchMatch) {
            BasicSearchMatch searchMatch = (BasicSearchMatch)match.getElement();
            if (editorInput instanceof IFileEditorInput) {
                IFile inputFile = ((IFileEditorInput)editorInput).getFile();
                IResource matchFile = searchMatch.getResource();
                if (matchFile != null) {
                    return inputFile.equals((Object)matchFile);
                }
                return false;
            }
        } else if (match.getElement() instanceof IFile && editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile().equals(match.getElement());
        }
        return false;
    }

    public Match[] findContainedMatches(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.findContainedMatches(fileEditorInput.getFile());
        }
        return null;
    }

    public String getText() {
        int matchCount = this.getMatchCount();
        String format = null;
        format = matchCount == 1 ? this.cQuery.getSingularLabel() : this.cQuery.getPluralLabelPattern();
        return MessageFormat.format(format, new Integer(matchCount));
    }

    public String getTooltip() {
        return this.getText();
    }

    public ImageDescriptor getImageDescriptor() {
        return this.cQuery.getImageDescriptor();
    }

    public ISearchQuery getQuery() {
        return this.cQuery;
    }

    public String getLabel() {
        int matches = this.getMatchCount();
        String label = null;
        if (matches == 1) {
            return this.cQuery.getSingularLabel();
        }
        label = this.cQuery.getPluralLabelPattern();
        return MessageFormat.format(label, new Integer(matches));
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.computeContainedMatches(result, fileEditorInput.getFile());
        }
        return null;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        ICElement cElement = CoreModel.getDefault().create(file);
        if (!(cElement instanceof ITranslationUnit)) {
            return NO_MATCHES;
        }
        HashSet matches = new HashSet();
        Object[] test = result.getElements();
        this.collectMatches(matches, test, file);
        return matches.toArray(new Match[matches.size()]);
    }

    private void collectMatches(Set matches, Object[] test, IFile file) {
        int i = 0;
        while (i < test.length) {
            Match[] m;
            BasicSearchMatch tempMatch = (BasicSearchMatch)test[i];
            if (tempMatch.getResource().equals((Object)file) && (m = this.getMatches(tempMatch)).length != 0) {
                int j = 0;
                while (j < m.length) {
                    matches.add(m[j]);
                    ++j;
                }
            }
            ++i;
        }
    }
}

