/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.browser.UnknownTypeInfo;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.wizards.BaseClassSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LinkToFileGroup;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class NewClassWizardPage
extends WizardPage
implements Listener {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private final String HEADER_EXT = ".h";
    private final String BODY_EXT = ".cpp";
    private IStructuredSelection currentSelection;
    private ICElement eSelection = null;
    private IPath defaultSourceFolder = null;
    private ITypeSearchScope fClassScope = null;
    private final int[] fClassTypes = new int[]{64, 65};
    private IProject fSelectedProject = null;
    private ITranslationUnit parentHeaderTU = null;
    private ITranslationUnit parentBodyTU = null;
    private ICElement createdClass = null;
    private ITypeInfo[] elementsOfTypeClassInProject = null;
    private StringDialogField fClassNameDialogField;
    private StringButtonDialogField fBaseClassDialogField;
    private SelectionButtonDialogFieldGroup fAccessButtons;
    private SelectionButtonDialogFieldGroup fConstDestButtons;
    private LinkToFileGroup linkedResourceGroupForHeader;
    private LinkToFileGroup linkedResourceGroupForBody;
    private final int PUBLIC_INDEX = 0;
    private final int PROTECTED_INDEX = 1;
    private final int PRIVATE_INDEX = 2;
    private final int DEFAULT_INDEX = 3;
    private IStatus fCurrStatus;
    protected IStatus fClassNameStatus;
    protected IStatus fBaseClassStatus;
    protected IStatus fLinkedResourceGroupForHeaderStatus;
    protected IStatus fLinkedResourceGroupForBodyStatus;
    private boolean hasCppNature = false;
    private Comparator TYPE_NAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ITypeInfo)o1).getName().compareTo(((ITypeInfo)o2).getName());
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NewClassWizardPage(IStructuredSelection selection) {
        super(PAGE_NAME);
        this.currentSelection = selection;
        this.hasCppNature = this.isSelectionCPP(this.currentSelection);
        if (this.hasCppNature) {
            this.initializePageControls();
        }
    }

    protected void initializePageControls() {
        TypeFieldsAdapter adapter = new TypeFieldsAdapter();
        this.fClassNameDialogField = new StringDialogField();
        this.fClassNameDialogField.setDialogFieldListener(adapter);
        this.fClassNameDialogField.setLabelText(NewWizardMessages.getString("NewClassWizardPage.classname.label"));
        this.fBaseClassDialogField = new StringButtonDialogField(adapter);
        this.fBaseClassDialogField.setDialogFieldListener(adapter);
        this.fBaseClassDialogField.setLabelText(NewWizardMessages.getString("NewClassWizardPage.baseclass.label"));
        this.fBaseClassDialogField.setButtonLabel(NewWizardMessages.getString("NewClassWizardPage.baseclass.button"));
        String[] buttonNames1 = new String[]{NewWizardMessages.getString("NewClassWizardPage.baseclass.access.public"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.protected"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.private"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.access")};
        this.fAccessButtons = new SelectionButtonDialogFieldGroup(16, buttonNames1, 4);
        this.fAccessButtons.setDialogFieldListener(adapter);
        this.fAccessButtons.setLabelText(NewWizardMessages.getString("NewClassWizardPage.baseclass.access.label"));
        this.fAccessButtons.setSelection(0, true);
        String[] buttonNames2 = new String[]{NewWizardMessages.getString("NewClassWizardPage.constdest.inline"), NewWizardMessages.getString("NewClassWizardPage.constdest.virtualdestructor"), NewWizardMessages.getString("NewClassWizardPage.constdest.includeguard")};
        this.fConstDestButtons = new SelectionButtonDialogFieldGroup(32, buttonNames2, 3);
        this.fConstDestButtons.setDialogFieldListener(adapter);
        this.fConstDestButtons.setSelection(1, true);
        this.fConstDestButtons.setSelection(2, true);
        this.linkedResourceGroupForHeader = new LinkToFileGroup(adapter, this);
        this.linkedResourceGroupForHeader.setDialogFieldListener(adapter);
        this.linkedResourceGroupForHeader.setLabelText(NewWizardMessages.getString("NewClassWizardPage.files.header"));
        this.linkedResourceGroupForBody = new LinkToFileGroup(adapter, this);
        this.linkedResourceGroupForBody.setDialogFieldListener(adapter);
        this.linkedResourceGroupForBody.setLabelText(NewWizardMessages.getString("NewClassWizardPage.files.body"));
        this.fClassNameStatus = new StatusInfo();
        ((StatusInfo)this.fClassNameStatus).setError(NewWizardMessages.getString("NewClassWizardPage.error.EnterClassName"));
        this.fBaseClassStatus = new StatusInfo();
        this.fLinkedResourceGroupForHeaderStatus = new StatusInfo();
        this.fLinkedResourceGroupForBodyStatus = new StatusInfo();
    }

    public void init() {
        this.eSelection = this.getSelectionCElement(this.currentSelection);
        this.fSelectedProject = this.getSelectionProject(this.currentSelection);
        this.fClassScope = new TypeSearchScope();
        this.fClassScope.add(this.fSelectedProject);
        IResource resource = this.getSelectionResourceElement(this.currentSelection);
        if (resource != null) {
            this.defaultSourceFolder = resource.getFullPath();
        }
        if (this.fSelectedProject != null && this.hasCppNature && this.defaultSourceFolder != null) {
            this.fAccessButtons.setEnabled(false);
            this.setPageComplete(false);
        } else {
            this.eSelection = null;
            this.defaultSourceFolder = null;
            StatusInfo status = new StatusInfo();
            status.setError(NewWizardMessages.getString("NewClassWizardPage.error.NotAvailableForNonCppProjects"));
            this.updateStatus(status);
        }
    }

    public void createControl(Composite parent) {
        if (!this.hasCppNature) {
            this.setControl((Control)new Composite(parent, 0));
            return;
        }
        int nColumns = 5;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(nColumns, false));
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createClassNameControls(composite, nColumns);
        this.createBaseClassControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createFilesControls(composite, nColumns);
        composite.layout();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createClassNameControls(Composite composite, int nColumns) {
        this.fClassNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fClassNameDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void createBaseClassControls(Composite composite, int nColumns) {
        this.fBaseClassDialogField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)this.fBaseClassDialogField.getTextControl(null), this.getMaxFieldWidth());
        this.createAccessControls(composite, nColumns);
    }

    protected void createAccessControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fAccessButtons.getLabelControl(composite), 1);
        Composite control = this.fAccessButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite);
    }

    protected void createModifierControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fConstDestButtons.getLabelControl(composite), 1);
        Composite control = this.fConstDestButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 1;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite);
    }

    protected void createFilesControls(Composite composite, int nColumns) {
        this.linkedResourceGroupForHeader.doFillIntoGrid(composite, nColumns);
        this.linkedResourceGroupForBody.doFillIntoGrid(composite, nColumns);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    public void handleEvent(Event event) {
    }

    private void classPageChangeControlPressed(DialogField field) {
        ITypeInfo info;
        if (field == this.fBaseClassDialogField && (info = this.chooseBaseClass()) != null) {
            this.fBaseClassDialogField.setText(info.getQualifiedTypeName().getFullyQualifiedName());
        }
    }

    private void classPageCustomButtonPressed(DialogField field, int index) {
    }

    private void classPageDialogFieldChanged(DialogField field) {
        String text;
        if (field == this.fClassNameDialogField) {
            text = this.fClassNameDialogField.getText();
            if (!this.linkedResourceGroupForHeader.linkCreated()) {
                if (text.length() > 0) {
                    this.linkedResourceGroupForHeader.setText(String.valueOf(text) + ".h");
                } else {
                    this.linkedResourceGroupForHeader.setText(text);
                }
            }
            if (!this.linkedResourceGroupForBody.linkCreated()) {
                if (text.length() > 0) {
                    this.linkedResourceGroupForBody.setText(String.valueOf(text) + ".cpp");
                } else {
                    this.linkedResourceGroupForBody.setText(text);
                }
            }
            this.fClassNameStatus = this.classNameChanged();
        }
        if (field == this.fBaseClassDialogField) {
            text = this.fBaseClassDialogField.getText();
            this.fAccessButtons.setEnabled(text.length() > 0);
            this.fBaseClassStatus = this.baseClassNameChanged();
        }
        if (field == this.linkedResourceGroupForHeader) {
            this.fLinkedResourceGroupForHeaderStatus = this.linkedResourceGroupChanged(this.linkedResourceGroupForHeader, true);
        }
        if (field == this.linkedResourceGroupForBody) {
            this.fLinkedResourceGroupForBodyStatus = this.linkedResourceGroupChanged(this.linkedResourceGroupForBody, false);
        }
        this.doStatusUpdate();
    }

    IStatus linkedResourceGroupChanged(LinkToFileGroup linkedGroup, boolean isHeader) {
        StatusInfo status = new StatusInfo();
        if (linkedGroup.linkCreated()) {
            String text = linkedGroup.getText();
            if (text == null || text.length() == 0) {
                if (isHeader) {
                    status.setError(NewWizardMessages.getString("NewClassWizardPage.error.EnterHeaderFile"));
                } else {
                    status.setError(NewWizardMessages.getString("NewClassWizardPage.error.EnterBodyFile"));
                }
            } else {
                IPath filePath = this.getContainerFullPath(linkedGroup);
                boolean validFile = false;
                if (filePath != null) {
                    File f = filePath.toFile();
                    boolean bl = validFile = f != null && f.exists() && f.isFile();
                }
                if (!validFile) {
                    if (isHeader) {
                        status.setError(NewWizardMessages.getString("NewClassWizardPage.error.NoHeaderFile"));
                    } else {
                        status.setError(NewWizardMessages.getString("NewClassWizardPage.error.NoBodyFile"));
                    }
                }
            }
        } else {
            String text = this.fClassNameDialogField.getText();
            if (isHeader) {
                if (text.length() > 0) {
                    linkedGroup.setText(String.valueOf(text) + ".h");
                } else {
                    linkedGroup.setText(text);
                }
            } else if (text.length() > 0) {
                linkedGroup.setText(String.valueOf(text) + ".cpp");
            } else {
                linkedGroup.setText(text);
            }
        }
        return status;
    }

    public boolean selectionIsCpp() {
        return this.hasCppNature;
    }

    private boolean isSelectionCPP(IStructuredSelection sel) {
        IProject project = this.getSelectionProject(sel);
        if (project != null) {
            return CoreModel.hasCCNature((IProject)project);
        }
        return false;
    }

    private ICElement getSelectionCElement(IStructuredSelection selection) {
        Object selectedElement;
        ICProject elem = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)selectedElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((elem = (ICElement)adaptable.getAdapter((Class)clazz)) == null) {
                IResource resource;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)adaptable.getAdapter((Class)clazz2)) != null && resource.getType() != 8) {
                    while (elem == null && resource.getType() != 4) {
                        resource = resource.getParent();
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        elem = (ICElement)resource.getAdapter((Class)clazz3);
                    }
                    if (elem == null) {
                        elem = CoreModel.getDefault().create(resource);
                    }
                }
            }
        }
        if (elem == null || elem.getElementType() == 10) {
            try {
                ICProject[] projects = CoreModel.create((IWorkspaceRoot)CUIPlugin.getWorkspace().getRoot()).getCProjects();
                if (projects.length == 1) {
                    elem = projects[0];
                }
            }
            catch (CModelException cModelException) {}
        }
        return elem;
    }

    private IResource getSelectionResourceElement(IStructuredSelection selection) {
        Object selectedElement;
        IResource resource = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)selectedElement;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) != null && resource instanceof IFile) {
                resource = resource.getParent();
            }
        }
        return resource;
    }

    private IProject getSelectionProject(IStructuredSelection selection) {
        Object selectedElement;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable) {
            IResource resource;
            IAdaptable adaptable = (IAdaptable)selectedElement;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) != null) {
                return resource.getProject();
            }
        }
        return null;
    }

    private ITypeInfo[] findClassElementsInProject() {
        if (this.eSelection == null) {
            return null;
        }
        if (this.elementsOfTypeClassInProject != null) {
            return this.elementsOfTypeClassInProject;
        }
        if (!AllTypesCache.isCacheUpToDate((ITypeSearchScope)this.fClassScope)) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.updateCache((ITypeSearchScope)NewClassWizardPage.this.fClassScope, (IProgressMonitor)monitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            try {
                this.getContainer().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                String title = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.exception.title");
                String message = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.exception.message");
                ExceptionHandler.handle(e, title, message);
                this.elementsOfTypeClassInProject = new ITypeInfo[0];
                return this.elementsOfTypeClassInProject;
            }
            catch (InterruptedException interruptedException) {
                this.elementsOfTypeClassInProject = new ITypeInfo[0];
                return this.elementsOfTypeClassInProject;
            }
        }
        this.elementsOfTypeClassInProject = AllTypesCache.getTypes((ITypeSearchScope)this.fClassScope, (int[])this.fClassTypes);
        Arrays.sort(this.elementsOfTypeClassInProject, this.TYPE_NAME_COMPARATOR);
        return this.elementsOfTypeClassInProject;
    }

    protected ITypeInfo chooseBaseClass() {
        Object[] elementsFound = this.findClassElementsInProject();
        if (elementsFound == null || elementsFound.length == 0) {
            String title = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.noclasses.title");
            String message = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.noclasses.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return null;
        }
        BaseClassSelectionDialog dialog = new BaseClassSelectionDialog(this.getShell());
        dialog.setElements(elementsFound);
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        return (ITypeInfo)dialog.getFirstResult();
    }

    public String getNewClassName() {
        return this.fClassNameDialogField.getText();
    }

    public String getBaseClassName() {
        return this.fBaseClassDialogField.getText();
    }

    public boolean isIncludeGuard() {
        return this.fConstDestButtons.isSelected(2);
    }

    public boolean isVirtualDestructor() {
        return this.fConstDestButtons.isSelected(1);
    }

    public boolean isInline() {
        return this.fConstDestButtons.isSelected(0);
    }

    public String getAccess() {
        if (this.fAccessButtons.isSelected(0)) {
            return "public";
        }
        if (this.fAccessButtons.isSelected(1)) {
            return "protected";
        }
        if (this.fAccessButtons.isSelected(2)) {
            return "private";
        }
        return "";
    }

    public ITranslationUnit getCreatedClassHeaderFile() {
        return this.parentHeaderTU;
    }

    public ITranslationUnit getCreatedClassBodyFile() {
        return this.parentBodyTU;
    }

    public ICElement getCreatedClassElement() {
        return this.createdClass;
    }

    public IStructure getBaseClassElement() {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createClass(IProgressMonitor monitor) {
        block20: {
            Object var8_12;
            String lineDelimiter;
            block19: {
                ITypeInfo[] classElements;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(NewWizardMessages.getString("NewTypeWizardPage.operationdesc"), 10);
                String baseClassName = this.getBaseClassName();
                ITypeInfo baseClass = null;
                if (baseClassName != null && baseClassName.length() > 0 && (baseClass = this.findInList(classElements = this.findClassElementsInProject(), (IQualifiedTypeName)new QualifiedTypeName(baseClassName))) != null && baseClass.getResolvedReference() == null) {
                    final ITypeInfo[] typesToResolve = new ITypeInfo[]{baseClass};
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                            AllTypesCache.resolveTypeLocation((ITypeInfo)typesToResolve[0], (IProgressMonitor)progressMonitor);
                            if (progressMonitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                        }
                    };
                    try {
                        this.getContainer().run(true, true, runnable);
                    }
                    catch (InvocationTargetException e) {
                        String title = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.exception.title");
                        String message = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.exception.message");
                        ExceptionHandler.handle(e, title, message);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                }
                lineDelimiter = null;
                lineDelimiter = System.getProperty("line.separator", "\n");
                this.parentHeaderTU = this.createTranslationUnit(this.linkedResourceGroupForHeader, true);
                this.parentBodyTU = this.createTranslationUnit(this.linkedResourceGroupForBody, false);
                monitor.worked(1);
                if (this.parentHeaderTU != null && !this.parentHeaderTU.isReadOnly()) {
                    String header = this.constructHeaderFileContent(this.parentHeaderTU, lineDelimiter, baseClass);
                    IWorkingCopy headerWC = null;
                    try {
                        try {
                            headerWC = this.parentHeaderTU.getSharedWorkingCopy(null, CUIPlugin.getDefault().getBufferFactory());
                            headerWC.getBuffer().append(header);
                            headerWC.reconcile();
                            headerWC.commit(true, monitor);
                            this.createdClass = headerWC.getElement(this.getNewClassName());
                        }
                        catch (CModelException cme) {
                            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString((String)"WizardNewFileCreationPage.internalErrorTitle"), (String)cme.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        if (headerWC != null) {
                            headerWC.destroy();
                        }
                        throw throwable;
                    }
                    {
                        var8_12 = null;
                        if (headerWC == null) break block19;
                    }
                    headerWC.destroy();
                }
            }
            if (this.parentBodyTU != null && !this.parentBodyTU.isReadOnly()) {
                String body = this.constructBodyFileContent(lineDelimiter);
                IWorkingCopy bodyWC = null;
                try {
                    try {
                        bodyWC = this.parentBodyTU.getSharedWorkingCopy(null, CUIPlugin.getDefault().getBufferFactory());
                        bodyWC.getBuffer().append(body);
                        bodyWC.reconcile();
                        bodyWC.commit(true, monitor);
                    }
                    catch (CModelException cme) {
                        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString((String)"WizardNewFileCreationPage.internalErrorTitle"), (String)cme.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    var8_12 = null;
                    if (bodyWC != null) {
                        bodyWC.destroy();
                    }
                    throw throwable;
                }
                {
                    var8_12 = null;
                    if (bodyWC == null) break block20;
                }
                bodyWC.destroy();
            }
        }
        monitor.done();
        return true;
    }

    protected ITranslationUnit createTranslationUnit(LinkToFileGroup linkedGroup, boolean isHeader) {
        ICElement element;
        ITranslationUnit createdUnit = null;
        IFile createdFile = null;
        createdFile = this.createNewFile(linkedGroup, isHeader);
        if (createdFile != null && (element = CoreModel.getDefault().create(createdFile)) instanceof ITranslationUnit) {
            createdUnit = (ITranslationUnit)element;
        }
        return createdUnit;
    }

    protected IFile createNewFile(LinkToFileGroup linkedGroup, boolean isHeader) {
        final IFile newFileHandle = this.createFileHandle(linkedGroup, isHeader);
        if (newFileHandle.exists()) {
            return newFileHandle;
        }
        final IPath newFilePath = this.getContainerFullPath(linkedGroup);
        final boolean isLinkedFile = linkedGroup.linkCreated();
        final IPath containerPath = this.getContainerPath(linkedGroup);
        final InputStream initialContents = this.getInitialContents();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                try {
                    monitor.beginTask(WorkbenchMessages.getString((String)"WizardNewFileCreationPage.progress"), 2000);
                    if (!NewClassWizardPage.this.containerExists(containerPath)) {
                        ContainerGenerator generator = new ContainerGenerator(containerPath);
                        generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    }
                    NewClassWizardPage.this.createFile(newFileHandle, initialContents, newFilePath, isLinkedFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString((String)"WizardNewFileCreationPage.errorTitle"), null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                WorkbenchPlugin.log((String)MessageFormat.format("Exception in {0}.getNewFile(): {1}", ((Object)((Object)this)).getClass().getName(), e.getTargetException()));
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString((String)"WizardNewFileCreationPage.internalErrorTitle"), (String)WorkbenchMessages.format((String)"WizardNewFileCreationPage.internalErrorMessage", (Object[])new Object[]{e.getTargetException().getMessage()}));
            }
            return null;
        }
        return newFileHandle;
    }

    protected IFile createFileHandle(LinkToFileGroup linkedGroup, boolean isHeader) {
        IPath filePath;
        IWorkspaceRoot root = CUIPlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(filePath = this.getContainerFullPath(linkedGroup));
        if (newFile == null) {
            newFile = root.getFile(filePath);
        }
        return newFile;
    }

    protected void createFile(IFile fileHandle, InputStream contents, IPath linkTargetPath, boolean isLinkedFile, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            if (isLinkedFile) {
                fileHandle.createLink(linkTargetPath, 16, monitor);
            } else {
                fileHandle.create(contents, false, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IPath getContainerPath(LinkToFileGroup linkedGroup) {
        if (linkedGroup.linkCreated()) {
            String pathName = linkedGroup.getResolvedPath();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            Path containerPath = new Path(pathName);
            return containerPath.removeLastSegments(1).removeTrailingSeparator().makeAbsolute();
        }
        return this.defaultSourceFolder;
    }

    protected IPath getContainerFullPath(LinkToFileGroup linkedGroup) {
        if (linkedGroup.linkCreated()) {
            String pathName = linkedGroup.getResolvedPath();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(pathName).makeAbsolute();
        }
        String pathName = linkedGroup.getText();
        IPath containerPath = this.defaultSourceFolder;
        containerPath.addTrailingSeparator();
        return containerPath.append(pathName).makeAbsolute();
    }

    protected IPath getHeaderFullPath() {
        String pathName = String.valueOf(this.getNewClassName()) + ".h";
        IPath containerPath = this.defaultSourceFolder;
        return containerPath.append(pathName).makeAbsolute();
    }

    protected IPath getBodyFullPath() {
        String pathName = String.valueOf(this.getNewClassName()) + ".cpp";
        IPath containerPath = this.defaultSourceFolder;
        return containerPath.append(pathName).makeAbsolute();
    }

    protected boolean containerExists(IPath containerPath) {
        IContainer container = null;
        IWorkspaceRoot root = CUIPlugin.getWorkspace().getRoot();
        container = root.getContainerForLocation(containerPath);
        return container != null;
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected String getClassComment(ITranslationUnit parentTU) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.javadoc")) {
            try {
                StringBuffer className = new StringBuffer();
                className.append(this.getNewClassName());
                String comment = CodeGeneration.getClassComment(parentTU, className.toString(), String.valueOf('\n'));
                if (comment != null && this.isValidComment(comment)) {
                    return comment;
                }
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e);
            }
        }
        return null;
    }

    protected String constructHeaderFileContent(ITranslationUnit header, String lineDelimiter, ITypeInfo baseClass) {
        StringBuffer text = new StringBuffer();
        boolean extendingBase = false;
        String baseClassName = this.getBaseClassName();
        String baseClassFileName = "";
        boolean systemIncludePath = false;
        if (baseClass != null) {
            extendingBase = true;
            ITypeReference location = baseClass.getResolvedReference();
            if (location != null) {
                IPath projectPath = this.fSelectedProject.getFullPath();
                IPath relativePath = location.getRelativeIncludePath(this.fSelectedProject);
                if (!relativePath.equals((Object)location.getLocation())) {
                    systemIncludePath = true;
                } else if (projectPath.isPrefixOf(location.getPath()) && projectPath.isPrefixOf(header.getPath())) {
                    relativePath = location.getRelativePath(header.getPath());
                }
                baseClassFileName = relativePath.toString();
            }
        }
        if (baseClassFileName.length() == 0) {
            baseClassFileName = String.valueOf(baseClassName) + ".h";
        }
        if (this.isIncludeGuard()) {
            text.append("#ifndef ");
            text.append(this.getNewClassName().toUpperCase());
            text.append("_H");
            text.append(lineDelimiter);
            text.append("#define ");
            text.append(this.getNewClassName().toUpperCase());
            text.append("_H");
            text.append(lineDelimiter);
            text.append(lineDelimiter);
        }
        if (extendingBase && !header.getElementName().equals(baseClassFileName)) {
            text.append("#include ");
            if (systemIncludePath) {
                text.append('<');
            } else {
                text.append('\"');
            }
            text.append(baseClassFileName);
            if (systemIncludePath) {
                text.append('>');
            } else {
                text.append('\"');
            }
            text.append(lineDelimiter);
            text.append(lineDelimiter);
        }
        text.append("class ");
        text.append(this.getNewClassName());
        if (extendingBase) {
            text.append(" : ");
            text.append(this.getAccess());
            text.append(" ");
            text.append(baseClassName);
        }
        text.append("{");
        text.append(lineDelimiter);
        text.append("public:");
        text.append(lineDelimiter);
        text.append(lineDelimiter);
        text.append('\t');
        text.append(this.getNewClassName());
        text.append("()");
        if (this.isInline()) {
            text.append(" {}");
            text.append(lineDelimiter);
        } else {
            text.append(";");
            text.append(lineDelimiter);
        }
        text.append('\t');
        if (this.isVirtualDestructor()) {
            text.append("virtual ");
        }
        text.append("~");
        text.append(this.getNewClassName());
        text.append("()");
        if (this.isInline()) {
            text.append(" {}");
            text.append(lineDelimiter);
        } else {
            text.append(";");
            text.append(lineDelimiter);
        }
        text.append("};");
        text.append(lineDelimiter);
        if (this.isIncludeGuard()) {
            text.append(lineDelimiter);
            text.append("#endif // ");
            text.append(this.getNewClassName().toUpperCase());
            text.append("_H");
            text.append(lineDelimiter);
        }
        return text.toString();
    }

    protected String constructBodyFileContent(String lineDelimiter) {
        StringBuffer text = new StringBuffer();
        if (this.getCreatedClassHeaderFile() != null) {
            text.append("#include \"");
            text.append(this.getCreatedClassHeaderFile().getElementName());
        }
        text.append("\"");
        text.append(lineDelimiter);
        text.append(lineDelimiter);
        if (this.isInline()) {
            return text.toString();
        }
        text.append(this.getNewClassName());
        text.append("::");
        text.append(this.getNewClassName());
        text.append("()");
        text.append(lineDelimiter);
        text.append("{}");
        text.append(lineDelimiter);
        text.append(this.getNewClassName());
        text.append("::~");
        text.append(this.getNewClassName());
        text.append("()");
        text.append(lineDelimiter);
        text.append("{}");
        text.append(lineDelimiter);
        return text.toString();
    }

    protected void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fClassNameStatus, this.fBaseClassStatus, this.fLinkedResourceGroupForHeaderStatus, this.fLinkedResourceGroupForBodyStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        this.updateStatus(StatusUtil.getMostSevere(status));
    }

    protected void updateStatus(IStatus status) {
        this.fCurrStatus = status;
        this.setPageComplete(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    protected boolean isValidComment(String template) {
        return true;
    }

    protected IStatus classNameChanged() {
        QualifiedTypeName typeName;
        ITypeInfo[] elementsFound;
        StatusInfo status = new StatusInfo();
        String className = this.getNewClassName();
        if (className.length() == 0) {
            status.setError(NewWizardMessages.getString("NewClassWizardPage.error.EnterClassName"));
            return status;
        }
        if (className.indexOf("::") != -1) {
            status.setError(NewWizardMessages.getString("NewClassWizardPage.error.QualifiedName"));
            return status;
        }
        IStatus val = CConventions.validateClassName((String)className);
        if (val.getSeverity() == 4) {
            status.setError(NewWizardMessages.getFormattedString("NewClassWizardPage.error.InvalidClassName", val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(NewWizardMessages.getFormattedString("NewClassWizardPage.warning.ClassNameDiscouraged", val.getMessage()));
        }
        if (this.foundInList(elementsFound = this.findClassElementsInProject(), (IQualifiedTypeName)(typeName = new QualifiedTypeName(this.getNewClassName())))) {
            status.setError(NewWizardMessages.getString("NewClassWizardPage.error.ClassNameExists"));
        }
        return status;
    }

    protected IStatus baseClassNameChanged() {
        String baseClassName = this.getBaseClassName();
        StatusInfo status = new StatusInfo();
        if (baseClassName.length() == 0) {
            return status;
        }
        IStatus val = CConventions.validateClassName((String)baseClassName);
        if (val.getSeverity() == 4) {
            status.setError(NewWizardMessages.getString("NewClassWizardPage.error.InvalidBaseClassName"));
            return status;
        }
        ITypeInfo[] elementsFound = this.findClassElementsInProject();
        if (!this.foundInList(elementsFound, (IQualifiedTypeName)new QualifiedTypeName(baseClassName))) {
            status.setWarning(NewWizardMessages.getString("NewClassWizardPage.warning.BaseClassNotExists"));
        }
        return status;
    }

    private boolean foundInList(ITypeInfo[] elements, IQualifiedTypeName typeName) {
        return this.findInList(elements, typeName) != null;
    }

    private ITypeInfo findInList(ITypeInfo[] elements, IQualifiedTypeName typeName) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        UnknownTypeInfo key = new UnknownTypeInfo(typeName);
        int index = Arrays.binarySearch(elements, key, this.TYPE_NAME_COMPARATOR);
        if (index >= 0 && index < elements.length) {
            ITypeInfo curr;
            int i = index - 1;
            while (i >= 0) {
                curr = elements[i];
                if (!key.getName().equals(curr.getName())) break;
                if (key.getQualifiedTypeName().equals(curr.getQualifiedTypeName())) {
                    return curr;
                }
                --i;
            }
            i = index;
            while (i < elements.length) {
                curr = elements[i];
                if (!key.getName().equals(curr.getName())) break;
                if (key.getQualifiedTypeName().equals(curr.getQualifiedTypeName())) {
                    return curr;
                }
                ++i;
            }
        }
        return null;
    }

    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        TypeFieldsAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewClassWizardPage.this.classPageChangeControlPressed(field);
        }

        public void customButtonPressed(ListDialogField field, int index) {
            NewClassWizardPage.this.classPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            NewClassWizardPage.this.classPageDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
        }
    }
}

