/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTVariable
extends ASTSymbol
implements IASTVariable {
    private final IASTExpression constructorExpression;
    private final ASTQualifiedNamedElement qualifiedName;
    private NamedOffsets offsets = new NamedOffsets();
    private final IASTExpression bitfieldExpression;
    private final IASTInitializerClause initializerClause;
    private final IASTAbstractDeclaration abstractDeclaration;
    protected List references;

    public ASTVariable(ISymbol newSymbol, IASTAbstractDeclaration abstractDeclaration, IASTInitializerClause initializerClause, IASTExpression bitfieldExpression, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, List references, IASTExpression constructorExpression, boolean previouslyDeclared) {
        super(newSymbol);
        this.abstractDeclaration = abstractDeclaration;
        this.initializerClause = initializerClause;
        this.bitfieldExpression = bitfieldExpression;
        this.constructorExpression = constructorExpression;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.references = references;
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), newSymbol.getName());
    }

    public boolean isAuto() {
        return this.symbol.getTypeInfo().checkBit(1);
    }

    public boolean isRegister() {
        return this.symbol.getTypeInfo().checkBit(2);
    }

    public boolean isStatic() {
        return this.symbol.getTypeInfo().checkBit(4);
    }

    public boolean isExtern() {
        return this.symbol.getTypeInfo().checkBit(8);
    }

    public boolean isMutable() {
        return this.symbol.getTypeInfo().checkBit(16);
    }

    public IASTAbstractDeclaration getAbstractDeclaration() {
        return this.abstractDeclaration;
    }

    public String getName() {
        return this.getSymbol().getName();
    }

    public IASTInitializerClause getInitializerClause() {
        return this.initializerClause;
    }

    public boolean isBitfield() {
        return this.bitfieldExpression != null;
    }

    public IASTExpression getBitfieldExpression() {
        return this.bitfieldExpression;
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public IASTScope getOwnerScope() {
        return (IASTScope)((Object)this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptVariable(this);
        }
        catch (Exception exception) {}
        manager.processReferences(this.references, requestor);
        this.references = null;
        if (this.initializerClause != null) {
            this.initializerClause.acceptElement(requestor, manager);
        }
        if (this.constructorExpression != null) {
            this.constructorExpression.acceptElement(requestor, manager);
        }
        if (this.getAbstractDeclaration() != null) {
            this.getAbstractDeclaration().acceptElement(requestor, manager);
        }
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setNameEndOffsetAndLineNumber(offset, lineNumber);
    }

    public IASTExpression getConstructorExpression() {
        return this.constructorExpression;
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }
}

