/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.expression;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTExpressionEvaluationException;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;

public class ASTExpression
implements IASTExpression {
    private final IASTExpression.Kind kind;
    private static final String EMPTY_STRING = "";

    public ASTExpression(IASTExpression.Kind kind) {
        this.kind = kind;
    }

    public IASTExpression.Kind getExpressionKind() {
        return this.kind;
    }

    public IASTExpression getLHSExpression() {
        return null;
    }

    public IASTExpression getRHSExpression() {
        return null;
    }

    public String getLiteralString() {
        return EMPTY_STRING;
    }

    public IASTTypeId getTypeId() {
        return null;
    }

    public IASTExpression.IASTNewExpressionDescriptor getNewExpressionDescriptor() {
        return null;
    }

    public IASTExpression getThirdExpression() {
        return null;
    }

    public long evaluateExpression() throws ASTExpressionEvaluationException {
        if (this.getExpressionKind() == IASTExpression.Kind.PRIMARY_INTEGER_LITERAL) {
            try {
                if (this.getLiteralString().startsWith("0x") || this.getLiteralString().startsWith("0x")) {
                    return Integer.parseInt(this.getLiteralString().substring(2), 16);
                }
                if (this.getLiteralString().startsWith("0") && this.getLiteralString().length() > 1) {
                    return Integer.parseInt(this.getLiteralString().substring(1), 8);
                }
                return Integer.parseInt(this.getLiteralString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ASTExpressionEvaluationException();
            }
        }
        if (this.getExpressionKind() == IASTExpression.Kind.PRIMARY_BRACKETED_EXPRESSION) {
            return this.getLHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.UNARY_NOT_CASTEXPRESSION) {
            return this.getLHSExpression().evaluateExpression() == 0L ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.MULTIPLICATIVE_MULTIPLY) {
            return this.getLHSExpression().evaluateExpression() * this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.MULTIPLICATIVE_DIVIDE) {
            return this.getLHSExpression().evaluateExpression() / this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.MULTIPLICATIVE_MODULUS) {
            return this.getLHSExpression().evaluateExpression() % this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.ADDITIVE_PLUS) {
            return this.getLHSExpression().evaluateExpression() + this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.ADDITIVE_MINUS) {
            return this.getLHSExpression().evaluateExpression() - this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.SHIFT_LEFT) {
            return this.getLHSExpression().evaluateExpression() << (int)this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.SHIFT_RIGHT) {
            return this.getLHSExpression().evaluateExpression() >> (int)this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.RELATIONAL_LESSTHAN) {
            return this.getLHSExpression().evaluateExpression() < this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.RELATIONAL_GREATERTHAN) {
            return this.getLHSExpression().evaluateExpression() > this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.RELATIONAL_LESSTHANEQUALTO) {
            return this.getLHSExpression().evaluateExpression() <= this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.RELATIONAL_GREATERTHANEQUALTO) {
            return this.getLHSExpression().evaluateExpression() >= this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.EQUALITY_EQUALS) {
            return this.getLHSExpression().evaluateExpression() == this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.EQUALITY_NOTEQUALS) {
            return this.getLHSExpression().evaluateExpression() != this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.ANDEXPRESSION) {
            return this.getLHSExpression().evaluateExpression() & this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.EXCLUSIVEOREXPRESSION) {
            return this.getLHSExpression().evaluateExpression() ^ this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.INCLUSIVEOREXPRESSION) {
            return this.getLHSExpression().evaluateExpression() | this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.LOGICALANDEXPRESSION) {
            return this.getLHSExpression().evaluateExpression() != 0L && this.getRHSExpression().evaluateExpression() != 0L ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.LOGICALOREXPRESSION) {
            return this.getLHSExpression().evaluateExpression() != 0L || this.getRHSExpression().evaluateExpression() != 0L ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.CONDITIONALEXPRESSION) {
            return this.getLHSExpression().evaluateExpression() != 0L ? this.getRHSExpression().evaluateExpression() : this.getThirdExpression().evaluateExpression();
        }
        throw new ASTExpressionEvaluationException();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public String getIdExpression() {
        return null;
    }

    public void reconcileReferences(IReferenceManager manager) throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }

    public void purgeReferences() throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }

    public IASTNode.ILookupResult lookup(String prefix, IASTNode.LookupKind[] k, IASTNode context, IASTExpression functionParameters) throws IASTNode.LookupError, ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }

    public void freeReferences(IReferenceManager manager) {
    }
}

