/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.extension.IScannerExtension;
import org.eclipse.cdt.internal.core.parser.scanner.ContextException;
import org.eclipse.cdt.internal.core.parser.scanner.FunctionMacroDescriptor;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerData;
import org.eclipse.cdt.internal.core.parser.scanner.ObjectMacroDescriptor;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContextInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerUtility;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;
import org.eclipse.cdt.internal.core.parser.util.TraceUtil;

public class GCCScannerExtension
implements IScannerExtension {
    protected static final ObjectMacroDescriptor STDC_VERSION_MACRO = new ObjectMacroDescriptor("__STDC_VERSION__", "199001L");
    protected static final ObjectMacroDescriptor STDC_HOSTED_MACRO = new ObjectMacroDescriptor("__STDC_HOSTED__", "0");
    protected static final ObjectMacroDescriptor CPLUSPLUS_MACRO = new ObjectMacroDescriptor("__cplusplus", "1");
    private static final String[] simpleIdentifiersDeclSpec = new String[1];
    private static final String[] simpleIdentifiersAttribute;
    protected static final String POUND_IDENT = "#ident";
    protected static final String POUND_WARNING = "#warning";
    protected static final String POUND_INCLUDE_NEXT = "#include_next";
    private static final String __CONST__ = "__const__";
    protected static final ObjectMacroDescriptor __CONST__MACRO;
    private static final String __CONST = "__const";
    protected static final ObjectMacroDescriptor __CONST_MACRO;
    private static final String __INLINE__ = "__inline__";
    protected static final ObjectMacroDescriptor __INLINE__MACRO;
    private static final String __VOLATILE__ = "__volatile__";
    protected static final ObjectMacroDescriptor __VOLATILE__MACRO;
    private static final String __SIGNED__ = "__signed__";
    private static final ObjectMacroDescriptor __SIGNED__MACRO;
    private static final String __RESTRICT = "__restrict";
    private static final String __RESTRICT__ = "__restrict__";
    private static final ObjectMacroDescriptor __RESTRICT__MACRO;
    private static final String __ASM__ = "__asm__";
    protected static final ObjectMacroDescriptor __ASM__MACRO;
    private static final String __TYPEOF__ = "__typeof__";
    protected static final ObjectMacroDescriptor __TYPEOF__MACRO;
    private static final String __ATTRIBUTE__ = "__attribute__";
    private static final String __DECLSPEC = "__declspec";
    private static final IToken[] EMPTY_TOKEN_ARRAY;
    protected static final FunctionMacroDescriptor DECLSPEC_MACRO;
    protected static final FunctionMacroDescriptor ATTRIBUTE_MACRO;
    private static final String __EXTENSION__ = "__extension__";
    private static final String EMPTY_STRING = "";
    protected static final ObjectMacroDescriptor EXTENSION_MACRO;
    private static final Set directives;
    private static final Map additionalCPPKeywords;
    private static final Map additionalCKeywords;
    private static final Map additionalCPPOperators;
    private static final Map additionalCOperators;
    private static final String MAX_OPERATOR = ">?";
    private static final String MIN_OPERATOR = "<?";

    static {
        GCCScannerExtension.simpleIdentifiersDeclSpec[0] = "x";
        simpleIdentifiersAttribute = new String[1];
        GCCScannerExtension.simpleIdentifiersAttribute[0] = "xyz";
        __CONST__MACRO = new ObjectMacroDescriptor(__CONST__, "const");
        __CONST_MACRO = new ObjectMacroDescriptor(__CONST, "const");
        __INLINE__MACRO = new ObjectMacroDescriptor(__INLINE__, "inline");
        __VOLATILE__MACRO = new ObjectMacroDescriptor(__VOLATILE__, "volatile");
        __SIGNED__MACRO = new ObjectMacroDescriptor(__SIGNED__, "signed");
        __RESTRICT__MACRO = new ObjectMacroDescriptor(__RESTRICT__, "restrict");
        __ASM__MACRO = new ObjectMacroDescriptor(__ASM__, "asm");
        __TYPEOF__MACRO = new ObjectMacroDescriptor(__TYPEOF__, "typeof");
        EMPTY_TOKEN_ARRAY = new IToken[0];
        DECLSPEC_MACRO = new FunctionMacroDescriptor(__ATTRIBUTE__, simpleIdentifiersDeclSpec, EMPTY_TOKEN_ARRAY, EMPTY_STRING);
        ATTRIBUTE_MACRO = new FunctionMacroDescriptor(__ATTRIBUTE__, simpleIdentifiersAttribute, EMPTY_TOKEN_ARRAY, EMPTY_STRING);
        EXTENSION_MACRO = new ObjectMacroDescriptor(__EXTENSION__, EMPTY_STRING);
        directives = new HashSet();
        directives.add(POUND_INCLUDE_NEXT);
        directives.add(POUND_WARNING);
        directives.add(POUND_IDENT);
        additionalCKeywords = new HashMap();
        additionalCKeywords.put("__alignof__", new Integer(141));
        additionalCKeywords.put("typeof", new Integer(140));
        additionalCPPKeywords = new HashMap(additionalCKeywords);
        additionalCPPKeywords.put("restrict", new Integer(137));
        additionalCOperators = new HashMap();
        additionalCPPOperators = new HashMap();
        additionalCPPOperators.put(MAX_OPERATOR, new Integer(142));
        additionalCPPOperators.put(MIN_OPERATOR, new Integer(143));
    }

    public String initializeMacroValue(IScannerData scannerData, String original) {
        if (original == null || original.trim().equals(EMPTY_STRING)) {
            return "1";
        }
        return original;
    }

    public void setupBuiltInMacros(IScannerData scannerData) {
        if (scannerData.getLanguage() == ParserLanguage.CPP && scannerData.getScanner().getDefinition("__cplusplus") == null) {
            scannerData.getScanner().addDefinition("__cplusplus", CPLUSPLUS_MACRO);
        }
        if (scannerData.getScanner().getDefinition("__STDC_HOSTED__") == null) {
            scannerData.getScanner().addDefinition("__STDC_HOSTED__", STDC_HOSTED_MACRO);
        }
        if (scannerData.getScanner().getDefinition("__STDC_VERSION__") == null) {
            scannerData.getScanner().addDefinition("__STDC_VERSION__", STDC_VERSION_MACRO);
        }
        if (scannerData.getScanner().getDefinition(__ATTRIBUTE__) == null) {
            scannerData.getPrivateDefinitions().put(__ATTRIBUTE__, ATTRIBUTE_MACRO);
        }
        if (scannerData.getScanner().getDefinition(__DECLSPEC) == null) {
            scannerData.getPrivateDefinitions().put(__DECLSPEC, DECLSPEC_MACRO);
        }
        if (scannerData.getScanner().getDefinition(__EXTENSION__) == null) {
            scannerData.getPrivateDefinitions().put(__EXTENSION__, EXTENSION_MACRO);
        }
        if (scannerData.getScanner().getDefinition(__CONST__) == null) {
            scannerData.getPrivateDefinitions().put(__CONST__, __CONST__MACRO);
        }
        if (scannerData.getScanner().getDefinition(__CONST) == null) {
            scannerData.getPrivateDefinitions().put(__CONST, __CONST_MACRO);
        }
        if (scannerData.getScanner().getDefinition(__INLINE__) == null) {
            scannerData.getPrivateDefinitions().put(__INLINE__, __INLINE__MACRO);
        }
        if (scannerData.getScanner().getDefinition(__SIGNED__) == null) {
            scannerData.getPrivateDefinitions().put(__SIGNED__, __SIGNED__MACRO);
        }
        if (scannerData.getScanner().getDefinition(__VOLATILE__) == null) {
            scannerData.getPrivateDefinitions().put(__VOLATILE__, __VOLATILE__MACRO);
        }
        ObjectMacroDescriptor __RESTRICT_MACRO = new ObjectMacroDescriptor(__RESTRICT, "restrict");
        if (scannerData.getScanner().getDefinition(__RESTRICT) == null) {
            scannerData.getPrivateDefinitions().put(__RESTRICT, __RESTRICT_MACRO);
        }
        if (scannerData.getScanner().getDefinition(__RESTRICT__) == null) {
            scannerData.getPrivateDefinitions().put(__RESTRICT__, __RESTRICT__MACRO);
        }
        if (scannerData.getScanner().getDefinition(__TYPEOF__) == null) {
            scannerData.getPrivateDefinitions().put(__TYPEOF__, __TYPEOF__MACRO);
        }
        if (scannerData.getLanguage() == ParserLanguage.CPP && scannerData.getScanner().getDefinition(__ASM__) == null) {
            scannerData.getPrivateDefinitions().put(__ASM__, __ASM__MACRO);
        }
    }

    public boolean canHandlePreprocessorDirective(String directive) {
        return directives.contains(directive);
    }

    public void handlePreprocessorDirective(IScannerData iscanner, String directive, String restOfLine) {
        if (directive.equals(POUND_INCLUDE_NEXT)) {
            TraceUtil.outputTrace(iscanner.getLogService(), "GCCScannerExtension handling #include_next directive", null, null, null, null);
            IScannerContext context = iscanner.getContextStack().getCurrentContext();
            if (context == null || context.getKind() != IScannerContext.ContextKind.INCLUSION) {
                return;
            }
            String fullInclusionPath = context.getContextName();
            IASTInclusion inclusion = ((ScannerContextInclusion)context).getExtension();
            Iterator iter = iscanner.getIncludePathNames().iterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                String completePath = ScannerUtility.createReconciledPath(path, inclusion.getName());
                if (completePath.equals(fullInclusionPath)) break;
            }
            ScannerUtility.InclusionDirective parsedDirective = null;
            try {
                parsedDirective = iscanner.parseInclusionDirective(restOfLine, iscanner.getContextStack().getCurrentContext().getOffset());
            }
            catch (ScannerUtility.InclusionParseException inclusionParseException) {
                return;
            }
            CodeReader duple = null;
            while (iter.hasNext()) {
                String path = (String)iter.next();
                String finalPath = ScannerUtility.createReconciledPath(path, parsedDirective.getFilename());
                duple = (CodeReader)iscanner.getFileCache().get(finalPath);
                if (duple == null && (duple = ScannerUtility.createReaderDuple(finalPath, iscanner.getClientRequestor(), iscanner.getWorkingCopies())) != null && duple.isFile()) {
                    iscanner.getFileCache().put(duple.filename, duple);
                }
                if (duple != null) break;
            }
            if (duple != null) {
                try {
                    iscanner.getContextStack().updateInclusionContext(duple, inclusion, iscanner.getClientRequestor());
                    TraceUtil.outputTrace(iscanner.getLogService(), "GCCScannerExtension handling #include_next directive successfully pushed on new include file");
                }
                catch (ContextException contextException) {
                    return;
                }
            }
        } else if (directive.equals(POUND_WARNING) || directive.equals(POUND_IDENT)) {
            return;
        }
    }

    public boolean offersDifferentIdentifierCharacters() {
        return true;
    }

    public boolean isValidIdentifierStartCharacter(int c) {
        return Character.isLetter((char)c) || c == 95 || c == 36;
    }

    public boolean isValidIdentifierCharacter(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95 || c == 36 || Character.isUnicodeIdentifierPart((char)c);
    }

    public boolean isExtensionKeyword(ParserLanguage language, String tokenImage) {
        if (language == ParserLanguage.CPP) {
            return additionalCPPKeywords.get(tokenImage) != null;
        }
        if (language == ParserLanguage.C) {
            return additionalCKeywords.get(tokenImage) != null;
        }
        return false;
    }

    public IToken createExtensionToken(IScannerData scannerData, String image) {
        Integer get = null;
        if (scannerData.getLanguage() == ParserLanguage.CPP) {
            get = (Integer)additionalCPPKeywords.get(image);
            if (get == null) {
                get = (Integer)additionalCPPOperators.get(image);
            }
        } else if (scannerData.getLanguage() == ParserLanguage.C && (get = (Integer)additionalCKeywords.get(image)) == null) {
            get = (Integer)additionalCOperators.get(image);
        }
        if (get == null) {
            return null;
        }
        return TokenFactory.createUniquelyImagedToken(get, image, scannerData);
    }

    public boolean isExtensionOperator(ParserLanguage language, String query) {
        if (language == ParserLanguage.CPP) {
            return additionalCPPOperators.get(query) != null;
        }
        if (language == ParserLanguage.C) {
            return additionalCOperators.get(query) != null;
        }
        return false;
    }
}

