/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IToken;

public class ObjectMacroDescriptor
implements IMacroDescriptor {
    private final String expansionSignature;
    private final String name;
    private final IToken token;
    private IToken[] tokenizedExpansion = null;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final IToken[] EMPTY_TOKEN_ARRAY = new IToken[0];

    public ObjectMacroDescriptor(String name, String expansionSignature) {
        this.name = name;
        this.expansionSignature = expansionSignature;
        this.token = null;
    }

    public ObjectMacroDescriptor(String name, IToken t, String expansionSignature) {
        this.name = name;
        this.token = t;
        this.expansionSignature = expansionSignature;
    }

    public IMacroDescriptor.MacroType getMacroType() {
        return IMacroDescriptor.MacroType.OBJECT_LIKE;
    }

    public String[] getParameters() {
        return EMPTY_STRING_ARRAY;
    }

    public IToken[] getTokenizedExpansion() {
        if (this.token == null) {
            return EMPTY_TOKEN_ARRAY;
        }
        if (this.tokenizedExpansion == null) {
            this.tokenizedExpansion = new IToken[1];
            this.tokenizedExpansion[0] = this.token;
        }
        return this.tokenizedExpansion;
    }

    public String getName() {
        return this.name;
    }

    public String getCompleteSignature() {
        StringBuffer signatureBuffer = new StringBuffer();
        signatureBuffer.append("#define ");
        signatureBuffer.append(this.name);
        signatureBuffer.append(' ');
        signatureBuffer.append(this.expansionSignature);
        return signatureBuffer.toString();
    }

    public boolean compatible(IMacroDescriptor descriptor) {
        if (descriptor.getName() == null) {
            return false;
        }
        if (descriptor.getMacroType() != this.getMacroType()) {
            return false;
        }
        if (!this.name.equals(descriptor.getName())) {
            return false;
        }
        String result = descriptor.getExpansionSignature();
        if (result == null) {
            return this.expansionSignature == null;
        }
        return result.equals(this.expansionSignature);
    }

    public String getExpansionSignature() {
        return this.expansionSignature;
    }

    public boolean isCircular() {
        int i = 0;
        while (i < this.getTokenizedExpansion().length) {
            IToken t = this.tokenizedExpansion[i];
            if (t.getType() == 1 && t.getImage().equals(this.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

