/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;

public class BasicTokenDuple
implements ITokenDuple {
    private int numSegments = -1;
    protected final IToken firstToken;
    protected final IToken lastToken;
    private static final String EMPTY_STRING = "";
    private String stringRepresentation = null;

    BasicTokenDuple(IToken first, IToken last) {
        this.firstToken = first;
        this.lastToken = last;
    }

    BasicTokenDuple(ITokenDuple firstDuple, ITokenDuple secondDuple) {
        this(firstDuple.getFirstToken(), secondDuple.getLastToken());
    }

    public IToken getFirstToken() {
        return this.firstToken;
    }

    public IToken getLastToken() {
        return this.lastToken;
    }

    public Iterator iterator() {
        return new TokenIterator();
    }

    public ITokenDuple getLastSegment() {
        Iterator iter = this.iterator();
        IToken first = null;
        IToken last = null;
        IToken token = null;
        while (iter.hasNext()) {
            token = (IToken)iter.next();
            if (first == null) {
                first = token;
            }
            if (token.getType() == 42) {
                token = TokenFactory.consumeTemplateIdArguments(token, iter);
            } else if (token.getType() == 3) {
                first = null;
                continue;
            }
            last = token;
        }
        List[] args = this.getTemplateIdArgLists();
        if (args != null && args[args.length - 1] != null) {
            ArrayList<List> newArgs = new ArrayList<List>(1);
            newArgs.add(args[args.length - 1]);
            return TokenFactory.createTokenDuple(first, last, newArgs);
        }
        return TokenFactory.createTokenDuple(first, last);
    }

    public ITokenDuple getLeadingSegments() {
        Iterator iter = this.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        int num = this.getSegmentCount();
        if (num <= 1) {
            return null;
        }
        IToken first = null;
        IToken last = null;
        IToken previous = null;
        IToken token = null;
        while (iter.hasNext()) {
            token = (IToken)iter.next();
            if (first == null) {
                first = token;
            }
            if (token.getType() == 42) {
                token = TokenFactory.consumeTemplateIdArguments(token, iter);
            } else if (token.getType() == 3) {
                last = previous;
                continue;
            }
            previous = token;
        }
        if (last == null) {
            return null;
        }
        if (this.getTemplateIdArgLists() != null) {
            List[] args = this.getTemplateIdArgLists();
            ArrayList<List> newArgs = new ArrayList<List>(args.length - 1);
            boolean foundArgs = false;
            int i = 0;
            while (i < args.length - 1) {
                newArgs.add(args[i]);
                if (args[i] != null) {
                    foundArgs = true;
                }
                ++i;
            }
            return TokenFactory.createTokenDuple(first, last, foundArgs ? newArgs : null);
        }
        return TokenFactory.createTokenDuple(first, last);
    }

    public int getSegmentCount() {
        if (this.numSegments == -1) {
            this.numSegments = this.calculateSegmentCount();
        }
        return this.numSegments;
    }

    public static String createStringRepresentation(IToken f, IToken l) {
        if (f == l) {
            return f.getImage();
        }
        StringBuffer buff = new StringBuffer();
        IToken prev = null;
        IToken iter = f;
        while (true) {
            if (prev != null && prev.getType() != 3 && prev.getType() != 1 && prev.getType() != 42 && prev.getType() != 34 && iter.getType() != 46 && prev.getType() != 10 && iter.getType() != 11 && iter.getType() != 3) {
                buff.append(' ');
            }
            if (iter == null) {
                return EMPTY_STRING;
            }
            buff.append(iter.getImage());
            if (iter == l) break;
            prev = iter;
            iter = iter.getNext();
        }
        return buff.toString();
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = BasicTokenDuple.createStringRepresentation(this.firstToken, this.lastToken);
        }
        return this.stringRepresentation;
    }

    public boolean isIdentifier() {
        return this.firstToken == this.lastToken && this.firstToken.getType() == 1;
    }

    public int length() {
        int count = 1;
        IToken i = this.firstToken;
        while (i != this.lastToken) {
            ++count;
            i = i.getNext();
        }
        return count;
    }

    public ITokenDuple getSubrange(int startIndex, int endIndex) {
        return TokenFactory.createTokenDuple(this.getToken(startIndex), this.getToken(endIndex));
    }

    public IToken getToken(int index) {
        if (index < 0) {
            return null;
        }
        IToken iter = this.firstToken;
        int count = 0;
        while (iter != this.lastToken) {
            iter = iter.getNext();
            if (count == index) {
                return iter;
            }
            ++count;
        }
        return null;
    }

    public int findLastTokenType(int type) {
        int count = 0;
        int lastFound = -1;
        IToken i = this.firstToken;
        while (i != this.lastToken) {
            if (i.getType() == type) {
                lastFound = count;
            }
            ++count;
            i = i.getNext();
        }
        return lastFound;
    }

    public int getEndOffset() {
        return this.getLastToken().getEndOffset();
    }

    public int getLineNumber() {
        return this.getFirstToken().getLineNumber();
    }

    public int getStartOffset() {
        return this.getFirstToken().getOffset();
    }

    public List[] getTemplateIdArgLists() {
        return null;
    }

    public boolean syntaxOfName() {
        IToken iter = this.firstToken;
        while (iter != this.lastToken) {
            if (iter.isOperator()) {
                iter = iter.getNext();
                continue;
            }
            switch (iter.getType()) {
                case 1: 
                case 3: 
                case 34: 
                case 95: {
                    iter = iter.getNext();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ITokenDuple)) {
            return false;
        }
        return ((ITokenDuple)other).getFirstToken().equals(this.getFirstToken()) && ((ITokenDuple)other).getLastToken().equals(this.getLastToken());
    }

    public String extractNameFromTemplateId() {
        ITokenDuple nameDuple = this.getLastSegment();
        Iterator i = nameDuple.iterator();
        if (!i.hasNext()) {
            return EMPTY_STRING;
        }
        StringBuffer nameBuffer = new StringBuffer();
        IToken token = (IToken)i.next();
        nameBuffer.append(token.getImage());
        if (!i.hasNext()) {
            return nameBuffer.toString();
        }
        if (token.getType() == 34) {
            token = (IToken)i.next();
            nameBuffer.append(token.getImage());
        } else if (token.getType() == 95) {
            token = (IToken)i.next();
            nameBuffer.append(' ');
            nameBuffer.append(token.getImage());
            if (!i.hasNext()) {
                return nameBuffer.toString();
            }
            if ((token.getType() == 92 || token.getType() == 72) && token.getNext().getType() == 10) {
                nameBuffer.append(' ');
                nameBuffer.append(((IToken)i.next()).getImage());
                nameBuffer.append(((IToken)i.next()).getImage());
            } else if (token.getType() == 10) {
                nameBuffer.append(((IToken)i.next()).getImage());
            } else if (token.getType() == 12) {
                nameBuffer.append(' ');
                nameBuffer.append(((IToken)i.next()).getImage());
            }
        }
        return nameBuffer.toString();
    }

    public boolean contains(ITokenDuple duple) {
        if (duple == null) {
            return false;
        }
        boolean foundFirst = false;
        boolean foundLast = false;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            IToken current = (IToken)i.next();
            if (current == this.firstToken) {
                foundFirst = true;
            }
            if (current == this.lastToken) {
                foundLast = true;
            }
            if (foundFirst && foundLast) break;
        }
        return foundFirst && foundLast;
    }

    public String[] toQualifiedName() {
        return this.generateQualifiedName();
    }

    private String[] generateQualifiedName() {
        ArrayList<String> qn = new ArrayList<String>();
        IToken i = this.firstToken;
        while (i != this.lastToken) {
            boolean compl = false;
            if (i.getType() == 3) {
                i = i.getNext();
                continue;
            }
            if (i.getType() == 34) {
                compl = true;
                i = i.getNext();
            }
            if (i.getType() == 1) {
                if (compl) {
                    StringBuffer buff = new StringBuffer("~");
                    buff.append(i.getImage());
                    qn.add(buff.toString());
                } else {
                    qn.add(i.getImage());
                }
            }
            i = i.getNext();
        }
        String[] qualifiedName = new String[qn.size()];
        return qn.toArray(qualifiedName);
    }

    protected int calculateSegmentCount() {
        int n = 1;
        Iterator iter = this.iterator();
        IToken token = null;
        while (iter.hasNext()) {
            token = (IToken)iter.next();
            if (token.getType() == 42) {
                token = TokenFactory.consumeTemplateIdArguments(token, iter);
            }
            if (token.getType() != 3) continue;
            ++n;
        }
        return n;
    }

    public void freeReferences(IReferenceManager manager) {
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    private class TokenIterator
    implements Iterator {
        private IToken iter;

        TokenIterator() {
            this.iter = BasicTokenDuple.this.firstToken;
        }

        public boolean hasNext() {
            return this.iter != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IToken temp = this.iter;
            this.iter = this.iter == BasicTokenDuple.this.lastToken ? null : this.iter.getNext();
            return temp;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

