/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class DebugConfiguration
implements ICDebugConfiguration {
    private IConfigurationElement fElement;
    private HashSet fModes;
    private HashSet fCPUs;

    public DebugConfiguration(IConfigurationElement element) {
        this.fElement = element;
    }

    private IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    public ICDebugger getDebugger() throws CoreException {
        return (ICDebugger)this.getConfigurationElement().createExecutableExtension("class");
    }

    public String getName() {
        String name = this.getConfigurationElement().getAttribute("name");
        return name != null ? name : "";
    }

    public String getID() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public String getPlatform() {
        String platform = this.getConfigurationElement().getAttribute("platform");
        if (platform == null) {
            return "*";
        }
        return platform;
    }

    public String[] getCPUList() {
        return this.getCPUs().toArray(new String[0]);
    }

    public String[] getModeList() {
        return this.getModes().toArray(new String[0]);
    }

    public boolean supportsMode(String mode) {
        return this.getModes().contains(mode);
    }

    public boolean supportsCPU(String cpu) {
        String nativeCPU = Platform.getOSArch();
        boolean ret = false;
        if (nativeCPU.startsWith(cpu)) {
            ret = this.getCPUs().contains("native");
        }
        return ret || this.getCPUs().contains(cpu) || this.getCPUs().contains("*");
    }

    protected Set getModes() {
        if (this.fModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return new HashSet(0);
            }
            StringTokenizer tokenizer = new StringTokenizer(modes, ",");
            this.fModes = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fModes.add(tokenizer.nextToken().trim());
            }
        }
        return this.fModes;
    }

    protected Set getCPUs() {
        if (this.fCPUs == null) {
            String cpus = this.getConfigurationElement().getAttribute("cpu");
            if (cpus == null) {
                this.fCPUs = new HashSet(1);
                this.fCPUs.add("native");
            } else {
                String nativeCPU = Platform.getOSArch();
                StringTokenizer tokenizer = new StringTokenizer(cpus, ",");
                this.fCPUs = new HashSet(tokenizer.countTokens());
                while (tokenizer.hasMoreTokens()) {
                    String cpu = tokenizer.nextToken().trim();
                    this.fCPUs.add(cpu);
                    if (!nativeCPU.startsWith(cpu)) continue;
                    this.fCPUs.add("native");
                }
            }
        }
        return this.fCPUs;
    }
}

