/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExpressionDialog
extends Dialog {
    private Button fBtnOk = null;
    private Text fTextExpression;
    private String fExpression = "";

    public ExpressionDialog(Shell parentShell, String expression) {
        super(parentShell);
        if (expression != null) {
            this.fExpression = expression;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ActionMessages.getString("ExpressionDialog.0"));
        shell.setImage(DebugPluginImages.getImage((String)"IMG_OBJS_EXPRESSION"));
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setOkButtonState();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        ((GridLayout)composite.getLayout()).marginWidth = 10;
        composite.setLayoutData((Object)new GridData(1808));
        this.createDataWidgets(composite);
        this.initializeDataWidgets();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fBtnOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createDataWidgets(Composite parent) {
        this.fTextExpression = this.createExpressionText(parent);
    }

    private void initializeDataWidgets() {
        this.fTextExpression.setText(this.fExpression);
        this.fTextExpression.setSelection(this.fExpression.length());
        this.fTextExpression.selectAll();
        this.setOkButtonState();
    }

    private Text createExpressionText(Composite parent) {
        Label label = new Label(parent, 131072);
        label.setText(ActionMessages.getString("ExpressionDialog.1"));
        Text text = new Text(parent, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        text.setLayoutData((Object)gridData);
        this.addModifyListener(text);
        return text;
    }

    protected void setOkButtonState() {
        if (this.fBtnOk == null) {
            return;
        }
        this.fBtnOk.setEnabled(this.fTextExpression.getText().trim().length() > 0);
    }

    private void storeData() {
        this.fExpression = this.fTextExpression.getText().trim();
    }

    private void addModifyListener(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExpressionDialog.this.setOkButtonState();
            }
        });
    }

    public String getExpression() {
        return this.fExpression;
    }

    protected void okPressed() {
        this.storeData();
        super.okPressed();
    }
}

