/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.signals;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.signals.SignalsViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.signals.SignalsViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.signals.SignalsViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class SignalsView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
INullSelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    protected Viewer createViewer(Composite parent) {
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        SignalsViewer vv = new SignalsViewer(parent, 770);
        vv.setContentProvider(this.createContentProvider());
        vv.setLabelProvider((IBaseLabelProvider)new SignalsViewLabelProvider());
        vv.setUseHashlookup(true);
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(new SignalsViewEventHandler(this));
        return vv;
    }

    protected void createActions() {
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.SIGNALS_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection == null) {
            this.setViewerInput((IStructuredSelection)new StructuredSelection());
        } else if (selection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    private IContentProvider createContentProvider() {
        SignalsViewContentProvider cp = new SignalsViewContentProvider();
        cp.setExceptionHandler(this);
        return cp;
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        Object input;
        ICDebugTarget target = null;
        if (ssel != null && ssel.size() == 1 && (input = ssel.getFirstElement()) instanceof IDebugElement && ((IDebugElement)input).getDebugTarget() instanceof ICDebugTarget) {
            target = (ICDebugTarget)((IDebugElement)input).getDebugTarget();
        }
        if (this.getViewer() == null) {
            return;
        }
        Object current = this.getViewer().getInput();
        if (current != null && current.equals(target)) {
            this.updateObjects();
            return;
        }
        this.showViewer();
        this.getViewer().setInput(target);
        this.updateObjects();
    }

    protected void becomesHidden() {
        this.setViewerInput((IStructuredSelection)new StructuredSelection());
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IViewPart part = this.getSite().getPage().findView("org.eclipse.debug.ui.DebugView");
        if (part != null) {
            ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            this.selectionChanged((IWorkbenchPart)part, selection);
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public class SignalsViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getModelPresentation().getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ICSignal) {
                try {
                    switch (columnIndex) {
                        case 0: {
                            return ((ICSignal)element).getName();
                        }
                        case 1: {
                            return ((ICSignal)element).isPassEnabled() ? SignalsViewer.YES_VALUE : SignalsViewer.NO_VALUE;
                        }
                        case 2: {
                            return ((ICSignal)element).isStopEnabled() ? SignalsViewer.YES_VALUE : SignalsViewer.NO_VALUE;
                        }
                        case 3: {
                            return ((ICSignal)element).getDescription();
                        }
                    }
                }
                catch (DebugException debugException) {}
            }
            return null;
        }

        private IDebugModelPresentation getModelPresentation() {
            return CDebugUIPlugin.getDebugModelPresentation();
        }
    }
}

