/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.actions;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateManagedProjectAction
implements IWorkbenchWindowActionDelegate {
    private static final String ID_CYGWIN = "cygwin";
    private static final String ID_DEBUG = "debug";
    private static final String ID_DIRS = "dirs";
    private static final String ID_EXE = "exe";
    private static final String ID_EXEC = "exec";
    private static final String ID_GENERAL = "general";
    private static final String ID_GNU = "gnu";
    private static final String ID_INCPATHS = "incpaths";
    private static final String ID_INCLUDE = "include";
    private static final String ID_LINUX = "linux";
    private static final String ID_OPTION = "option";
    private static final String ID_OPTIONS = "options";
    private static final String ID_PATHS = "paths";
    private static final String ID_PREPROC = "preprocessor";
    private static final String ID_RELEASE = "release";
    private static final String ID_SEPARATOR = ".";
    private static final String ID_SHARED = "so";
    private static final String ID_SOLARIS = "solaris";
    private static final String ID_STATIC = "lib";
    private static final String NEW_CONFIG_ROOT = "cdt.managedbuild.config.gnu";
    private static final String NEW_CYGWIN_TARGET_ROOT = "cdt.managedbuild.target.gnu.cygwin";
    private static final String NEW_POSIX_TARGET_ROOT = "cdt.managedbuild.target.gnu";
    private static final String NEW_TOOL_ROOT = "cdt.managedbuild.tool.gnu";
    private static final String TOOL_LANG_BOTH = "both";
    private static final String TOOL_LANG_C = "c";
    private static final String TOOL_LANG_CPP = "cpp";
    private static final String TOOL_NAME_AR = "ar";
    private static final String TOOL_NAME_ARCHIVER = "archiver";
    private static final String TOOL_NAME_COMPILER = "compiler";
    private static final String TOOL_NAME_LIB = "lib";
    private static final String TOOL_NAME_LINK = "link";
    private static final String TOOL_NAME_LINKER = "linker";
    private static final String TOOL_NAME_SOLINK = "solink";
    private static final int TOOL_TYPE_COMPILER = 0;
    private static final int TOOL_TYPE_LINKER = 1;
    private static final int TOOL_TYPE_ARCHIVER = 2;
    private static final int TYPE_EXE = 0;
    private static final int TYPE_SHARED = 1;
    private static final int TYPE_STATIC = 2;

    protected static void backupFile(IFile settingsFile, IProgressMonitor monitor, IProject project) throws CoreException {
        IProject destFolder = project;
        String newName = String.valueOf(settingsFile.getName()) + "_12backup";
        IFile backupFile = destFolder.getFile((IPath)new Path(newName));
        if (backupFile.exists()) {
            Shell shell = ManagedBuilderUIPlugin.getDefault().getShell();
            boolean shouldUpdate = MessageDialog.openQuestion((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString("ManagedBuildConvert.12x.warning.title"), (String)ManagedBuilderUIMessages.getFormattedString("ManagedBuildConvert.12x.warning.message", project.getName()));
            if (shouldUpdate) {
                backupFile.delete(true, monitor);
            } else {
                monitor.setCanceled(true);
                throw new OperationCanceledException(ManagedBuilderUIMessages.getFormattedString("ManagedBuildConvert.12x.cancelled.message", project.getName()));
            }
        }
        settingsFile.copy(backupFile.getFullPath(), true, monitor);
    }

    protected static void convertConfiguration(ITarget newTarget, ITarget newParent, Element oldConfig, IProgressMonitor monitor) {
        IConfiguration newParentConfig = null;
        IConfiguration newConfig = null;
        boolean cygwin = false;
        boolean debug = false;
        int type = -1;
        String parentId = oldConfig.getAttribute("parent");
        StringTokenizer idTokens = new StringTokenizer(parentId, ID_SEPARATOR);
        while (idTokens.hasMoreTokens()) {
            String id = idTokens.nextToken();
            if (id.equalsIgnoreCase(ID_CYGWIN)) {
                cygwin = true;
                continue;
            }
            if (id.equalsIgnoreCase(ID_EXEC)) {
                type = 0;
                continue;
            }
            if (id.equalsIgnoreCase(ID_SHARED)) {
                type = 1;
                continue;
            }
            if (id.equalsIgnoreCase("lib")) {
                type = 2;
                continue;
            }
            if (!id.equalsIgnoreCase(ID_DEBUG)) continue;
            debug = true;
        }
        String defId = "cdt.managedbuild.config.gnu.";
        if (cygwin) {
            defId = String.valueOf(defId) + "cygwin.";
        }
        switch (type) {
            case 0: {
                defId = String.valueOf(defId) + ID_EXE;
                break;
            }
            case 1: {
                defId = String.valueOf(defId) + ID_SHARED;
                break;
            }
            case 2: {
                defId = String.valueOf(defId) + "lib";
            }
        }
        defId = String.valueOf(defId) + ID_SEPARATOR + (debug ? ID_DEBUG : ID_RELEASE);
        newParentConfig = newParent.getConfiguration(defId);
        Random rand = new Random();
        rand.setSeed(System.currentTimeMillis());
        int randomElement = rand.nextInt();
        if (randomElement < 0) {
            randomElement *= -1;
        }
        newConfig = newTarget.createConfiguration(newParentConfig, String.valueOf(defId) + ID_SEPARATOR + randomElement);
        NodeList toolRefNodes = oldConfig.getElementsByTagName("toolReference");
        int refIndex = 0;
        while (refIndex < toolRefNodes.getLength()) {
            UpdateManagedProjectAction.convertToolRef(newConfig, (Element)toolRefNodes.item(refIndex), monitor);
            ++refIndex;
        }
        monitor.worked(1);
    }

    protected static void convertOptionRef(IConfiguration newConfig, ITool newTool, Element optRef) {
        int dirIndex;
        int generalIndex;
        String toolToken;
        String langToken;
        String optId = optRef.getAttribute("id");
        if (optId == null) {
            return;
        }
        String[] idTokens = optId.split("\\.");
        Vector<String> newIdVector = new Vector<String>(idTokens.length + 2);
        int index = 1;
        while (index < idTokens.length) {
            newIdVector.add(idTokens[index]);
            ++index;
        }
        if (!((String)newIdVector.firstElement()).equals(ID_GNU)) {
            newIdVector.add(0, ID_GNU);
        }
        if (!(langToken = (String)newIdVector.get(1)).equals(TOOL_LANG_C)) {
            if (langToken.equals("lib") || langToken.equals(TOOL_NAME_AR)) {
                newIdVector.add(1, TOOL_LANG_BOTH);
            } else {
                newIdVector.add(1, TOOL_LANG_CPP);
            }
        }
        if ((toolToken = (String)newIdVector.get(2)).equals(ID_PREPROC)) {
            newIdVector.add(2, TOOL_NAME_COMPILER);
        } else if (toolToken.equals(TOOL_NAME_LINKER) || toolToken.equals(TOOL_NAME_SOLINK)) {
            newIdVector.remove(2);
            newIdVector.add(2, TOOL_NAME_LINK);
        } else if (toolToken.equals(TOOL_NAME_AR)) {
            newIdVector.remove(2);
            newIdVector.add(2, "lib");
        }
        String optionToken = (String)newIdVector.get(3);
        if (optionToken.equals(ID_OPTIONS)) {
            newIdVector.remove(3);
        }
        newIdVector.add(3, ID_OPTION);
        String badToken = (String)newIdVector.lastElement();
        if (badToken.equals(ID_INCPATHS)) {
            newIdVector.addElement(ID_INCLUDE);
            newIdVector.addElement(ID_PATHS);
        }
        if ((generalIndex = newIdVector.indexOf(ID_GENERAL)) != -1) {
            newIdVector.remove(generalIndex);
        }
        if ((dirIndex = newIdVector.indexOf(ID_DIRS)) != -1) {
            newIdVector.remove(dirIndex);
        }
        String newOptionId = new String();
        int rebuildIndex = 0;
        while (rebuildIndex < newIdVector.size()) {
            String token = (String)newIdVector.get(rebuildIndex);
            newOptionId = String.valueOf(newOptionId) + token;
            if (rebuildIndex < newIdVector.size() - 1) {
                newOptionId = String.valueOf(newOptionId) + ID_SEPARATOR;
            }
            ++rebuildIndex;
        }
        IOption newOpt = newTool.getOptionById(newOptionId);
        if (newOpt == null) {
            return;
        }
        try {
            switch (newOpt.getValueType()) {
                case 0: {
                    Boolean bool = new Boolean(optRef.getAttribute("defaultValue"));
                    newConfig.setOption(newOpt, bool.booleanValue());
                    break;
                }
                case 1: 
                case 2: {
                    String name = optRef.getAttribute("defaultValue");
                    String idValue = newOpt.getEnumeratedId(name);
                    newConfig.setOption(newOpt, idValue != null ? idValue : name);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    Vector<String> values = new Vector<String>();
                    NodeList nodes = optRef.getElementsByTagName("listOptionValue");
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Boolean isBuiltIn;
                        Node node = nodes.item(i);
                        if (node.getNodeType() == 1 && !(isBuiltIn = new Boolean(((Element)node).getAttribute("builtIn"))).booleanValue()) {
                            values.add(((Element)node).getAttribute("value"));
                        }
                        ++i;
                    }
                    newConfig.setOption(newOpt, values.toArray(new String[values.size()]));
                }
            }
        }
        catch (BuildException buildException) {
            return;
        }
    }

    protected static ITarget convertTarget(IProject project, Element oldTarget, IProgressMonitor monitor) {
        ITarget newTarget = null;
        ITarget newParent = null;
        int type = -1;
        boolean posix = false;
        String id = oldTarget.getAttribute("parent");
        StringTokenizer idTokens = new StringTokenizer(id, ID_SEPARATOR);
        while (idTokens.hasMoreTokens()) {
            String token = idTokens.nextToken();
            if (token.equals(ID_LINUX) || token.equals(ID_SOLARIS)) {
                posix = true;
                continue;
            }
            if (token.equalsIgnoreCase(ID_EXEC)) {
                type = 0;
                continue;
            }
            if (token.equalsIgnoreCase(ID_SHARED)) {
                type = 1;
                continue;
            }
            if (!token.equalsIgnoreCase(ID_SHARED)) continue;
            type = 1;
        }
        String defID = String.valueOf(posix ? NEW_POSIX_TARGET_ROOT : NEW_CYGWIN_TARGET_ROOT) + ID_SEPARATOR;
        switch (type) {
            case 0: {
                defID = String.valueOf(defID) + ID_EXE;
                break;
            }
            case 1: {
                defID = String.valueOf(defID) + ID_SHARED;
                break;
            }
            case 2: {
                defID = String.valueOf(defID) + "lib";
            }
        }
        newParent = ManagedBuildManager.getTarget((IResource)project, (String)defID);
        if (newParent == null) {
            return null;
        }
        try {
            newTarget = ManagedBuildManager.createTarget((IResource)project, (ITarget)newParent);
            newTarget.setArtifactName(oldTarget.getAttribute("artifactName"));
            NodeList configNodes = oldTarget.getElementsByTagName("configuration");
            int configIndex = 0;
            while (configIndex < configNodes.getLength()) {
                UpdateManagedProjectAction.convertConfiguration(newTarget, newParent, (Element)configNodes.item(configIndex), monitor);
                ++configIndex;
            }
        }
        catch (BuildException buildException) {}
        monitor.worked(1);
        return newTarget;
    }

    protected static void convertToolRef(IConfiguration newConfig, Element oldToolRef, IProgressMonitor monitor) {
        String oldToolId = oldToolRef.getAttribute("id");
        String newToolId = NEW_TOOL_ROOT;
        boolean cppFlag = true;
        int toolType = -1;
        StringTokenizer idTokens = new StringTokenizer(oldToolId, ID_SEPARATOR);
        while (idTokens.hasMoreTokens()) {
            String token = idTokens.nextToken();
            if (token.equals(TOOL_LANG_C)) {
                cppFlag = false;
                continue;
            }
            if (token.equalsIgnoreCase(TOOL_NAME_COMPILER)) {
                toolType = 0;
                continue;
            }
            if (token.equalsIgnoreCase(TOOL_NAME_AR)) {
                toolType = 2;
                continue;
            }
            if (token.equalsIgnoreCase("lib")) {
                toolType = 2;
                continue;
            }
            if (token.equalsIgnoreCase(TOOL_NAME_LINK)) {
                toolType = 1;
                continue;
            }
            if (!token.equalsIgnoreCase(TOOL_NAME_SOLINK)) continue;
            toolType = 1;
        }
        newToolId = String.valueOf(newToolId) + ID_SEPARATOR + (cppFlag ? TOOL_LANG_CPP : TOOL_LANG_C) + ID_SEPARATOR;
        switch (toolType) {
            case 0: {
                newToolId = String.valueOf(newToolId) + TOOL_NAME_COMPILER;
                break;
            }
            case 1: {
                newToolId = String.valueOf(newToolId) + TOOL_NAME_LINKER;
                break;
            }
            case 2: {
                newToolId = String.valueOf(newToolId) + TOOL_NAME_ARCHIVER;
            }
        }
        ITool newTool = newConfig.getToolById(newToolId);
        NodeList optRefs = oldToolRef.getElementsByTagName("optionReference");
        int refIndex = optRefs.getLength() - 1;
        while (refIndex >= 0) {
            UpdateManagedProjectAction.convertOptionRef(newConfig, newTool, (Element)optRefs.item(refIndex));
            --refIndex;
        }
        monitor.worked(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void doProjectUpdate(IProgressMonitor monitor, IProject project) throws CoreException {
        String[] projectName = new String[]{project.getName()};
        IFile settingsFile = project.getFile(".cdtbuild");
        if (!settingsFile.exists()) {
            monitor.done();
            return;
        }
        monitor.beginTask(ManagedBuilderUIMessages.getFormattedString("ManagedBuildConvert.12x.monitor.message.backup", projectName), 1);
        UpdateManagedProjectAction.backupFile(settingsFile, monitor, project);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        try {
            try {
                InputStream stream = settingsFile.getContents();
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(stream);
                NodeList targetNodes = document.getElementsByTagName("target");
                int listSize = targetNodes.getLength();
                monitor.beginTask(ManagedBuilderUIMessages.getFormattedString("ManagedBuildConvert.12x.monitor.message.project", projectName), listSize * 9);
                int targIndex = 0;
                while (true) {
                    if (targIndex >= listSize) {
                        ((ManagedBuildInfo)info).setVersion(ManagedBuildManager.getBuildInfoVersion().toString());
                    }
                    Element oldTarget = (Element)targetNodes.item(targIndex);
                    String oldTargetId = oldTarget.getAttribute("id");
                    ITarget newTarget = UpdateManagedProjectAction.convertTarget(project, oldTarget, monitor);
                    if (newTarget != null) {
                        info.removeTarget(oldTargetId);
                        monitor.worked(9);
                    }
                    ++targIndex;
                }
            }
            catch (ParserConfigurationException e) {
                ManagedBuilderUIPlugin.log(e);
            }
            catch (FactoryConfigurationError e) {
                ManagedBuilderUIPlugin.log(e);
            }
            catch (SAXException e) {
                ManagedBuilderUIPlugin.log(e);
            }
            catch (IOException e) {
                ManagedBuilderUIPlugin.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)false);
            monitor.done();
            throw throwable;
        }
        {
            Object var14_20 = null;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)false);
        monitor.done();
    }

    public static IProject[] getVersion12Projects() {
        IProject[] projects = ManagedBuilderUIPlugin.getWorkspace().getRoot().getProjects();
        Vector<IProject> result = new Vector<IProject>();
        int index = projects.length - 1;
        while (index >= 0) {
            block5: {
                if (projects[index].isAccessible()) {
                    IManagedBuildInfo info;
                    IProjectDescription description;
                    try {
                        description = projects[index].getDescription();
                    }
                    catch (CoreException coreException) {
                        break block5;
                    }
                    if (description != null && description.hasNature(ManagedCProjectNature.MNG_NATURE_ID) && (info = ManagedBuildManager.getBuildInfo((IResource)projects[index])) != null && info.getVersion() == null) {
                        result.add(projects[index]);
                    }
                }
            }
            --index;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public static void run(boolean fork, IRunnableContext context, final IProject project) {
        try {
            context.run(fork, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(this, project){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ IProject val$project;
                            {
                                this.this$1 = var1_1;
                                this.val$project = iProject;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                UpdateManagedProjectAction.doProjectUpdate(monitor, this.val$project);
                            }
                        };
                        ManagedBuilderUIPlugin.getWorkspace().run(runnable, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

