/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.debug.internal.core.breakpoints.AbstractLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CLineBreakpoint
extends AbstractLineBreakpoint {
    private static final String C_LINE_BREAKPOINT = "org.eclipse.cdt.debug.core.cLineBreakpointMarker";

    public CLineBreakpoint() {
    }

    public CLineBreakpoint(IResource resource, Map attributes, boolean add) throws CoreException {
        super(resource, CLineBreakpoint.getMarkerType(), attributes, add);
    }

    public static String getMarkerType() {
        return C_LINE_BREAKPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        int lineNumber;
        StringBuffer sb = new StringBuffer(BreakpointMessages.getString("CLineBreakpoint.1"));
        String fileName = this.ensureMarker().getResource().getName();
        if (fileName != null && fileName.length() > 0) {
            sb.append(' ');
            sb.append(fileName);
        }
        if ((lineNumber = this.getLineNumber()) > 0) {
            sb.append(MessageFormat.format(BreakpointMessages.getString("CLineBreakpoint.2"), new Integer(lineNumber)));
        }
        sb.append(this.getConditionText());
        return sb.toString();
    }
}

