/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

public abstract class AbstractCLaunchDelegate
extends LaunchConfigurationDelegate {
    private IProject project;
    private List orderedProjects;

    public abstract void launch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;

    protected String[] getEnvironmentArray(ILaunchConfiguration config) {
        Map env = null;
        try {
            env = config.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
        }
        catch (CoreException coreException) {}
        if (env == null) {
            return new String[0];
        }
        String[] array = new String[env.size()];
        Iterator entries = env.entrySet().iterator();
        int i = 0;
        while (entries.hasNext() && i < array.length) {
            Map.Entry entry = entries.next();
            array[i] = String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue();
            ++i;
        }
        return array;
    }

    protected Properties getEnvironmentProperty(ILaunchConfiguration config) {
        Properties prop = new Properties();
        Map env = null;
        try {
            env = config.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
        }
        catch (CoreException coreException) {}
        if (env == null) {
            return prop;
        }
        Iterator entries = env.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            prop.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return prop;
    }

    protected Properties getDefaultEnvironment() {
        return EnvironmentReader.getEnvVars();
    }

    protected Properties expandEnvironment(ILaunchConfiguration config) {
        return this.expandEnvironment(this.getEnvironmentProperty(config));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Properties expandEnvironment(Properties props) {
        block13: {
            Enumeration<?> names = props.propertyNames();
            if (names == null) break block13;
            while (names.hasMoreElements()) {
                int prev;
                String key = (String)names.nextElement();
                String value = props.getProperty(key);
                if (value == null || value.indexOf(36) == -1) continue;
                StringBuffer sb = new StringBuffer();
                StringBuffer param = new StringBuffer();
                int ch = prev = 10;
                boolean inMacro = false;
                boolean inSingleQuote = false;
                int i = 0;
                while (i < value.length()) {
                    block14: {
                        ch = value.charAt(i);
                        switch (ch) {
                            case 39: {
                                if (prev == 92) break;
                                inSingleQuote = !inSingleQuote;
                                break;
                            }
                            case 36: {
                                char c;
                                if (inSingleQuote || prev == 92 || i >= value.length() || value.indexOf(125, i) <= 0 || (c = value.charAt(i + 1)) != '{') break;
                                param.setLength(0);
                                inMacro = true;
                                prev = ch;
                                break block14;
                            }
                            case 125: {
                                Properties def;
                                if (!inMacro) break;
                                inMacro = false;
                                String v = null;
                                String p = param.toString();
                                if (!p.equals(key)) {
                                    v = props.getProperty(p);
                                }
                                if (v == null && (def = this.getDefaultEnvironment()) != null) {
                                    v = def.getProperty(p);
                                }
                                if (v != null) {
                                    sb.append(v);
                                }
                                param.setLength(0);
                                prev = ch;
                                break block14;
                            }
                        }
                        if (!inMacro) {
                            sb.append((char)ch);
                        } else if (ch != 123 || prev != 36) {
                            param.append((char)ch);
                        }
                        prev = ch == 92 && prev == 92 ? 10 : ch;
                    }
                    ++i;
                }
                props.setProperty(key, sb.toString());
            }
        }
        return props;
    }

    public File getWorkingDir(ILaunchConfiguration configuration) throws CoreException {
        return this.getWorkingDirectory(configuration);
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return this.verifyWorkingDirectory(configuration);
    }

    protected IPath getWorkingDirectoryPath(ILaunchConfiguration config) throws CoreException {
        String path = config.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        if (path != null) {
            return new Path(path);
        }
        return null;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        MultiStatus status = new MultiStatus(this.getPluginID(), code, message, exception);
        status.add((IStatus)new Status(4, this.getPluginID(), code, exception == null ? "" : exception.getLocalizedMessage(), exception));
        throw new CoreException((IStatus)status);
    }

    protected void cancel(String message, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(0, this.getPluginID(), code, message, null));
    }

    protected abstract String getPluginID();

    public static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = AbstractCLaunchDelegate.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    public static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
    }

    protected void setSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        if (launch.getSourceLocator() == null) {
            IPersistableSourceLocator sourceLocator;
            String id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (id == null) {
                ICProject cProject = AbstractCLaunchDelegate.getCProject(configuration);
                if (cProject == null) {
                    this.abort(LaunchUIPlugin.getResourceString("Launch.common.Project_does_not_exist"), null, 103);
                }
                sourceLocator = CDebugUIPlugin.createDefaultSourceLocator();
                sourceLocator.initializeDefaults(configuration);
            } else {
                sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                if (memento == null) {
                    sourceLocator.initializeDefaults(configuration);
                } else {
                    sourceLocator.initializeFromMemento(memento);
                }
            }
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    public String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
    }

    public String[] getProgramArgumentsArray(ILaunchConfiguration config) throws CoreException {
        return AbstractCLaunchDelegate.parseArguments(this.getProgramArguments(config));
    }

    private static String[] parseArguments(String args) {
        if (args == null) {
            return new String[0];
        }
        ArgumentParser parser = new ArgumentParser(args);
        String[] res = parser.parseArguments();
        return res;
    }

    protected ICDebugConfiguration getDebugConfig(ILaunchConfiguration config) throws CoreException {
        ICDebugConfiguration dbgCfg = null;
        try {
            dbgCfg = CDebugCorePlugin.getDefault().getDebugConfiguration(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", ""));
        }
        catch (CoreException e) {
            Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 106, LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Debugger_not_installed"), (Throwable)e);
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (handler != null) {
                Object result = handler.handleStatus((IStatus)status, (Object)this);
                boolean cfr_ignored_0 = result instanceof String;
            }
            throw e;
        }
        return dbgCfg;
    }

    protected String renderTargetLabel(ICDebugConfiguration debugConfig) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, debugConfig.getName(), timestamp);
    }

    protected String renderProcessLabel(String commandLine) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, commandLine, timestamp);
    }

    protected String renderDebuggerProcessLabel() {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Debugger_Process"), timestamp);
    }

    protected ICProject verifyCProject(ILaunchConfiguration config) throws CoreException {
        ICProject cproject;
        String name = AbstractCLaunchDelegate.getProjectName(config);
        if (name == null) {
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.C_Project_not_specified"), null, 102);
        }
        if ((cproject = AbstractCLaunchDelegate.getCProject(config)) == null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!project.exists()) {
                this.abort(LaunchUIPlugin.getFormattedResourceString("AbstractCLaunchDelegate.Project_NAME_does_not_exist", name), null, 103);
            } else if (!project.isOpen()) {
                this.abort(LaunchUIPlugin.getFormattedResourceString("AbstractCLaunchDelegate.Project_NAME_is_closed", name), null, 103);
            }
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Not_a_C_CPP_project"), null, 103);
        }
        return cproject;
    }

    protected IFile getProgramFile(ILaunchConfiguration config) throws CoreException {
        IFile programPath;
        ICProject cproject = this.verifyCProject(config);
        String fileName = AbstractCLaunchDelegate.getProgramName(config);
        if (fileName == null) {
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Program_file_not_specified"), null, 105);
        }
        if ((programPath = ((IProject)cproject.getResource()).getFile(fileName)) == null || !programPath.exists() || !programPath.getLocation().toFile().exists()) {
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Program_file_does_not_exist"), new FileNotFoundException(LaunchUIPlugin.getFormattedResourceString("AbstractCLaunchDelegate.PROGRAM_PATH_not_found", programPath.getLocation().toOSString())), 104);
        }
        return programPath;
    }

    protected IPath verifyProgramFile(ILaunchConfiguration config) throws CoreException {
        return this.getProgramFile(config).getLocation();
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            ICProject cp = AbstractCLaunchDelegate.getCProject(configuration);
            if (cp != null) {
                IProject p = cp.getProject();
                return p.getLocation().toFile();
            }
        } else if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Working_directory_does_not_exist"), new FileNotFoundException(LaunchUIPlugin.getFormattedResourceString("AbstractCLaunchDelegate.PROGRAM_PATH_not_found", path.toOSString())), 101);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Working_directory_does_not_exist"), new FileNotFoundException(LaunchUIPlugin.getFormattedResourceString("AbstractCLaunchDelegate.PROGRAM_PATH_does_not_exist", path.toOSString())), 101);
        }
        return null;
    }

    private void getReferencedProjectSet(IProject project, HashSet referencedProjSet) throws CoreException {
        IProject[] projects = project.getReferencedProjects();
        int i = 0;
        while (i < projects.length) {
            IProject refProject = projects[i];
            if (refProject.exists() && !referencedProjSet.contains(refProject)) {
                referencedProjSet.add(refProject);
                this.getReferencedProjectSet(refProject, referencedProjSet);
            }
            ++i;
        }
    }

    private List getBuildOrder(List resourceCollection) {
        String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (orderedNames != null) {
            ArrayList<Object> orderedProjects = new ArrayList<Object>(resourceCollection.size());
            ArrayList unorderedProjects = new ArrayList(resourceCollection.size());
            unorderedProjects.addAll(resourceCollection);
            int i = 0;
            while (i < orderedNames.length) {
                String projectName = orderedNames[i];
                int j = 0;
                while (j < resourceCollection.size()) {
                    IProject project = (IProject)resourceCollection.get(j);
                    if (project.getName().equals(projectName)) {
                        orderedProjects.add(project);
                        unorderedProjects.remove(project);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            orderedProjects.addAll(unorderedProjects);
            return orderedProjects;
        }
        IProject[] projects = new IProject[resourceCollection.size()];
        projects = resourceCollection.toArray(projects);
        IWorkspace.ProjectOrder po = ResourcesPlugin.getWorkspace().computeProjectOrder(projects);
        ArrayList<IProject> orderedProjects = new ArrayList<IProject>();
        orderedProjects.addAll(Arrays.asList(po.projects));
        return orderedProjects;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (this.orderedProjects != null) {
            monitor.beginTask(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.building_projects"), this.orderedProjects.size() + 1);
            Iterator i = this.orderedProjects.iterator();
            while (i.hasNext()) {
                IProject proj = (IProject)i.next();
                monitor.subTask(String.valueOf(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.building")) + proj.getName());
                proj.build(10, monitor);
            }
            monitor.subTask(String.valueOf(LaunchUIPlugin.getResourceString("AbstractLaunchConfigurationDelegate.building")) + this.project.getName());
            this.project.build(10, monitor);
        }
        monitor.done();
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean bl;
        try {
            boolean continueLaunch = true;
            if (this.orderedProjects != null) {
                IStatusHandler prompter;
                monitor.beginTask(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.searching_for_errors"), this.orderedProjects.size() + 1);
                boolean compileErrorsInProjs = false;
                Iterator i = this.orderedProjects.iterator();
                while (i.hasNext()) {
                    IProject proj = (IProject)i.next();
                    monitor.subTask(String.valueOf(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.searching_for_errors_in")) + proj.getName());
                    compileErrorsInProjs = this.existsErrors(proj);
                    if (compileErrorsInProjs) break;
                }
                if (!compileErrorsInProjs) {
                    monitor.subTask(String.valueOf(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.searching_for_errors_in")) + this.project.getName());
                    compileErrorsInProjs = this.existsErrors(this.project);
                }
                if (compileErrorsInProjs && (prompter = DebugPlugin.getDefault().getStatusHandler(LaunchConfigurationDelegate.promptStatus)) != null) {
                    continueLaunch = (Boolean)prompter.handleStatus(LaunchConfigurationDelegate.complileErrorPromptStatus, null);
                }
            }
            bl = continueLaunch;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return bl;
    }

    private boolean existsErrors(IProject proj) throws CoreException {
        IMarker[] markers = proj.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers.length > 0) {
            int j = 0;
            while (j < markers.length) {
                if ((Integer)markers[j].getAttribute("severity") == 2) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.subTask(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.20"));
        }
        this.orderedProjects = null;
        ICProject cProject = AbstractCLaunchDelegate.getCProject(configuration);
        if (cProject != null) {
            this.project = cProject.getProject();
            HashSet projectSet = new HashSet();
            this.getReferencedProjectSet(this.project, projectSet);
            this.orderedProjects = this.getBuildOrder(new ArrayList(projectSet));
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    private static class ArgumentParser {
        private String fArgs;
        private int fIndex = 0;
        private int ch = -1;

        public ArgumentParser(String args) {
            this.fArgs = args;
        }

        /*
         * Unable to fully structure code
         */
        public String[] parseArguments() {
            v = new ArrayList<String>();
            this.ch = this.getNext();
            ** GOTO lbl13
            {
                this.ch = this.getNext();
                do {
                    if (Character.isWhitespace((char)this.ch)) continue block0;
                    if (this.ch == 34) {
                        v.add(this.parseString());
                        continue;
                    }
                    v.add(this.parseToken());
lbl13:
                    // 3 sources

                } while (this.ch > 0);
            }
            result = new String[v.size()];
            v.toArray(result);
            return result;
        }

        private int getNext() {
            if (this.fIndex < this.fArgs.length()) {
                return this.fArgs.charAt(this.fIndex++);
            }
            return -1;
        }

        private String parseString() {
            StringBuffer buf = new StringBuffer();
            this.ch = this.getNext();
            while (this.ch > 0 && this.ch != 34) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch != 34) {
                        buf.append('\\');
                    }
                }
                if (this.ch <= 0) continue;
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            this.ch = this.getNext();
            return buf.toString();
        }

        private String parseToken() {
            StringBuffer buf = new StringBuffer();
            while (this.ch > 0 && !Character.isWhitespace((char)this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch > 0) {
                        if (this.ch != 34) {
                            buf.append('\\');
                        }
                        buf.append((char)this.ch);
                        this.ch = this.getNext();
                        continue;
                    }
                    if (this.ch != -1) continue;
                    buf.append('\\');
                    continue;
                }
                if (this.ch == 34) {
                    buf.append(this.parseString());
                    continue;
                }
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            return buf.toString();
        }
    }
}

