/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.IContainerDescriptor;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.ICPathContainerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class CPathContainerDescriptor
implements IContainerDescriptor {
    private IConfigurationElement fConfigElement;
    private static final String ATT_EXTENSION = "PathContainerPage";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ICON = "icon";
    private static final String ATT_PAGE_CLASS = "class";
    private Image pageImage;
    static /* synthetic */ Class class$0;

    public CPathContainerDescriptor(IConfigurationElement configElement) throws CoreException {
        this.fConfigElement = configElement;
        String id = this.fConfigElement.getAttribute(ATT_ID);
        String name = configElement.getAttribute(ATT_NAME);
        String pageClassName = configElement.getAttribute(ATT_PAGE_CLASS);
        if (name == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "Invalid extension (missing name): " + id, null));
        }
        if (pageClassName == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "Invalid extension (missing page class name): " + id, null));
        }
    }

    public ICPathContainerPage createPage() throws CoreException {
        Object elem = CoreUtility.createExtension(this.fConfigElement, ATT_PAGE_CLASS);
        if (elem instanceof ICPathContainerPage) {
            return (ICPathContainerPage)elem;
        }
        String id = this.fConfigElement.getAttribute(ATT_ID);
        throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "Invalid extension (page not of type IClasspathContainerPage): " + id, null));
    }

    public String getName() {
        return this.fConfigElement.getAttribute(ATT_NAME);
    }

    public Image getImage() {
        String imageName;
        if (this.pageImage == null && (imageName = this.fConfigElement.getAttribute(ATT_ICON)) != null) {
            Image image;
            IExtension extension = this.fConfigElement.getDeclaringExtension();
            String plugin = extension.getNamespace();
            this.pageImage = image = this.getImageFromPlugin(plugin, imageName);
        }
        return this.pageImage;
    }

    public Image getImageFromPlugin(String plugin, String subdirectoryAndFilename) {
        Bundle bundle = Platform.getBundle((String)plugin);
        URL iconURL = bundle.getEntry("/");
        return this.getImageFromURL(iconURL, subdirectoryAndFilename);
    }

    public Image getImageFromURL(URL installURL, String subdirectoryAndFilename) {
        Image image = null;
        try {
            URL newURL = new URL(installURL, subdirectoryAndFilename);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)newURL);
            image = desc.createImage();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (SWTException sWTException) {}
        return image;
    }

    public String getPageClass() {
        return this.fConfigElement.getAttribute(ATT_PAGE_CLASS);
    }

    public boolean canEdit(IPathEntry entry) {
        String id = this.fConfigElement.getAttribute(ATT_ID);
        if (entry.getEntryKind() == 5) {
            String type = entry.getPath().segment(0);
            return id.equals(type);
        }
        return false;
    }

    public static IContainerDescriptor[] getDescriptors() {
        ArrayList<CPathContainerDescriptor> containers = new ArrayList<CPathContainerDescriptor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", ATT_EXTENSION);
        if (extensionPoint != null) {
            CPathContainerDescriptor defaultPage = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerDefaultPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String defaultPageName = clazz.getName();
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                try {
                    CPathContainerDescriptor curr = new CPathContainerDescriptor(elements[i]);
                    if (defaultPageName.equals(curr.getPageClass())) {
                        defaultPage = curr;
                    } else {
                        containers.add(curr);
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
                ++i;
            }
            if (defaultPageName != null && containers.isEmpty()) {
                containers.add(defaultPage);
            }
        }
        return containers.toArray(new CPathContainerDescriptor[containers.size()]);
    }
}

