/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class BasicSearchMatch
implements IMatch,
Comparable {
    private static final String HASH_SEPERATOR = ":";
    public String name = null;
    public String parentName = null;
    public String returnType;
    public IResource resource = null;
    public IPath path = null;
    public int startOffset = 0;
    public int endOffset = 0;
    public int type = 0;
    public int visibility = 0;
    boolean isConst = false;
    boolean isVolatile = false;
    boolean isStatic = false;
    private int hashCode = 0;
    public IPath referringElement = null;

    public BasicSearchMatch() {
    }

    public BasicSearchMatch(BasicSearchMatch basicMatch) {
        this.name = basicMatch.name;
        this.parentName = basicMatch.parentName;
        this.returnType = basicMatch.returnType;
        this.resource = basicMatch.resource;
        this.path = basicMatch.path;
        this.startOffset = basicMatch.startOffset;
        this.endOffset = basicMatch.endOffset;
        this.referringElement = basicMatch.referringElement;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuffer hashBuffer = new StringBuffer();
            hashBuffer.append(this.name);
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.parentName);
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.returnType);
            if (this.getLocation() != null) {
                hashBuffer.append(HASH_SEPERATOR);
                hashBuffer.append(this.getLocation().toString());
            }
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.startOffset);
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.endOffset);
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.type);
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.visibility);
            this.hashCode = hashBuffer.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicSearchMatch)) {
            return false;
        }
        BasicSearchMatch match = (BasicSearchMatch)obj;
        if (this.startOffset != match.getStartOffset() || this.endOffset != match.getEndOffset()) {
            return false;
        }
        if (this.type != match.getElementType() || this.visibility != match.getVisibility()) {
            return false;
        }
        if (this.name != null && match.getName() != null ? !this.name.equals(match.getName()) : this.name != match.getName()) {
            return false;
        }
        if (this.parentName != null && match.getParentName() != null ? !this.parentName.equals(match.getParentName()) : this.parentName != match.getParentName()) {
            return false;
        }
        if (this.returnType != null && match.getReturnType() != null ? !this.returnType.equals(match.getReturnType()) : this.returnType != match.getReturnType()) {
            return false;
        }
        IPath thisPath = this.getLocation();
        IPath matchPath = match.getLocation();
        return !(thisPath != null && matchPath != null ? !thisPath.equals((Object)matchPath) : thisPath != matchPath);
    }

    public int compareTo(Object o) {
        if (!(o instanceof BasicSearchMatch)) {
            throw new ClassCastException();
        }
        BasicSearchMatch match = (BasicSearchMatch)o;
        int result = this.getLocation().toString().compareTo(match.getLocation().toString());
        if (result != 0) {
            return result;
        }
        result = this.getStartOffset() - match.getStartOffset();
        if (result != 0) {
            return result;
        }
        result = this.getName().compareTo(match.getName());
        if (result != 0) {
            return result;
        }
        result = this.getParentName().compareTo(match.getParentName());
        if (result != 0) {
            return result;
        }
        result = this.getReturnType().compareTo(match.getReturnType());
        return result;
    }

    public int getElementType() {
        return this.type;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public IResource getResource() {
        return this.resource;
    }

    public IPath getLocation() {
        if (this.resource != null) {
            return this.resource.getLocation();
        }
        if (this.path != null) {
            return this.path;
        }
        return null;
    }

    public IPath getReferenceLocation() {
        return this.referringElement;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public int getType() {
        return this.type;
    }

    public void setEndOffset(int i) {
        this.endOffset = i;
    }

    public void setConst(boolean b) {
        this.isConst = b;
    }

    public void setStatic(boolean b) {
        this.isStatic = b;
    }

    public void setVolatile(boolean b) {
        this.isVolatile = b;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParentName(String string) {
        this.parentName = string;
    }

    public void setReturnType(String string) {
        this.returnType = string;
    }

    public void setStartOffset(int i) {
        this.startOffset = i;
    }

    public void setType(int i) {
        this.type = i;
    }

    public void setVisibility(int i) {
        this.visibility = i;
    }
}

