/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CSearchScope
implements ICSearchScope {
    private ArrayList elements;
    private IPath[] paths;
    private boolean[] pathWithSubFolders;
    private int pathsCount;
    private IPath[] enclosingProjects;
    static /* synthetic */ Class class$0;

    public CSearchScope() {
        this.initialize();
    }

    protected void initialize() {
        this.paths = new IPath[1];
        this.pathWithSubFolders = new boolean[1];
        this.pathsCount = 0;
        this.enclosingProjects = new IPath[0];
    }

    private void addEnclosingProject(IPath path) {
        int length = this.enclosingProjects.length;
        int i = 0;
        while (i < length) {
            if (this.enclosingProjects[i].equals((Object)path)) {
                return;
            }
            ++i;
        }
        this.enclosingProjects = new IPath[length + 1];
        System.arraycopy(this.enclosingProjects, 0, this.enclosingProjects, 0, length);
        this.enclosingProjects[length] = path;
    }

    public void add(ICProject cProject, boolean includesPrereqProjects, HashSet visitedProjects) throws CModelException {
        IProject project = cProject.getProject();
        if (!project.isAccessible() || !visitedProjects.add(project)) {
            return;
        }
        this.addEnclosingProject(project.getFullPath());
        ICElement[] projChildren = cProject.getChildren();
        int i = 0;
        while (i < projChildren.length) {
            this.add(projChildren[i]);
            ++i;
        }
        if (includesPrereqProjects) {
            IProject[] refProjects = null;
            try {
                refProjects = project.getReferencedProjects();
            }
            catch (CoreException coreException) {}
            int i2 = 0;
            while (i2 < refProjects.length) {
                ICProject cProj;
                IProject iProject = refProjects[i2];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.core.model.ICElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((cProj = (ICProject)iProject.getAdapter((Class)clazz)) != null) {
                    this.add(cProj, true, visitedProjects);
                }
                ++i2;
            }
        }
    }

    public void add(IProject project, boolean includesPrereqProjects, HashSet visitedProjects) throws CModelException {
        if (!project.isAccessible() || !visitedProjects.add(project)) {
            return;
        }
        IProjectDescription projDesc = null;
        try {
            projDesc = project.getDescription();
        }
        catch (CoreException coreException) {}
        if (projDesc == null) {
            return;
        }
        String[] natures = projDesc.getNatureIds();
        boolean flag = false;
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals("org.eclipse.cdt.core.cnature")) {
                flag = true;
                break;
            }
            ++i;
        }
        if (!flag) {
            return;
        }
        this.addEnclosingProject(project.getFullPath());
        if (includesPrereqProjects) {
            IProject[] refProjects = null;
            try {
                refProjects = project.getReferencedProjects();
            }
            catch (CoreException coreException) {}
            int i2 = 0;
            while (i2 < refProjects.length) {
                ICProject cProj;
                IProject iProject = refProjects[i2];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.core.model.ICElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((cProj = (ICProject)iProject.getAdapter((Class)clazz)) != null) {
                    this.add(cProj, true, visitedProjects);
                }
                ++i2;
            }
        }
    }

    private void add(IPath path, boolean withSubFolders) {
        if (this.paths.length == this.pathsCount) {
            this.paths = new IPath[this.pathsCount * 2];
            System.arraycopy(this.paths, 0, this.paths, 0, this.pathsCount);
            this.pathWithSubFolders = new boolean[this.pathsCount * 2];
            System.arraycopy(this.pathWithSubFolders, 0, this.pathWithSubFolders, 0, this.pathsCount);
        }
        this.paths[this.pathsCount] = path;
        this.pathWithSubFolders[this.pathsCount++] = withSubFolders;
    }

    public boolean encloses(String resourcePathString) {
        Path resourcePath = new Path(resourcePathString);
        return this.encloses((IPath)resourcePath);
    }

    private boolean encloses(IPath path) {
        int i = 0;
        while (i < this.pathsCount) {
            IPath scopePath;
            if (this.pathWithSubFolders[i] ? this.paths[i].isPrefixOf(path) : (scopePath = this.paths[i]).isPrefixOf(path) && (scopePath.segmentCount() == path.segmentCount() - 1 || scopePath.segmentCount() == path.segmentCount())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean encloses(ICElement element) {
        if (this.elements != null) {
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                ICElement scopeElement = (ICElement)this.elements.get(i);
                ICElement searchedElement = element;
                while (searchedElement != null) {
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    searchedElement = searchedElement.getParent();
                }
                ++i;
            }
            return false;
        }
        return this.encloses(this.fullPath(element));
    }

    public IPath[] enclosingProjects() {
        return this.enclosingProjects;
    }

    private IPath fullPath(ICElement element) {
        return element.getPath();
    }

    public void add(ICElement element) {
        switch (element.getElementType()) {
            case 11: {
                break;
            }
            case 12: {
                this.add((ICContainer)element);
                break;
            }
            default: {
                if (element instanceof IMember) {
                    if (this.elements == null) {
                        this.elements = new ArrayList();
                    }
                    this.elements.add(element);
                }
                this.add(this.fullPath(element), true);
                ICElement parent = element.getParent();
                while (parent != null && !(parent instanceof ICProject)) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof ICProject)) break;
                this.addEnclosingProject(parent.getCProject().getProject().getFullPath());
            }
        }
    }

    public void add(ICContainer container) {
        ICElement[] children = null;
        try {
            children = container.getChildren();
        }
        catch (CModelException cModelException) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            this.add(children[i]);
            ++i;
        }
    }

    public void addFile(IPath filePath, IProject fileProject) {
        this.add(filePath, true);
        if (fileProject != null) {
            this.addEnclosingProject(fileProject.getFullPath());
        }
    }
}

