/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.SymbolIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTBaseSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ReferenceCache;
import org.eclipse.cdt.internal.core.parser.ast.complete.UnresolvedReferenceDuple;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTClassSpecifier
extends ASTScope
implements IASTClassSpecifier {
    private List declarations = null;
    private NamedOffsets offsets = new NamedOffsets();
    private final IASTClassSpecifier.ClassNameType classNameType;
    private final ASTClassKind classKind;
    private ASTAccessVisibility currentVisibility;
    private final ASTQualifiedNamedElement qualifiedName;
    private List references;
    private List unresolvedCrossReferences = new ArrayList();
    private boolean processingUnresolvedReferences = false;
    private List resolvedCrossReferences = new ArrayList();

    public ASTClassSpecifier(ISymbol symbol, ASTClassKind kind, IASTClassSpecifier.ClassNameType type, ASTAccessVisibility access, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, List references) {
        super(symbol);
        this.classKind = kind;
        this.classNameType = type;
        this.currentVisibility = access;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), symbol.getName());
        this.references = references;
    }

    public IASTClassSpecifier.ClassNameType getClassNameType() {
        return this.classNameType;
    }

    public ASTClassKind getClassKind() {
        return this.classKind;
    }

    public Iterator getBaseClauses() {
        return new BaseIterator((IDerivableContainerSymbol)this.getSymbol());
    }

    public ASTAccessVisibility getCurrentVisibilityMode() {
        return this.currentVisibility;
    }

    public void setCurrentVisibility(ASTAccessVisibility visibility) {
        this.currentVisibility = visibility;
    }

    public String getName() {
        return this.symbol.getName();
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        manager.processReferences(this.references, requestor);
        this.references = null;
        try {
            requestor.enterClassSpecifier(this);
        }
        catch (Exception exception) {}
        Iterator i = this.getBaseClauses();
        while (i.hasNext()) {
            IASTBaseSpecifier baseSpec = (IASTBaseSpecifier)i.next();
            baseSpec.acceptElement(requestor, manager);
        }
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        manager.processReferences(this.resolvedCrossReferences, requestor);
        try {
            requestor.exitClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public IASTScope getOwnerScope() {
        return (IASTScope)((Object)this.symbol.getContainingSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setNameEndOffsetAndLineNumber(offset, lineNumber);
    }

    public Iterator getDeclarations() {
        if (this.declarations != null) {
            return this.declarations.iterator();
        }
        return super.getDeclarations();
    }

    public void addDeclaration(IASTDeclaration declaration) {
        this.declarations.add(declaration);
    }

    public void initDeclarations() {
        this.declarations = new ArrayList(0);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }

    public void addUnresolvedReference(UnresolvedReferenceDuple duple) {
        if (!this.processingUnresolvedReferences) {
            this.unresolvedCrossReferences.add(duple);
        }
    }

    public Iterator getUnresolvedReferences() {
        return this.unresolvedCrossReferences.iterator();
    }

    public void setProcessingUnresolvedReferences(boolean processing) {
        this.processingUnresolvedReferences = processing;
    }

    public void setExtraReferences(List references, ReferenceCache cache) {
        if (references != null && !references.isEmpty()) {
            int i = 0;
            while (i < references.size()) {
                IASTReference r = (IASTReference)references.get(i);
                this.resolvedCrossReferences.add(r);
                ++i;
            }
        }
    }

    public Iterator getFriends() {
        IDerivableContainerSymbol s = (IDerivableContainerSymbol)this.getSymbol();
        return new SymbolIterator(s.getFriends().iterator());
    }

    public class BaseIterator
    implements Iterator {
        private final Iterator parents;

        public BaseIterator(IDerivableContainerSymbol symbol) {
            this.parents = symbol.getParents() != null ? symbol.getParents().iterator() : null;
        }

        public boolean hasNext() {
            if (this.parents == null) {
                return false;
            }
            return this.parents.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IDerivableContainerSymbol.IParentSymbol pw = (IDerivableContainerSymbol.IParentSymbol)this.parents.next();
            return new ASTBaseSpecifier(pw.getParent(), pw.isVirtual(), pw.getAccess(), pw.getOffset(), pw.getReferences());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

