/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTElaboratedTypeSpecifier
extends ASTSymbol
implements IASTElaboratedTypeSpecifier {
    private List references;
    private final boolean isForwardDeclaration;
    private final ASTClassKind kind;
    private final ASTQualifiedNamedElement qualifiedName;
    private NamedOffsets offsets = new NamedOffsets();

    public ASTElaboratedTypeSpecifier(ISymbol checkSymbol, ASTClassKind kind, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, int endOffset, int endingLine, List references, boolean isDecl) {
        super(checkSymbol);
        this.kind = kind;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.setEndingOffsetAndLineNumber(endOffset, endingLine);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), checkSymbol.getName());
        this.isForwardDeclaration = isDecl;
        this.references = references;
    }

    public String getName() {
        return this.getSymbol().getName();
    }

    public ASTClassKind getClassKind() {
        return this.kind;
    }

    public boolean isResolved() {
        return !this.getSymbol().isForwardDeclaration();
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        if (this.isForwardDeclaration) {
            try {
                requestor.acceptElaboratedForewardDeclaration(this);
            }
            catch (Exception exception) {}
        }
        manager.processReferences(this.references, requestor);
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public List getReferences() {
        return this.references;
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setNameEndOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IASTElaboratedTypeSpecifier)) {
            return false;
        }
        IASTElaboratedTypeSpecifier elab = (IASTElaboratedTypeSpecifier)obj;
        if (elab.getClassKind() != this.getClassKind()) {
            return false;
        }
        return elab.getName() == this.getName();
    }

    public int hashCode() {
        String coded = this.getName().toString();
        return coded.hashCode();
    }
}

