/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.internal.core.parser.ast.SymbolIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExpression;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolOwner;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ASTNode
implements IASTNode {
    public IASTNode.ILookupResult lookup(String prefix, IASTNode.LookupKind[] kind, IASTNode context, IASTExpression functionParameters) throws IASTNode.LookupError, ASTNotImplementedException {
        int paramIndex;
        if (!(this instanceof ISymbolOwner)) {
            return null;
        }
        ISymbol symbol = ((ISymbolOwner)((Object)this)).getSymbol();
        if (symbol == null || !(symbol instanceof IContainerSymbol)) {
            throw new IASTNode.LookupError();
        }
        IContainerSymbol thisContainer = (IContainerSymbol)symbol;
        IContainerSymbol qualification = context != null ? ((ASTNode)context).getLookupQualificationSymbol() : null;
        List parameters = this.createLookupParameterList(functionParameters);
        int n = paramIndex = parameters != null ? parameters.size() : 0;
        if (thisContainer.getSymbolTable().getParserMode() != ParserMode.COMPLETION_PARSE) {
            throw new ASTNotImplementedException();
        }
        TypeFilter filter = new TypeFilter();
        if (kind != null) {
            int i = 0;
            while (i < kind.length) {
                filter.addAcceptedType(kind[i]);
                if (kind[i] == IASTNode.LookupKind.THIS) {
                    filter.setLookingInThis(true);
                    if (kind.length == 1) {
                        filter.addAcceptedType(IASTNode.LookupKind.ALL);
                    }
                } else {
                    filter.addAcceptedType(kind[i]);
                }
                ++i;
            }
        } else {
            filter.addAcceptedType(IASTNode.LookupKind.ALL);
        }
        List lookupResults = this.performPrefixLookup(prefix, thisContainer, qualification, filter, parameters);
        if (lookupResults == null) {
            return null;
        }
        ListIterator iter = lookupResults.listIterator();
        while (iter.hasNext()) {
            ISymbol s = (ISymbol)iter.next();
            if (!thisContainer.isVisible(s, qualification) || s.getASTExtension() == null || s.getASTExtension().getPrimaryDeclaration() == null) {
                iter.remove();
                continue;
            }
            if (context == null || !((ASTNode)context).shouldFilterLookupResult(s)) continue;
            iter.remove();
        }
        SymbolIterator iterator = new SymbolIterator(lookupResults.iterator());
        return new Result(prefix, iterator, lookupResults.size(), paramIndex);
    }

    protected List performPrefixLookup(String prefix, IContainerSymbol thisContainer, IContainerSymbol qualification, TypeFilter filter, List paramList) throws IASTNode.LookupError {
        List results = null;
        try {
            results = qualification != null ? qualification.prefixLookup(filter, prefix, true, paramList) : thisContainer.prefixLookup(filter, prefix, false, paramList);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new IASTNode.LookupError();
        }
        catch (ParserSymbolTableError parserSymbolTableError) {
            throw new IASTNode.LookupError();
        }
        return results;
    }

    public IContainerSymbol getLookupQualificationSymbol() throws IASTNode.LookupError {
        throw new IASTNode.LookupError();
    }

    public boolean shouldFilterLookupResult(ISymbol symbol) {
        return false;
    }

    public List createLookupParameterList(IASTExpression parameterExpression) {
        if (parameterExpression == null) {
            return null;
        }
        LinkedList<TypeInfo> params = new LinkedList<TypeInfo>();
        ASTExpression exp = (ASTExpression)parameterExpression;
        while (exp != null) {
            params.add(exp.getResultType().getResult());
            exp = (ASTExpression)exp.getRHSExpression();
        }
        return params;
    }

    private class Result
    implements IASTNode.ILookupResult {
        private String prefix;
        private Iterator iterator;
        private int resultsNumber;
        private int parameterIndex;

        public Result(String pref, Iterator iter, int resultsSize, int paramIndex) {
            this.prefix = pref;
            this.iterator = iter;
            this.resultsNumber = resultsSize;
            this.parameterIndex = paramIndex;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Iterator getNodes() {
            return this.iterator;
        }

        public int getResultsSize() {
            return this.resultsNumber;
        }

        public int getIndexOfNextParameter() {
            return this.parameterIndex;
        }
    }
}

