/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.IASTMember;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IExtensibleSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDeclarationSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.UsingDeclarationSymbol;
import org.eclipse.cdt.internal.core.parser.pst.UsingDirectiveSymbol;

public class ContainerSymbol
extends BasicSymbol
implements IContainerSymbol {
    private List _contents = Collections.EMPTY_LIST;
    private List _usingDirectives = Collections.EMPTY_LIST;
    private Map _containedSymbols = Collections.EMPTY_MAP;
    static /* synthetic */ Class class$0;

    protected ContainerSymbol(ParserSymbolTable table, String name) {
        super(table, name);
    }

    protected ContainerSymbol(ParserSymbolTable table, String name, ISymbolASTExtension obj) {
        super(table, name, obj);
    }

    protected ContainerSymbol(ParserSymbolTable table, String name, TypeInfo.eType typeInfo) {
        super(table, name, typeInfo);
    }

    public Object clone() {
        ContainerSymbol copy = (ContainerSymbol)super.clone();
        List list = copy._usingDirectives = this._usingDirectives != Collections.EMPTY_LIST ? (List)((ArrayList)this._usingDirectives).clone() : this._usingDirectives;
        copy._containedSymbols = this.getSymbolTable().getParserMode() == ParserMode.COMPLETION_PARSE ? (this._containedSymbols != Collections.EMPTY_MAP ? (Map)((TreeMap)this._containedSymbols).clone() : this._containedSymbols) : (this._containedSymbols != Collections.EMPTY_MAP ? (Map)((HashMap)this._containedSymbols).clone() : this._containedSymbols);
        copy._contents = this._contents != Collections.EMPTY_LIST ? (List)((ArrayList)this._contents).clone() : this._contents;
        return copy;
    }

    public ISymbol instantiate(ITemplateSymbol template, Map argMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember() || template == null) {
            return null;
        }
        ContainerSymbol newContainer = (ContainerSymbol)super.instantiate(template, argMap);
        Iterator iter = this.getContentsIterator();
        newContainer.getContainedSymbols().clear();
        if (!newContainer._contents.isEmpty()) {
            newContainer._contents.clear();
            IExtensibleSymbol containedSymbol = null;
            ISymbol newSymbol = null;
            while (iter.hasNext()) {
                containedSymbol = (IExtensibleSymbol)iter.next();
                if (containedSymbol instanceof IUsingDirectiveSymbol) {
                    newContainer._contents.add(containedSymbol);
                    continue;
                }
                ISymbol symbol = (ISymbol)containedSymbol;
                if (symbol.isForwardDeclaration() && symbol.getTypeSymbol() != null) continue;
                if (!template.getExplicitSpecializations().isEmpty()) {
                    ISymbol temp;
                    List params = template.getParameterList();
                    int size = template.getParameterList().size();
                    ArrayList argList = new ArrayList(size);
                    boolean hasAllParams = true;
                    int i = 0;
                    while (i < size) {
                        Object obj = argMap.get(params.get(i));
                        if (obj == null) {
                            hasAllParams = false;
                            break;
                        }
                        argList.add(obj);
                        ++i;
                    }
                    if (hasAllParams && (temp = TemplateEngine.checkForTemplateExplicitSpecialization(template, symbol, argList)) != null) {
                        containedSymbol = temp;
                    }
                }
                HashMap instanceMap = argMap;
                if (!template.getDefinitionParameterMap().isEmpty() && template.getDefinitionParameterMap().containsKey(containedSymbol)) {
                    Map defMap = (Map)template.getDefinitionParameterMap().get(containedSymbol);
                    instanceMap = new HashMap();
                    Iterator i = defMap.keySet().iterator();
                    while (i.hasNext()) {
                        ISymbol p = (ISymbol)i.next();
                        instanceMap.put(p, argMap.get(defMap.get(p)));
                    }
                }
                newSymbol = ((ISymbol)containedSymbol).instantiate(template, instanceMap);
                newSymbol.setContainingSymbol(newContainer);
                newContainer._contents.add(newSymbol);
                if (newSymbol instanceof IParameterizedSymbol && newSymbol.isType(TypeInfo.t_constructor)) {
                    this.collectInstantiatedConstructor((IParameterizedSymbol)containedSymbol);
                    continue;
                }
                if (newContainer.getContainedSymbols().containsKey(newSymbol.getName())) {
                    Object obj = newContainer.getContainedSymbols().get(newSymbol.getName());
                    if (obj instanceof List) {
                        ((List)obj).add(newSymbol);
                        continue;
                    }
                    ArrayList<Object> list = new ArrayList<Object>(4);
                    list.add(obj);
                    list.add(newSymbol);
                    newContainer.putInContainedSymbols(newSymbol.getName(), list);
                    continue;
                }
                newContainer.putInContainedSymbols(newSymbol.getName(), newSymbol);
            }
        }
        return newContainer;
    }

    protected void collectInstantiatedConstructor(IParameterizedSymbol constructor) {
        throw new ParserSymbolTableError();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addSymbol(ISymbol obj) throws ParserSymbolTableException {
        IContainerSymbol containing = this;
        if (obj.getType() == TypeInfo.t_enumerator && containing.getType() == TypeInfo.t_enumeration) {
            obj.setTypeSymbol(containing);
            containing = containing.getContainingSymbol();
        }
        if (obj.isType(TypeInfo.t_template) && !TemplateEngine.canAddTemplate(containing, (ITemplateSymbol)obj)) {
            throw new ParserSymbolTableException(4);
        }
        if (this.getSymbolTable().getLanguage() == ParserLanguage.C && obj.isType(TypeInfo.t_struct, TypeInfo.t_enumeration)) {
            containing = this.getScopeForCTag(containing);
        }
        if ((this.isTemplateMember() || this.isType(TypeInfo.t_template)) && TemplateEngine.alreadyHasTemplateParameter(this, obj.getName())) {
            throw new ParserSymbolTableException(10);
        }
        boolean unnamed = obj.getName().equals("");
        Object origObj = null;
        obj.setContainingSymbol(containing);
        origObj = containing.getContainedSymbols().get(obj.getName());
        if (origObj != null) {
            boolean validOverride;
            ISymbol origDecl = null;
            ArrayList<ISymbol> origList = null;
            if (origObj instanceof ISymbol) {
                origDecl = (ISymbol)origObj;
            } else {
                Class<?> clazz = origObj.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.util.ArrayList");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz2) throw new ParserSymbolTableError(-1);
                origList = (ArrayList<ISymbol>)origObj;
            }
            boolean bl = !unnamed ? (origList == null ? ParserSymbolTable.isValidOverload(origDecl, obj) : ParserSymbolTable.isValidOverload(origList, obj)) : (validOverride = true);
            if (!unnamed && !validOverride) throw new ParserSymbolTableException(3);
            if (origList == null) {
                origList = new ArrayList<ISymbol>(4);
                origList.add(origDecl);
                origList.add(obj);
                ((ContainerSymbol)containing).putInContainedSymbols(obj.getName(), origList);
            } else {
                origList.add(obj);
            }
        } else {
            ((ContainerSymbol)containing).putInContainedSymbols(obj.getName(), obj);
        }
        obj.setIsTemplateMember(this.isTemplateMember() || this.getType() == TypeInfo.t_template);
        this.addToContents(obj);
    }

    public boolean removeSymbol(ISymbol symbol) {
        boolean removed = false;
        Map contained = this.getContainedSymbols();
        if (symbol != null && contained.containsKey(symbol.getName())) {
            List list;
            Object obj = contained.get(symbol.getName());
            if (obj instanceof ISymbol) {
                if (obj == symbol) {
                    contained.remove(symbol.getName());
                    removed = true;
                }
            } else if (obj instanceof List && (list = (List)obj).remove(symbol)) {
                if (list.size() == 1) {
                    contained.put(symbol.getName(), list.get(0));
                }
                removed = true;
            }
        }
        if (removed) {
            ListIterator iter = this.getContents().listIterator(this.getContents().size());
            while (iter.hasPrevious()) {
                if (iter.previous() != symbol) continue;
                iter.remove();
                break;
            }
        }
        return removed;
    }

    public boolean hasUsingDirectives() {
        return !this._usingDirectives.isEmpty();
    }

    public List getUsingDirectives() {
        return this._usingDirectives;
    }

    protected void addToUsingDirectives(IExtensibleSymbol symbol) {
        if (this._usingDirectives == Collections.EMPTY_LIST) {
            this._usingDirectives = new ArrayList(4);
        }
        this._usingDirectives.add(symbol);
    }

    public IUsingDirectiveSymbol addUsingDirective(IContainerSymbol namespace) throws ParserSymbolTableException {
        if (namespace.getType() != TypeInfo.t_namespace) {
            throw new ParserSymbolTableException(5);
        }
        if (this.isType(TypeInfo.t_class, TypeInfo.t_union)) {
            throw new ParserSymbolTableException(5);
        }
        ISymbol alias = namespace.getTypeSymbol();
        if (alias != null && alias.isType(TypeInfo.t_namespace)) {
            namespace = (IContainerSymbol)alias;
        }
        UsingDirectiveSymbol usingDirective = new UsingDirectiveSymbol(this.getSymbolTable(), namespace);
        this.addToUsingDirectives(usingDirective);
        this.addToContents(usingDirective);
        return usingDirective;
    }

    public IUsingDeclarationSymbol addUsingDeclaration(String name) throws ParserSymbolTableException {
        return this.addUsingDeclaration(name, null);
    }

    public IUsingDeclarationSymbol addUsingDeclaration(String name, IContainerSymbol declContext) throws ParserSymbolTableException {
        List objList;
        int objListSize;
        ISymbol clone;
        ISymbol symbol;
        ParserSymbolTable.LookupData data;
        block10: {
            data = new ParserSymbolTable.LookupData(name);
            if (declContext != null) {
                data.qualified = true;
                ParserSymbolTable.lookup(data, declContext);
            } else {
                ParserSymbolTable.lookup(data, this);
            }
            symbol = null;
            clone = null;
            objListSize = 0;
            objList = null;
            try {
                symbol = this.getSymbolTable().resolveAmbiguities(data);
            }
            catch (ParserSymbolTableException e) {
                if (e.reason == 7) break block10;
                throw e;
            }
        }
        if (symbol == null && (data.foundItems == null || data.foundItems.isEmpty())) {
            throw new ParserSymbolTableException(5);
        }
        if (symbol == null) {
            Object object = data.foundItems.get(data.name);
            objList = object instanceof List ? (List)object : null;
            objListSize = objList != null ? objList.size() : 0;
            symbol = objListSize > 0 ? (ISymbol)objList.get(0) : null;
        }
        ArrayList<ISymbol> usingDecs = new ArrayList<ISymbol>(objListSize > 0 ? objListSize : 1);
        ArrayList<ISymbol> usingRefs = new ArrayList<ISymbol>(objListSize > 0 ? objListSize : 1);
        UsingDeclarationSymbol usingDeclaration = new UsingDeclarationSymbol(this.getSymbolTable(), usingRefs, usingDecs);
        boolean addedUsingToContained = false;
        int idx = 1;
        while (symbol != null) {
            if (ParserSymbolTable.okToAddUsingDeclaration(symbol, this)) {
                if (!addedUsingToContained) {
                    this.addToContents(usingDeclaration);
                    addedUsingToContained = true;
                }
            } else {
                throw new ParserSymbolTableException(5);
            }
            clone = (ISymbol)symbol.clone();
            this.addSymbol(clone);
            usingDecs.add(clone);
            usingRefs.add(symbol);
            symbol = objList != null && idx < objListSize ? (ISymbol)objList.get(idx++) : null;
        }
        return usingDeclaration;
    }

    public Map getContainedSymbols() {
        return this._containedSymbols;
    }

    protected void putInContainedSymbols(String key, Object obj) {
        if (this._containedSymbols == Collections.EMPTY_MAP) {
            this._containedSymbols = this.getSymbolTable().getParserMode() == ParserMode.COMPLETION_PARSE ? new TreeMap(new SymbolTableComparator()) : new HashMap();
        }
        this._containedSymbols.put(key, obj);
    }

    public ISymbol elaboratedLookup(TypeInfo.eType type, String name) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, type){
            private TypeFilter filter = null;
            private final TypeInfo.eType t;
            {
                this.t = eType2;
            }

            public TypeFilter getFilter() {
                if (this.t == TypeInfo.t_any) {
                    return ParserSymbolTable.LookupData.ANY_FILTER;
                }
                if (this.filter == null) {
                    this.filter = new TypeFilter(this.t);
                }
                return this.filter;
            }
        };
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        if (this.isTemplateMember() && found instanceof ITemplateSymbol) {
            boolean areWithinTemplate = false;
            IContainerSymbol container = this.getContainingSymbol();
            while (container != null) {
                if (container == found) {
                    areWithinTemplate = true;
                    break;
                }
                container = container.getContainingSymbol();
            }
            if (areWithinTemplate) {
                return TemplateEngine.instantiateWithinTemplateScope(this, (ITemplateSymbol)found);
            }
        }
        return found;
    }

    public ISymbol lookup(String name) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name);
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        if (this.isTemplateMember() && found instanceof ITemplateSymbol) {
            return TemplateEngine.instantiateWithinTemplateScope(this, (ITemplateSymbol)found);
        }
        return found;
    }

    public ISymbol lookupMemberForDefinition(String name) throws ParserSymbolTableException {
        ISymbol symbol;
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name);
        data.qualified = true;
        IContainerSymbol container = this;
        if (container.isType(TypeInfo.t_namespace) && (symbol = container.getTypeSymbol()) != null && symbol.isType(TypeInfo.t_namespace)) {
            container = (IContainerSymbol)symbol;
        }
        data.foundItems = ParserSymbolTable.lookupInContained(data, container);
        if (data.foundItems != null) {
            return this.getSymbolTable().resolveAmbiguities(data);
        }
        return null;
    }

    public IParameterizedSymbol lookupMethodForDefinition(String name, List parameters) throws ParserSymbolTableException {
        ISymbol symbol;
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, parameters){
            private final List params;
            {
                this.params = list == null ? Collections.EMPTY_LIST : list;
            }

            public List getParameters() {
                return this.params;
            }
        };
        data.qualified = true;
        data.exactFunctionsOnly = true;
        IContainerSymbol container = this;
        if (container.isType(TypeInfo.t_namespace) && (symbol = container.getTypeSymbol()) != null && symbol.isType(TypeInfo.t_namespace)) {
            container = (IContainerSymbol)symbol;
        }
        data.foundItems = ParserSymbolTable.lookupInContained(data, container);
        if (data.foundItems != null) {
            symbol = this.getSymbolTable().resolveAmbiguities(data);
            return (IParameterizedSymbol)(symbol instanceof IParameterizedSymbol ? symbol : null);
        }
        return null;
    }

    public IContainerSymbol lookupNestedNameSpecifier(String name) throws ParserSymbolTableException {
        return this.lookupNestedNameSpecifier(name, this);
    }

    private IContainerSymbol lookupNestedNameSpecifier(String name, IContainerSymbol inSymbol) throws ParserSymbolTableException {
        ISymbol foundSymbol = null;
        TypeFilter filter = new TypeFilter(TypeInfo.t_namespace);
        filter.addAcceptedType(TypeInfo.t_class);
        filter.addAcceptedType(TypeInfo.t_struct);
        filter.addAcceptedType(TypeInfo.t_union);
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, filter){
            private final TypeFilter typeFilter;
            {
                this.typeFilter = typeFilter;
            }

            public TypeFilter getFilter() {
                return this.typeFilter;
            }
        };
        data.foundItems = ParserSymbolTable.lookupInContained(data, inSymbol);
        if (data.foundItems != null) {
            foundSymbol = this.getSymbolTable().resolveAmbiguities(data);
        }
        if (foundSymbol == null && inSymbol.getContainingSymbol() != null) {
            foundSymbol = this.lookupNestedNameSpecifier(name, inSymbol.getContainingSymbol());
        }
        if (foundSymbol instanceof IContainerSymbol) {
            return (IContainerSymbol)foundSymbol;
        }
        return null;
    }

    public ISymbol qualifiedLookup(String name) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name);
        data.qualified = true;
        ParserSymbolTable.lookup(data, this);
        return this.getSymbolTable().resolveAmbiguities(data);
    }

    public ISymbol qualifiedLookup(String name, final TypeInfo.eType t) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name){
            private TypeFilter filter = null;

            public TypeFilter getFilter() {
                if (t == TypeInfo.t_any) {
                    return ParserSymbolTable.LookupData.ANY_FILTER;
                }
                if (this.filter == null) {
                    this.filter = new TypeFilter(t);
                }
                return this.filter;
            }
        };
        data.qualified = true;
        ParserSymbolTable.lookup(data, this);
        return this.getSymbolTable().resolveAmbiguities(data);
    }

    public IParameterizedSymbol unqualifiedFunctionLookup(String name, List parameters) throws ParserSymbolTableException {
        HashSet associated = new HashSet();
        int size = parameters == null ? 0 : parameters.size();
        TypeInfo param = null;
        ISymbol paramType = null;
        int i = 0;
        while (i < size) {
            param = (TypeInfo)parameters.get(i);
            TypeInfo info = ParserSymbolTable.getFlatTypeInfo(param, this.getSymbolTable().getTypeInfoProvider());
            paramType = info.getTypeSymbol();
            this.getSymbolTable().getTypeInfoProvider().returnTypeInfo(info);
            if (paramType != null) {
                TypeInfo.PtrOp op;
                ParserSymbolTable.getAssociatedScopes(paramType, associated);
                if (param.hasPtrOperators() && param.getPtrOperators().size() == 1 && (op = (TypeInfo.PtrOp)param.getPtrOperators().get(0)).getType() == TypeInfo.PtrOp.t_pointer && paramType.getContainingSymbol().isType(TypeInfo.t_class, TypeInfo.t_union)) {
                    ParserSymbolTable.getAssociatedScopes(paramType.getContainingSymbol(), associated);
                }
            }
            ++i;
        }
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, associated, parameters){
            private final HashSet assoc;
            private final List params;
            {
                this.assoc = hashSet;
                this.params = list == null ? Collections.EMPTY_LIST : list;
            }

            public HashSet getAssociated() {
                return this.assoc;
            }

            public List getParameters() {
                return this.params;
            }

            public TypeFilter getFilter() {
                return ParserSymbolTable.LookupData.FUNCTION_FILTER;
            }
        };
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        if (found == null || found.getContainingSymbol().getType() != TypeInfo.t_class) {
            Object[] scopes = associated.toArray();
            size = associated.size();
            int i2 = 0;
            while (i2 < size) {
                IContainerSymbol associatedScope = (IContainerSymbol)scopes[i2];
                if (associated.contains(associatedScope)) {
                    data.qualified = true;
                    data.ignoreUsingDirectives = true;
                    data.usingDirectivesOnly = false;
                    ParserSymbolTable.lookup(data, associatedScope);
                }
                ++i2;
            }
            found = this.getSymbolTable().resolveAmbiguities(data);
        }
        if (found instanceof IParameterizedSymbol) {
            return (IParameterizedSymbol)found;
        }
        return null;
    }

    public IParameterizedSymbol memberFunctionLookup(String name, List parameters) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, parameters){
            private final List params;
            {
                this.params = list == null ? Collections.EMPTY_LIST : list;
            }

            public List getParameters() {
                return this.params;
            }

            public TypeFilter getFilter() {
                return ParserSymbolTable.LookupData.FUNCTION_FILTER;
            }
        };
        ParserSymbolTable.lookup(data, this);
        return (IParameterizedSymbol)this.getSymbolTable().resolveAmbiguities(data);
    }

    public IParameterizedSymbol qualifiedFunctionLookup(String name, List parameters) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, parameters){
            private final List params;
            {
                this.params = list == null ? Collections.EMPTY_LIST : list;
            }

            public List getParameters() {
                return this.params;
            }

            public TypeFilter getFilter() {
                return ParserSymbolTable.LookupData.FUNCTION_FILTER;
            }
        };
        data.qualified = true;
        ParserSymbolTable.lookup(data, this);
        return (IParameterizedSymbol)this.getSymbolTable().resolveAmbiguities(data);
    }

    public ISymbol lookupTemplateId(String name, List arguments) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name);
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        if (found != null) {
            if (found.isType(TypeInfo.t_templateParameter) && found.getTypeInfo().getTemplateParameterType() == TypeInfo.t_template || found.isType(TypeInfo.t_template)) {
                found = ((ITemplateSymbol)found).instantiate(arguments);
            } else if (found.getContainingSymbol().isType(TypeInfo.t_template)) {
                found = ((ITemplateSymbol)found.getContainingSymbol()).instantiate(arguments);
            }
        }
        return found;
    }

    public ISymbol lookupFunctionTemplateId(String name, List parameters, List arguments, boolean forDefinition) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, parameters, arguments){
            private final List params;
            private final List templateParams;
            {
                this.params = list == null ? Collections.EMPTY_LIST : list;
                this.templateParams = list2;
            }

            public List getParameters() {
                return this.params;
            }

            public List getTemplateParameters() {
                return this.templateParams;
            }

            public TypeFilter getFilter() {
                return ParserSymbolTable.LookupData.FUNCTION_FILTER;
            }
        };
        data.exactFunctionsOnly = forDefinition;
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        return found;
    }

    public IContainerSymbol lookupTemplateIdForDefinition(String name, List arguments) {
        return null;
    }

    public List prefixLookup(TypeFilter filter, String prefix, boolean qualified, List paramList) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(prefix, paramList, filter){
            private final List params;
            private Set ambiguities;
            private final TypeFilter typeFilter;
            {
                this.params = list;
                this.ambiguities = Collections.EMPTY_SET;
                this.typeFilter = typeFilter;
            }

            public List getParameters() {
                return this.params;
            }

            public boolean isPrefixLookup() {
                return true;
            }

            public Set getAmbiguities() {
                return this.ambiguities;
            }

            public TypeFilter getFilter() {
                return this.typeFilter;
            }

            public void addAmbiguity(String n) {
                if (this.ambiguities == Collections.EMPTY_SET) {
                    this.ambiguities = new HashSet();
                }
                this.ambiguities.add(n);
            }
        };
        data.qualified = qualified;
        ParserSymbolTable.lookup(data, this);
        ArrayList constructors = null;
        if (filter != null && filter.willAccept(TypeInfo.t_constructor) && this instanceof IDerivableContainerSymbol && this.getName().startsWith(prefix)) {
            List temp = ((IDerivableContainerSymbol)((Object)this)).getConstructors();
            int size = temp.size();
            constructors = new ArrayList(size);
            int i = 0;
            while (i < size) {
                constructors.add(temp.get(i));
                ++i;
            }
        }
        if (data.foundItems == null || data.foundItems.isEmpty()) {
            if (constructors != null) {
                if (paramList != null) {
                    this.getSymbolTable().resolveFunction(data, constructors);
                    return constructors;
                }
                return constructors;
            }
            return null;
        }
        if (data.getAmbiguities() != null && !data.getAmbiguities().isEmpty()) {
            Iterator iter = data.getAmbiguities().iterator();
            while (iter.hasNext()) {
                data.foundItems.remove(iter.next());
            }
        }
        ArrayList list = new ArrayList();
        Iterator iter = data.foundItems.keySet().iterator();
        Object obj = null;
        ArrayList<Object> tempList = null;
        while (iter.hasNext()) {
            obj = data.foundItems.get(iter.next());
            if (obj instanceof List) {
                if (paramList != null) {
                    this.getSymbolTable().resolveFunction(data, (List)obj);
                }
                list.addAll((List)obj);
                continue;
            }
            if (paramList != null && ((ISymbol)obj).isType(TypeInfo.t_function)) {
                if (tempList == null) {
                    tempList = new ArrayList<Object>(1);
                } else {
                    tempList.clear();
                }
                tempList.add(obj);
                this.getSymbolTable().resolveFunction(data, tempList);
                list.addAll(tempList);
                continue;
            }
            list.add(obj);
        }
        if (constructors != null) {
            list.addAll(constructors);
        }
        return list;
    }

    public boolean isVisible(ISymbol symbol, IContainerSymbol qualifyingSymbol) {
        ISymbolASTExtension extension = symbol.getASTExtension();
        if (extension == null) {
            return true;
        }
        ASTNode node = extension.getPrimaryDeclaration();
        if (node == null) {
            return true;
        }
        if (node instanceof IASTMember) {
            ASTAccessVisibility visibility = ParserSymbolTable.getVisibility(symbol, qualifyingSymbol);
            if (visibility == null) {
                return false;
            }
            if (visibility == ASTAccessVisibility.PUBLIC) {
                return true;
            }
            IContainerSymbol container = this.getContainingSymbol();
            IContainerSymbol symbolContainer = symbol.getContainingSymbol();
            if (!symbolContainer.isType(TypeInfo.t_class, TypeInfo.t_union) || symbolContainer.equals(container)) {
                return true;
            }
            if (this.isFriendOf(qualifyingSymbol != null ? qualifyingSymbol : symbolContainer)) {
                return true;
            }
            if (visibility == ASTAccessVisibility.PROTECTED) {
                try {
                    return ParserSymbolTable.hasBaseClass(container, symbolContainer) >= 0;
                }
                catch (ParserSymbolTableException parserSymbolTableException) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    protected boolean isFriendOf(IContainerSymbol symbol) {
        if (symbol instanceof IDerivableContainerSymbol) {
            IContainerSymbol container = this.getContainingSymbol();
            while (container != null && container.isType(TypeInfo.t_block)) {
                container = container.getContainingSymbol();
            }
            if (container != null && !container.isType(TypeInfo.t_class, TypeInfo.t_union)) {
                container = null;
            }
            IDerivableContainerSymbol derivable = (IDerivableContainerSymbol)symbol;
            List friends = derivable.getFriends();
            int size = friends.size();
            int i = 0;
            while (i < size) {
                ISymbol friend = (ISymbol)friends.get(i);
                ISymbol typeSymbol = friend.getTypeSymbol();
                if (friend == this || typeSymbol == this || friend == container || container != null && typeSymbol == container) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private IContainerSymbol getScopeForCTag(IContainerSymbol container) {
        while (!(container.isType(TypeInfo.t_namespace) || container.isType(TypeInfo.t_function) || container.isType(TypeInfo.t_block))) {
            container = container.getContainingSymbol();
        }
        return container;
    }

    protected void addToContents(IExtensibleSymbol symbol) {
        if (this._contents == Collections.EMPTY_LIST) {
            this._contents = this.isType(TypeInfo.t_namespace) ? new ArrayList(64) : (this.isType(TypeInfo.t_class) || this.isType(TypeInfo.t_struct) ? new ArrayList(32) : (this.isType(TypeInfo.t_function) ? new ArrayList(16) : new ArrayList(8)));
        }
        this._contents.add(symbol);
    }

    protected List getContents() {
        return this._contents;
    }

    public Iterator getContentsIterator() {
        return new ContentsIterator(this.getContents().iterator());
    }

    public void addTemplateId(ISymbol symbol, List args) throws ParserSymbolTableException {
        throw new ParserSymbolTableException(4);
    }

    protected class ContentsIterator
    implements Iterator {
        final Iterator internalIterator;
        Set alreadyReturned = new HashSet();
        IExtensibleSymbol next = null;

        public ContentsIterator(Iterator iter) {
            this.internalIterator = iter;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.internalIterator.hasNext()) ** GOTO lbl21
            return false;
lbl-1000:
            // 1 sources

            {
                extensible = (IExtensibleSymbol)this.internalIterator.next();
                if (this.alreadyReturned.contains(extensible)) continue;
                if (extensible instanceof ISymbol) {
                    symbol = (ISymbol)extensible;
                    if (symbol.isForwardDeclaration() && symbol.getTypeSymbol() != null && symbol.getTypeSymbol().getContainingSymbol() == ContainerSymbol.this) {
                        this.alreadyReturned.add(symbol.getTypeSymbol());
                        this.next = symbol.getTypeSymbol();
                        return true;
                    }
                } else if (extensible instanceof IUsingDeclarationSymbol) {
                    using = (IUsingDeclarationSymbol)extensible;
                    this.alreadyReturned.addAll(using.getDeclaredSymbols());
                }
                this.next = extensible;
                return true;
lbl21:
                // 2 sources

                ** while (this.internalIterator.hasNext())
            }
lbl22:
            // 1 sources

            return false;
        }

        /*
         * Unable to fully structure code
         */
        public Object next() {
            extensible = this.next;
            if (this.next == null) ** GOTO lbl19
            this.next = null;
            return extensible;
lbl-1000:
            // 1 sources

            {
                extensible = (IExtensibleSymbol)this.internalIterator.next();
                if (this.alreadyReturned.contains(extensible)) continue;
                if (extensible instanceof ISymbol) {
                    symbol = (ISymbol)extensible;
                    if (symbol.isForwardDeclaration() && symbol.getTypeSymbol() != null && symbol.getTypeSymbol().getContainingSymbol() == ContainerSymbol.this) {
                        this.alreadyReturned.add(symbol.getTypeSymbol());
                        return symbol.getTypeSymbol();
                    }
                } else if (extensible instanceof IUsingDeclarationSymbol) {
                    using = (IUsingDeclarationSymbol)extensible;
                    this.alreadyReturned.addAll(using.getDeclaredSymbols());
                }
                return extensible;
lbl19:
                // 2 sources

                ** while (this.internalIterator.hasNext())
            }
lbl20:
            // 1 sources

            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void removeSymbol() {
            this.internalIterator.remove();
        }
    }

    protected static class SymbolTableComparator
    implements Comparator {
        private static final Collator collator = Collator.getInstance();

        static {
            collator.setStrength(0);
        }

        protected SymbolTableComparator() {
        }

        public int compare(Object o1, Object o2) {
            int result = collator.compare(o1, o2);
            if (result == 0) {
                collator.setStrength(3);
                result = collator.compare(o1, o2);
                collator.setStrength(0);
            }
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof SymbolTableComparator;
        }
    }
}

