/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public final class TemplateEngine {
    protected static TypeInfo instantiateTypeInfo(TypeInfo info, ITemplateSymbol template, Map argMap) throws ParserSymbolTableException {
        if (argMap == null) {
            return info;
        }
        if (info.isType(TypeInfo.t_type) && info.getTypeSymbol() == null) {
            return info;
        }
        if (info.isType(TypeInfo.t_type) && info.getTypeSymbol() instanceof IDeferredTemplateInstance) {
            IDeferredTemplateInstance deferred = (IDeferredTemplateInstance)info.getTypeSymbol();
            TypeInfo newInfo = new TypeInfo(info);
            template.registerDeferredInstatiation(newInfo, deferred, ITemplateSymbol.DeferredKind.TYPE_SYMBOL, argMap);
            newInfo.setTypeSymbol(deferred);
            return newInfo;
        }
        if (info.isType(TypeInfo.t_type) && info.getTypeSymbol().isType(TypeInfo.t_templateParameter) && argMap.containsKey(info.getTypeSymbol())) {
            TypeInfo targetInfo = new TypeInfo((TypeInfo)argMap.get(info.getTypeSymbol()));
            if (info.hasPtrOperators()) {
                targetInfo.addPtrOperator(info.getPtrOperators());
            }
            if (info.checkBit(1024)) {
                targetInfo.setBit(true, 1024);
            }
            if (info.checkBit(2048)) {
                targetInfo.setBit(true, 2048);
            }
            return targetInfo;
        }
        if (info.isType(TypeInfo.t_type) && info.getTypeSymbol().isType(TypeInfo.t_function)) {
            TypeInfo newInfo = new TypeInfo(info);
            newInfo.setTypeSymbol(info.getTypeSymbol().instantiate(template, argMap));
            return newInfo;
        }
        return info;
    }

    protected static void instantiateDeferredTypeInfo(TypeInfo info, ITemplateSymbol template, Map argMap) throws ParserSymbolTableException {
        info.setTypeSymbol(info.getTypeSymbol().instantiate(template, argMap));
    }

    public static void discardDeferredTypeInfo(TypeInfo info, TemplateSymbol template, Map map) {
        ISymbol instance = info.getTypeSymbol();
        if (!(instance instanceof IDeferredTemplateInstance)) {
            template.removeInstantiation((IContainerSymbol)instance);
        }
        info.setTypeSymbol(null);
    }

    protected static ITemplateSymbol matchTemplatePartialSpecialization(ITemplateSymbol template, List args) throws ParserSymbolTableException {
        int size;
        if (template == null) {
            return null;
        }
        List specs = template.getSpecializations();
        int n = size = specs != null ? specs.size() : 0;
        if (size == 0) {
            return template;
        }
        ISpecializedSymbol bestMatch = null;
        boolean bestMatchIsBest = true;
        ISpecializedSymbol spec = null;
        List specArgs = null;
        int i = 0;
        while (i < size) {
            spec = (ISpecializedSymbol)specs.get(i);
            specArgs = spec.getArgumentList();
            if (specArgs != null && specArgs.size() == args.size()) {
                int specArgsSize = specArgs.size();
                HashMap map = new HashMap();
                TypeInfo info1 = null;
                TypeInfo info2 = null;
                boolean match = true;
                int j = 0;
                while (j < specArgsSize) {
                    info1 = (TypeInfo)specArgs.get(j);
                    info2 = (TypeInfo)args.get(j);
                    ISymbol sym1 = template.getSymbolTable().newSymbol("");
                    sym1.setTypeInfo(info1);
                    if (!TemplateEngine.deduceTemplateArgument(map, sym1, info2)) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match) {
                    int compare = TemplateEngine.orderSpecializations(bestMatch, spec);
                    if (compare == 0) {
                        bestMatchIsBest = false;
                    } else if (compare < 0) {
                        bestMatch = spec;
                        bestMatchIsBest = true;
                    }
                }
            }
            ++i;
        }
        if (!bestMatchIsBest) {
            throw new ParserSymbolTableException(0);
        }
        return bestMatch;
    }

    /*
     * Exception decompiling
     */
    protected static boolean matchTemplateParameterAndArgument(ISymbol param, TypeInfo arg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 303->306)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isValidArgument(ISymbol param, TypeInfo arg) {
        if (param.getTypeInfo().getTemplateParameterType() == TypeInfo.t_typeName) {
            if (arg.isType(TypeInfo.t_type) && arg.getTypeSymbol() != null) {
                ISymbol symbol = arg.getTypeSymbol();
                if (symbol.getName().equals("")) {
                    return false;
                }
                if (TemplateEngine.hasNoLinkage(arg)) {
                    return false;
                }
            }
        } else if (param.getTypeInfo().getTemplateParameterType() != TypeInfo.t_template) {
            TypeInfo.PtrOp argOp;
            TypeInfo.PtrOp op;
            List ptrs = param.getPtrOperators();
            TypeInfo.PtrOp ptrOp = op = ptrs.size() > 0 ? (TypeInfo.PtrOp)ptrs.get(0) : null;
            if (op != null && op.getType() == TypeInfo.PtrOp.t_reference) {
                if (arg.isType(TypeInfo.t_type) && arg.getTypeSymbol() != null && arg.getTypeSymbol().getName().equals("")) {
                    return false;
                }
                return TemplateEngine.hasExternalLinkage(arg);
            }
            List argPtrs = arg.getPtrOperators();
            TypeInfo.PtrOp ptrOp2 = argOp = argPtrs.size() > 0 ? (TypeInfo.PtrOp)argPtrs.get(0) : null;
            if (argOp != null && argOp.getType() == TypeInfo.PtrOp.t_pointer || arg.isType(TypeInfo.t_type)) {
                ISymbol symbol = arg.getTypeSymbol();
                if (symbol != null && symbol.getContainingSymbol().isType(TypeInfo.t_class, TypeInfo.t_union) && !symbol.isType(TypeInfo.t_class, TypeInfo.t_union) && !symbol.getTypeInfo().checkBit(4)) {
                    return false;
                }
                return TemplateEngine.hasExternalLinkage(arg);
            }
            if (op == null && (arg.isType(TypeInfo.t_bool, TypeInfo.t_int) || arg.isType(TypeInfo.t_enumerator))) {
                return true;
            }
            return arg.isType(TypeInfo.t_templateParameter) && arg.getTemplateParameterType() != TypeInfo.t_typeName && arg.getTemplateParameterType() != TypeInfo.t_template;
        }
        return true;
    }

    protected static boolean hasExternalLinkage(TypeInfo type) {
        if (!type.isType(TypeInfo.t_type)) {
            return false;
        }
        return !TemplateEngine.hasNoLinkage(type);
    }

    protected static boolean hasInternalLinkage(TypeInfo type) {
        return !TemplateEngine.hasNoLinkage(type);
    }

    protected static boolean hasNoLinkage(TypeInfo type) {
        if (type.isType(TypeInfo.t_type)) {
            ISymbol symbol = type.getTypeSymbol();
            if (symbol.getContainingSymbol() == null) {
                return true;
            }
            return symbol.getContainingSymbol().isType(TypeInfo.t_function);
        }
        return false;
    }

    private static TypeInfo getParameterTypeForDeduction(ISymbol pSymbol) {
        TypeInfo p = new TypeInfo(pSymbol.getTypeInfo());
        List pPtrs = p.getPtrOperators();
        if (pPtrs.size() > 0) {
            TypeInfo.PtrOp pOp = (TypeInfo.PtrOp)pPtrs.get(0);
            if (pOp.getType() == TypeInfo.PtrOp.t_reference || pOp.getType() == TypeInfo.PtrOp.t_undef_ptr) {
                pPtrs.remove(0);
            } else {
                TypeInfo.PtrOp newOp = new TypeInfo.PtrOp(pOp.getType(), false, false);
                pPtrs.set(0, newOp);
            }
        } else {
            p.setBit(false, 1024);
            p.setBit(false, 2048);
        }
        return p;
    }

    private static TypeInfo getArgumentTypeForDeduction(TypeInfo aInfo, boolean pIsAReferenceType) throws ParserSymbolTableException {
        TypeInfo a = ParserSymbolTable.getFlatTypeInfo(aInfo, null);
        if (!pIsAReferenceType) {
            List aPtrs;
            ISymbol aSymbol = a.getTypeSymbol();
            if (a.getType() == TypeInfo.t_type) {
                if (aSymbol == null) {
                    throw new ParserSymbolTableException(8);
                }
                if (aSymbol.isType(TypeInfo.t_function) && a.getPtrOperators().size() == 0) {
                    a.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
                }
            }
            if ((aPtrs = a.getPtrOperators()).size() > 0) {
                TypeInfo.PtrOp pOp = (TypeInfo.PtrOp)aPtrs.get(0);
                if (pOp.getType() == TypeInfo.PtrOp.t_array) {
                    aPtrs.set(0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, false));
                } else {
                    aPtrs.set(0, new TypeInfo.PtrOp(pOp.getType(), false, false));
                }
            } else {
                a.setBit(false, 1024);
                a.setBit(false, 2048);
            }
        }
        return a;
    }

    private static List getSourceList(ISymbol symbol) {
        ITemplateSymbol template = null;
        if (symbol instanceof IDeferredTemplateInstance) {
            IDeferredTemplateInstance deferred = (IDeferredTemplateInstance)symbol;
            return deferred.getArguments();
        }
        ISymbol instantiated = symbol.getInstantiatedSymbol();
        template = (ITemplateSymbol)instantiated.getContainingSymbol();
        if (template instanceof ISpecializedSymbol) {
            return ((ISpecializedSymbol)template).getArgumentList();
        }
        return template.getParameterList();
    }

    private static List getTargetList(ISymbol symbol) {
        if (symbol instanceof IDeferredTemplateInstance) {
            IDeferredTemplateInstance deferred = (IDeferredTemplateInstance)symbol;
            return deferred.getArguments();
        }
        ISymbol instantiated = symbol.getInstantiatedSymbol();
        if (instantiated != null) {
            ITemplateSymbol template = (ITemplateSymbol)instantiated.getContainingSymbol();
            return template.findArgumentsFor((IContainerSymbol)symbol);
        }
        return null;
    }

    private static ISymbol findMatchingBaseClass(ISymbol p, IDerivableContainerSymbol a) {
        ISymbol aSymbol = null;
        ITemplateSymbol pTemplate = null;
        ITemplateSymbol parentTemplate = null;
        pTemplate = p instanceof IDeferredTemplateInstance ? ((IDeferredTemplateInstance)p).getTemplate() : (ITemplateSymbol)p.getInstantiatedSymbol().getContainingSymbol();
        if (pTemplate instanceof ISpecializedSymbol) {
            pTemplate = ((ISpecializedSymbol)pTemplate).getPrimaryTemplate();
        }
        List parents = a.getParents();
        int size = parents.size();
        int i = 0;
        while (i < size) {
            IDerivableContainerSymbol.IParentSymbol wrapper = (IDerivableContainerSymbol.IParentSymbol)parents.get(i);
            ISymbol parent = wrapper.getParent();
            if (parent instanceof IDeferredTemplateInstance) {
                IDeferredTemplateInstance parentInstance = (IDeferredTemplateInstance)parent;
                parentTemplate = parentInstance.getTemplate();
                if (parentTemplate instanceof ISpecializedSymbol) {
                    parentTemplate = ((ISpecializedSymbol)parentTemplate).getPrimaryTemplate();
                }
                if (pTemplate == parentTemplate) {
                    aSymbol = parent;
                    break;
                }
            } else {
                parentTemplate = (ITemplateSymbol)parent.getInstantiatedSymbol().getContainingSymbol();
                if (parentTemplate instanceof ISpecializedSymbol) {
                    parentTemplate = ((ISpecializedSymbol)parentTemplate).getPrimaryTemplate();
                }
                if (pTemplate == parentTemplate) {
                    aSymbol = parent;
                    break;
                }
                aSymbol = TemplateEngine.findMatchingBaseClass(p, (IDerivableContainerSymbol)parent);
            }
            if (aSymbol != null) {
                return aSymbol;
            }
            ++i;
        }
        return aSymbol;
    }

    private static boolean deduceTemplateArgument(Map map, ISymbol pSymbol, TypeInfo a) throws ParserSymbolTableException {
        boolean pIsAReferenceType = false;
        List ptrOps = pSymbol.getPtrOperators();
        if (ptrOps.size() > 0 && ((TypeInfo.PtrOp)ptrOps.get(0)).getType() == TypeInfo.PtrOp.t_reference) {
            pIsAReferenceType = true;
        }
        TypeInfo p = TemplateEngine.getParameterTypeForDeduction(pSymbol);
        a = TemplateEngine.getArgumentTypeForDeduction(a, pIsAReferenceType);
        if (p.isType(TypeInfo.t_type)) {
            ISymbol symbol = p.getTypeSymbol();
            ISymbol aSymbol = a.getTypeSymbol();
            if (symbol == null || a.isType(TypeInfo.t_type) && aSymbol == null || a.isType(TypeInfo.t_undef)) {
                throw new ParserSymbolTableException(1);
            }
            if (symbol instanceof IDeferredTemplateInstance || symbol.isTemplateInstance()) {
                return TemplateEngine.deduceFromTemplateTemplateArguments(map, symbol, aSymbol);
            }
            if (symbol.isType(TypeInfo.t_templateParameter)) {
                if (symbol.getTypeInfo().getTemplateParameterType() == TypeInfo.t_typeName) {
                    List aPtrs = a.getPtrOperators();
                    List pPtrs = p.getPtrOperators();
                    if (pPtrs != null && pPtrs.size() > 0) {
                        int aSize;
                        if (aPtrs == null) {
                            return false;
                        }
                        int pSize = pPtrs.size();
                        if (pSize != (aSize = aPtrs.size())) {
                            return false;
                        }
                        TypeInfo.PtrOp pOp = null;
                        TypeInfo.PtrOp aOp = null;
                        int aIdx = 0;
                        int i = 0;
                        while (i < pSize) {
                            pOp = (TypeInfo.PtrOp)pPtrs.get(i);
                            aOp = (TypeInfo.PtrOp)aPtrs.get(aIdx++);
                            if (pOp.getType() == aOp.getType()) {
                                if (!pOp.equals(aOp)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                            aPtrs.remove(--aIdx);
                            ++i;
                        }
                    }
                    if (p.checkBit(1024)) {
                        if (!a.checkBit(1024)) {
                            return false;
                        }
                        a.setBit(false, 1024);
                    }
                    if (p.checkBit(2048)) {
                        if (!a.checkBit(2048)) {
                            return false;
                        }
                        a.setBit(false, 2048);
                    }
                    return TemplateEngine.deduceArgument(map, symbol, a);
                }
                if (symbol.getTypeInfo().getTemplateParameterType() != TypeInfo.t_template) {
                    if (symbol.getTypeInfo().getTemplateParameterType() == a.getType()) {
                        return TemplateEngine.deduceArgument(map, symbol, a);
                    }
                    return false;
                }
            } else if (symbol.isType(TypeInfo.t_function)) {
                TypeInfo.PtrOp op;
                if (!(aSymbol instanceof IParameterizedSymbol) || !aSymbol.isType(TypeInfo.t_function)) {
                    return false;
                }
                IParameterizedSymbol pFunction = (IParameterizedSymbol)symbol;
                IParameterizedSymbol aFunction = (IParameterizedSymbol)aSymbol;
                if (!TemplateEngine.deduceTemplateArgument(map, pFunction.getReturnType(), aFunction.getReturnType().getTypeInfo())) {
                    return false;
                }
                List pPtrs = p.getPtrOperators();
                if (pPtrs.size() != 0 && (op = (TypeInfo.PtrOp)pPtrs.get(0)).getType() == TypeInfo.PtrOp.t_memberPointer) {
                    TypeInfo info = new TypeInfo(TypeInfo.t_type, 0, aFunction.getContainingSymbol());
                    if (!TemplateEngine.deduceTemplateArgument(map, op.getMemberOf(), info)) {
                        return false;
                    }
                }
                List pParams = pFunction.getParameterList();
                List aParams = aFunction.getParameterList();
                if (pParams.size() != aParams.size()) {
                    return false;
                }
                int size = pParams.size();
                int i = 0;
                while (i < size) {
                    TypeInfo info = ((ISymbol)aParams.get(i)).getTypeInfo();
                    if (!TemplateEngine.deduceTemplateArgument(map, (ISymbol)pParams.get(i), info)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if (p.isType(TypeInfo.t_templateParameter)) {
            return TemplateEngine.deduceArgument(map, pSymbol, a);
        }
        if (p.getType() == a.getType()) {
            if (p.getDefault() != null) {
                return p.getDefault().equals(a.getDefault());
            }
            return true;
        }
        return false;
    }

    private static boolean deduceFromTemplateTemplateArguments(Map map, ISymbol pSymbol, ISymbol aSymbol) {
        IContainerSymbol a;
        ITemplateSymbol p;
        ITemplateSymbol iTemplateSymbol = p = pSymbol instanceof IDeferredTemplateInstance ? ((IDeferredTemplateInstance)pSymbol).getTemplate() : (ITemplateSymbol)pSymbol.getInstantiatedSymbol().getContainingSymbol();
        if (p instanceof ISpecializedSymbol) {
            p = ((ISpecializedSymbol)p).getPrimaryTemplate();
        }
        IContainerSymbol iContainerSymbol = a = aSymbol.isTemplateInstance() ? aSymbol.getInstantiatedSymbol().getContainingSymbol() : aSymbol.getContainingSymbol();
        if (a instanceof ISpecializedSymbol) {
            a = ((ISpecializedSymbol)a).getPrimaryTemplate();
        }
        if (p != a && (aSymbol = aSymbol instanceof IDerivableContainerSymbol ? TemplateEngine.findMatchingBaseClass(pSymbol, (IDerivableContainerSymbol)aSymbol) : null) == null) {
            return false;
        }
        List pList = TemplateEngine.getSourceList(pSymbol);
        List aList = TemplateEngine.getTargetList(aSymbol);
        if (pList == null || aList == null || pList.size() != aList.size()) {
            return false;
        }
        int size = pList.size();
        int i = 0;
        while (i < size) {
            Object obj = pList.get(i);
            ISymbol sym = null;
            if (obj instanceof ISymbol) {
                sym = (ISymbol)obj;
            } else {
                sym = pSymbol.getSymbolTable().newSymbol("");
                sym.setTypeInfo((TypeInfo)obj);
            }
            TypeInfo arg = TemplateEngine.transformTypeInfo(aList.get(i), null);
            try {
                if (!TemplateEngine.deduceTemplateArgument(map, sym, arg)) {
                    return false;
                }
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Map deduceTemplateArgumentsUsingParameterList(ITemplateSymbol template, IParameterizedSymbol function) {
        List aList = function.getParameterList();
        int size = aList.size();
        ArrayList<TypeInfo> args = new ArrayList<TypeInfo>(size);
        int i = 0;
        while (i < size) {
            ISymbol symbol = (ISymbol)aList.get(i);
            args.add(symbol.getTypeInfo());
            ++i;
        }
        return TemplateEngine.deduceTemplateArguments(template, args);
    }

    private static Map deduceTemplateArguments(ITemplateSymbol template, List arguments) {
        if (template.getContainedSymbols() == Collections.EMPTY_MAP || template.getContainedSymbols().size() != 1) {
            return null;
        }
        IContainerSymbol templateSymbol = template.getTemplatedSymbol();
        if (!templateSymbol.isType(TypeInfo.t_function)) {
            return null;
        }
        IParameterizedSymbol templateFunction = (IParameterizedSymbol)templateSymbol;
        List pList = templateFunction.getParameterList();
        if (pList == null || arguments == null || pList.size() != arguments.size()) {
            return null;
        }
        HashMap map = new HashMap();
        int size = pList.size();
        int i = 0;
        while (i < size) {
            try {
                if (!TemplateEngine.deduceTemplateArgument(map, (ISymbol)pList.get(i), (TypeInfo)arguments.get(i))) {
                    return null;
                }
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                return null;
            }
            ++i;
        }
        return map;
    }

    private static boolean deduceArgument(Map map, ISymbol p, TypeInfo a) {
        a = ParserSymbolTable.getFlatTypeInfo(a, null);
        if (map.containsKey(p)) {
            TypeInfo current = (TypeInfo)map.get(p);
            return current.equals(a);
        }
        map.put(p, a);
        return true;
    }

    private static int orderSpecializations(ISpecializedSymbol spec1, ISpecializedSymbol spec2) throws ParserSymbolTableException {
        if (spec1 == null) {
            return -1;
        }
        IContainerSymbol decl = spec1.getTemplatedSymbol();
        ITemplateSymbol template1 = spec1;
        ITemplateSymbol template2 = spec2;
        if (decl.isType(TypeInfo.t_class, TypeInfo.t_union)) {
            template1 = TemplateEngine.classTemplateSpecializationToFunctionTemplate(spec1);
            template2 = TemplateEngine.classTemplateSpecializationToFunctionTemplate(spec2);
        }
        return TemplateEngine.orderTemplateFunctions(template1, template2);
    }

    protected static int orderTemplateFunctions(ITemplateSymbol spec1, ITemplateSymbol spec2) throws ParserSymbolTableException {
        boolean d2;
        Map map = TemplateEngine.createMapForFunctionTemplateOrdering(spec1);
        IContainerSymbol templatedSymbol = spec1.getTemplatedSymbol();
        if (!(templatedSymbol instanceof IParameterizedSymbol)) {
            throw new ParserSymbolTableError(-1);
        }
        IParameterizedSymbol function = (IParameterizedSymbol)templatedSymbol;
        function = (IParameterizedSymbol)function.instantiate(spec1, map);
        ((TemplateSymbol)spec1).processDeferredInstantiations();
        Map m1 = TemplateEngine.deduceTemplateArgumentsUsingParameterList(spec2, function);
        map = TemplateEngine.createMapForFunctionTemplateOrdering(spec2);
        templatedSymbol = spec2.getTemplatedSymbol();
        if (!(templatedSymbol instanceof IParameterizedSymbol)) {
            throw new ParserSymbolTableError(-1);
        }
        function = (IParameterizedSymbol)templatedSymbol;
        function = (IParameterizedSymbol)function.instantiate(spec2, map);
        ((TemplateSymbol)spec2).processDeferredInstantiations();
        Map m2 = TemplateEngine.deduceTemplateArgumentsUsingParameterList(spec1, function);
        boolean d1 = m1 != null;
        boolean bl = d2 = m2 != null;
        if (d1 && d2 || !d1 && !d2) {
            return 0;
        }
        if (d1 && !d2) {
            return 1;
        }
        return -1;
    }

    private static Map createMapForFunctionTemplateOrdering(ITemplateSymbol template) {
        HashMap<ISymbol, TypeInfo> map = new HashMap<ISymbol, TypeInfo>();
        TypeInfo val = null;
        List paramList = template.getParameterList();
        int size = paramList.size();
        int i = 0;
        while (i < size) {
            ISymbol param = (ISymbol)paramList.get(i);
            if (param.getTypeInfo().getTemplateParameterType() == TypeInfo.t_typeName) {
                val = new TypeInfo(TypeInfo.t_type, 0, template.getSymbolTable().newSymbol("", TypeInfo.t_class));
            } else if (param.getTypeInfo().getTemplateParameterType() != TypeInfo.t_template) {
                val = new TypeInfo(param.getTypeInfo().getTemplateParameterType(), 0, null);
            }
            map.put(param, val);
            ++i;
        }
        return map;
    }

    private static ITemplateSymbol classTemplateSpecializationToFunctionTemplate(ISpecializedSymbol specialization) throws ParserSymbolTableException {
        ISpecializedSymbol transformed = (ISpecializedSymbol)specialization.clone();
        transformed.getArgumentList().clear();
        transformed.getContainedSymbols().clear();
        ((ContainerSymbol)((Object)transformed)).getContents().clear();
        IParameterizedSymbol function = specialization.getSymbolTable().newParameterizedSymbol(transformed.getName(), TypeInfo.t_function);
        try {
            transformed.addSymbol(function);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        ISymbol param = specialization.getSymbolTable().newSymbol("", TypeInfo.t_type);
        param.setTypeSymbol(specialization.instantiate(specialization.getArgumentList()));
        function.addParameter(param);
        return transformed;
    }

    private static TypeInfo transformTypeInfo(Object obj, Map argumentMap) {
        TypeInfo info = null;
        info = obj instanceof ISymbol ? new TypeInfo(TypeInfo.t_type, 0, (ISymbol)obj) : (TypeInfo)obj;
        if (argumentMap == null) {
            return info;
        }
        if (info.isType(TypeInfo.t_type) && info.getTypeSymbol().isType(TypeInfo.t_templateParameter) && argumentMap.containsKey(info.getTypeSymbol())) {
            TypeInfo newType = new TypeInfo((TypeInfo)argumentMap.get(info.getTypeSymbol()));
            if (info.hasPtrOperators()) {
                newType.addPtrOperator(info.getPtrOperators());
            }
            return newType;
        }
        return info;
    }

    protected static List selectTemplateFunctions(Set templates, List functionArguments, List templateArguments) throws ParserSymbolTableException {
        if (templates == null || templates.size() == 0) {
            return null;
        }
        ArrayList<IContainerSymbol> instances = null;
        Iterator iter = templates.iterator();
        block0: while (iter.hasNext()) {
            IParameterizedSymbol fn = (IParameterizedSymbol)iter.next();
            ITemplateSymbol template = (ITemplateSymbol)fn.getContainingSymbol();
            Map map = TemplateEngine.deduceTemplateArguments(template, functionArguments);
            if (map == null) continue;
            List templateParams = template.getParameterList();
            int numTemplateParams = templateParams.size();
            int numTemplateArgs = templateArguments != null ? templateArguments.size() : 0;
            ArrayList<TypeInfo> instanceArgs = new ArrayList<TypeInfo>(templateParams.size());
            int i = 0;
            while (i < numTemplateParams) {
                ISymbol param = (ISymbol)templateParams.get(i);
                TypeInfo arg = i < numTemplateArgs ? templateArguments.get(i) : null;
                TypeInfo mapped = (TypeInfo)map.get(param);
                if (arg != null && mapped != null) {
                    if (!arg.equals(mapped)) continue block0;
                    instanceArgs.add(arg);
                } else {
                    if (arg == null && mapped == null) continue block0;
                    instanceArgs.add(arg != null ? arg : mapped);
                }
                ++i;
            }
            IContainerSymbol instance = (IContainerSymbol)template.instantiate(instanceArgs);
            if (instance == null) continue;
            if (instances == null) {
                instances = new ArrayList<IContainerSymbol>(4);
            }
            instances.add(instance);
        }
        return instances;
    }

    protected static ITemplateSymbol selectTemplateOrSpecialization(ITemplateSymbol template, List parameters, List arguments) throws ParserSymbolTableException {
        if (template != null) {
            boolean forPrimary = true;
            if (parameters.size() == 0) {
                forPrimary = false;
            } else if (arguments != null) {
                if (arguments.size() != parameters.size()) {
                    forPrimary = false;
                } else if (!parameters.isEmpty()) {
                    int size = parameters.size();
                    int i = 0;
                    while (i < size) {
                        if (parameters.get(i) != ((TypeInfo)arguments.get(i)).getTypeSymbol()) {
                            forPrimary = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
            ITemplateSymbol primary = template;
            if (forPrimary) {
                if (TemplateEngine.checkTemplateParameterListsAreEquivalent(primary.getParameterList(), parameters)) {
                    return template;
                }
                throw new ParserSymbolTableException(9);
            }
            if (parameters.isEmpty()) {
                return primary;
            }
            ISpecializedSymbol spec = TemplateEngine.findPartialSpecialization(template, parameters, arguments);
            if (spec != null) {
                return spec;
            }
            throw new ParserSymbolTableException(4);
        }
        return null;
    }

    private static boolean checkTemplateParameterListsAreEquivalent(List p1, List p2) {
        if (p1.size() != p2.size()) {
            return false;
        }
        int size = p1.size();
        int i = 0;
        while (i < size) {
            ISymbol param1 = (ISymbol)p1.get(i);
            ISymbol param2 = (ISymbol)p2.get(i);
            if (param1.getTypeInfo().getTemplateParameterType() != param2.getTypeInfo().getTemplateParameterType()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean checkTemplateArgumentListsAreEquivalent(List p1, List p2, List a1, List a2) {
        if (a1.size() != a2.size() || p1.size() != p2.size()) {
            return false;
        }
        Map[] m = new Map[]{new HashMap(), new HashMap()};
        List list = p1;
        while (list != null) {
            int size = list.size();
            int index = 0;
            int i = 0;
            while (i < size) {
                m[list == p2 ? 1 : 0].put(list.get(i), new Integer(index++));
                ++i;
            }
            if (list == p2) break;
            list = p2;
        }
        int a1Size = a1.size();
        int i = 0;
        while (i < a1Size) {
            block7: {
                block8: {
                    TypeInfo t2;
                    TypeInfo t1 = (TypeInfo)a1.get(i);
                    if (t1.equals(t2 = (TypeInfo)a2.get(i))) break block7;
                    if (!t1.isType(TypeInfo.t_type) || !t2.isType(TypeInfo.t_type)) break block8;
                    ISymbol s1 = t1.getTypeSymbol();
                    ISymbol s2 = t2.getTypeSymbol();
                    if (m[0].containsKey(s1) && m[1].containsKey(s2) && m[0].get(s1).equals(m[1].get(s2))) break block7;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private static ISpecializedSymbol findPartialSpecialization(ITemplateSymbol template, List parameters, List arguments) {
        List specs = template.getSpecializations();
        int size = specs.size();
        ISpecializedSymbol spec = null;
        int i = 0;
        while (i < size) {
            spec = (ISpecializedSymbol)specs.get(i);
            if (TemplateEngine.checkTemplateParameterListsAreEquivalent(spec.getParameterList(), parameters) && TemplateEngine.checkTemplateArgumentListsAreEquivalent(spec.getParameterList(), parameters, spec.getArgumentList(), arguments)) {
                return spec;
            }
            ++i;
        }
        return null;
    }

    protected static ISymbol translateParameterForDefinition(ISymbol templatedSymbol, ISymbol param, Map defnMap) {
        if (defnMap == Collections.EMPTY_MAP) {
            return param;
        }
        ISymbol mappedParam = param;
        while (mappedParam.isTemplateInstance()) {
            mappedParam = mappedParam.getInstantiatedSymbol();
        }
        if (defnMap.containsKey(templatedSymbol)) {
            Map map = (Map)defnMap.get(templatedSymbol);
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                ISymbol key = (ISymbol)i.next();
                if (map.get(key) != mappedParam) continue;
                return key;
            }
        }
        return param;
    }

    protected static ISymbol instantiateWithinTemplateScope(IContainerSymbol container, ITemplateSymbol symbol) throws ParserSymbolTableException {
        if (symbol.getTemplatedSymbol().isType(TypeInfo.t_function)) {
            return symbol;
        }
        ISymbol instance = null;
        IParameterizedSymbol template = null;
        IContainerSymbol containing = container.getContainingSymbol();
        boolean instantiate = false;
        while (containing != null) {
            if (containing == symbol || containing instanceof ISpecializedSymbol && ((ISpecializedSymbol)containing).getPrimaryTemplate() == symbol) {
                instantiate = true;
                template = (ITemplateSymbol)containing;
                break;
            }
            if ((containing = containing.getContainingSymbol()) != null && !containing.isTemplateMember() || !containing.isType(TypeInfo.t_template)) break;
        }
        if (instantiate) {
            if (template instanceof ISpecializedSymbol) {
                ISpecializedSymbol spec = (ISpecializedSymbol)template;
                instance = spec.instantiate(spec.getArgumentList());
            } else {
                List params = template.getParameterList();
                int size = params.size();
                ArrayList<TypeInfo> args = new ArrayList<TypeInfo>(size);
                int i = 0;
                while (i < size) {
                    args.add(new TypeInfo(TypeInfo.t_type, 0, (ISymbol)params.get(i)));
                    ++i;
                }
                instance = template.instantiate(args);
            }
        }
        return instance != null ? instance : symbol;
    }

    protected static boolean alreadyHasTemplateParameter(IContainerSymbol container, String name) {
        while (container != null) {
            ITemplateSymbol template;
            if (container instanceof ITemplateSymbol && (template = (ITemplateSymbol)container).getParameterMap().containsKey(name)) {
                return true;
            }
            container = container.getContainingSymbol();
        }
        return false;
    }

    protected static boolean canAddTemplate(IContainerSymbol containing, ITemplateSymbol template) {
        IContainerSymbol symbol;
        if (!containing.isType(TypeInfo.t_namespace) && !containing.isType(TypeInfo.t_class, TypeInfo.t_union)) {
            return false;
        }
        return !containing.isTemplateMember() || !containing.getContainingSymbol().isType(TypeInfo.t_template) || (symbol = template.getTemplatedSymbol()) == null || !symbol.isType(TypeInfo.t_function) || !symbol.getTypeInfo().checkBit(64);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static List verifyExplicitArguments(ITemplateSymbol template, List arguments, ISymbol symbol) throws ParserSymbolTableException {
        List params = template.getParameterList();
        int numParams = params.size();
        int numArgs = arguments.size();
        ArrayList<TypeInfo> actualArgs = new ArrayList<TypeInfo>(numParams);
        int i = 0;
        while (i < numParams) {
            ISymbol param = (ISymbol)params.get(i);
            if (i < numArgs) {
                TypeInfo arg = (TypeInfo)arguments.get(i);
                if (!TemplateEngine.matchTemplateParameterAndArgument(param, arg)) throw new ParserSymbolTableException(8);
                actualArgs.add(arg);
            } else if (template.getTemplatedSymbol() instanceof IParameterizedSymbol && symbol instanceof IParameterizedSymbol && template.getTemplatedSymbol().getName().equals(symbol.getName())) {
                Map map = TemplateEngine.deduceTemplateArgumentsUsingParameterList(template, (IParameterizedSymbol)symbol);
                if (map == null || !map.containsKey(param)) throw new ParserSymbolTableException(8);
                actualArgs.add((TypeInfo)map.get(param));
            }
            ++i;
        }
        return actualArgs;
    }

    protected static ITemplateSymbol resolveTemplateFunctions(Set functions, List args, ISymbol symbol) throws ParserSymbolTableException {
        ITemplateSymbol template = null;
        Iterator iter = functions.iterator();
        block0: while (iter.hasNext()) {
            IParameterizedSymbol fn = (IParameterizedSymbol)iter.next();
            ITemplateSymbol tmpl = (ITemplateSymbol)fn.getContainingSymbol();
            Map map = TemplateEngine.deduceTemplateArgumentsUsingParameterList(tmpl, (IParameterizedSymbol)symbol);
            if (map == null) continue;
            List params = tmpl.getParameterList();
            int numParams = params.size();
            int numArgs = args.size();
            int i = 0;
            while (i < numParams && i < numArgs) {
                ISymbol param = (ISymbol)params.get(i);
                TypeInfo arg = (TypeInfo)args.get(i);
                if (map.containsKey(param) ? !map.get(param).equals(arg) : !TemplateEngine.matchTemplateParameterAndArgument(param, arg)) continue block0;
                ++i;
            }
            if (template != null) {
                throw new ParserSymbolTableException(0);
            }
            template = tmpl;
        }
        return template;
    }

    protected static List resolveTemplateFunctionArguments(List args, ITemplateSymbol template, IParameterizedSymbol fn) {
        ArrayList<TypeInfo> resultList = new ArrayList<TypeInfo>();
        List params = template.getParameterList();
        Map map = null;
        int numParams = params.size();
        int numArgs = args != null ? args.size() : 0;
        int i = 0;
        while (i < numParams) {
            ISymbol param = (ISymbol)params.get(i);
            TypeInfo arg = null;
            if (i < numArgs) {
                arg = (TypeInfo)args.get(i);
            } else {
                if (map == null && (map = TemplateEngine.deduceTemplateArgumentsUsingParameterList(template, fn)) == null) {
                    return null;
                }
                if (map.containsKey(param)) {
                    arg = (TypeInfo)map.get(param);
                }
            }
            if (arg == null || !TemplateEngine.matchTemplateParameterAndArgument(param, arg)) {
                return null;
            }
            resultList.add(arg);
            ++i;
        }
        return resultList;
    }

    protected static ISymbol checkForTemplateExplicitSpecialization(ITemplateSymbol template, ISymbol symbol, List arguments) {
        if (!template.getExplicitSpecializations().isEmpty()) {
            Iterator iter = template.getExplicitSpecializations().keySet().iterator();
            List args = null;
            while (iter.hasNext()) {
                Map explicitMap;
                args = (List)iter.next();
                if (!args.equals(arguments) || !(explicitMap = (Map)template.getExplicitSpecializations().get(args)).containsKey(symbol)) continue;
                return (ISymbol)explicitMap.get(symbol);
            }
        }
        return null;
    }

    protected static boolean templateParametersAreEquivalent(ISymbol p1, ISymbol p2) {
        if (!p1.isType(TypeInfo.t_templateParameter) || !p2.isType(TypeInfo.t_templateParameter) || p1.getTypeInfo().getTemplateParameterType() != p2.getTypeInfo().getTemplateParameterType()) {
            return false;
        }
        ITemplateSymbol t1 = TemplateEngine.getContainingTemplate(p1);
        ITemplateSymbol t2 = TemplateEngine.getContainingTemplate(p2);
        if (p1.getTypeInfo().getTemplateParameterType() == TypeInfo.t_typeName) {
            List l1 = t1.getParameterList();
            List l2 = t2.getParameterList();
            return l1 != null && l2 != null && l1.indexOf(p1) == l2.indexOf(p2);
        }
        if (p1.getTypeInfo().getTemplateParameterType() == TypeInfo.t_template) {
            ITemplateSymbol pt1 = (ITemplateSymbol)p1.getTypeSymbol();
            ITemplateSymbol pt2 = (ITemplateSymbol)p2.getTypeSymbol();
            return TemplateEngine.checkTemplateParameterListsAreEquivalent(pt1.getParameterList(), pt2.getParameterList());
        }
        return p1.getTypeInfo().equals(p2.getTypeInfo());
    }

    /*
     * Unable to fully structure code
     */
    protected static ITemplateSymbol getContainingTemplate(ISymbol symbol) {
        if (symbol.isTemplateMember()) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            symbol = symbol.getContainingSymbol();
lbl4:
            // 2 sources

            ** while (!(symbol.getContainingSymbol() instanceof ITemplateSymbol))
        }
lbl5:
        // 1 sources

        return (ITemplateSymbol)symbol.getContainingSymbol();
    }

    protected static boolean deferedInstancesAreEquivalent(IDeferredTemplateInstance instance, IDeferredTemplateInstance instance2) {
        if (instance.getTemplate() != instance2.getTemplate()) {
            return false;
        }
        List args = instance.getArguments();
        List args2 = instance2.getArguments();
        int size = args.size();
        if (size != args2.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            TypeInfo info2;
            TypeInfo info1 = (TypeInfo)args.get(i);
            if (!info1.equals(info2 = (TypeInfo)args2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

