/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;

public class CharArrayPool {
    private int currEntry = -1;
    private int[] hashTable;
    private int[] nextTable;
    private char[][] stringTable;

    public CharArrayPool(int tableSize) {
        int size = 1;
        while (size < tableSize) {
            size <<= 1;
        }
        this.hashTable = new int[size << 1];
        this.nextTable = new int[tableSize];
        this.stringTable = new char[tableSize][];
    }

    private final int hash(char[] source, int start, int length) {
        return CharArrayUtils.hash(source, start, length) & this.hashTable.length - 1;
    }

    private static final boolean equals(char[] str1, int start, int length, char[] str2) {
        if (str2.length != length) {
            return false;
        }
        int curr = start;
        int i = 0;
        while (i < length) {
            if (str1[curr++] != str2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final char[] find(char[] source, int start, int length, int hash) {
        int i = this.hashTable[hash] - 1;
        do {
            char[] str;
            if (!CharArrayPool.equals(source, start, length, str = this.stringTable[i])) continue;
            return str;
        } while ((i = this.nextTable[i] - 1) >= 0);
        return null;
    }

    private final void remove() {
        int hash = this.hash(this.stringTable[this.currEntry], 0, this.stringTable[this.currEntry].length);
        int i = this.hashTable[hash] - 1;
        if (i == this.currEntry) {
            this.hashTable[hash] = this.nextTable[this.currEntry];
        } else {
            do {
                int last = i;
            } while ((i = this.nextTable[i] - 1) != this.currEntry);
            this.nextTable[last] = this.nextTable[this.currEntry];
        }
        this.stringTable[this.currEntry] = null;
        this.nextTable[this.currEntry] = 0;
    }

    private final void addHashed(char[] str, int hash) {
        if (++this.currEntry == this.stringTable.length) {
            this.currEntry = 0;
        }
        if (this.stringTable[this.currEntry] != null) {
            this.remove();
        }
        this.stringTable[this.currEntry] = str;
        if (this.hashTable[hash] != 0) {
            this.nextTable[this.currEntry] = this.hashTable[hash];
        }
        this.hashTable[hash] = this.currEntry + 1;
    }

    public final char[] add(char[] source, int start, int length) {
        int hash = this.hash(source, start, length);
        char[] result = null;
        if (this.hashTable[hash] > 0) {
            result = this.find(source, start, length, hash);
        }
        if (result == null) {
            result = new char[length];
            System.arraycopy(source, 0, result, 0, length);
            this.addHashed(result, hash);
        }
        return result;
    }

    public final char[] add(char[] source) {
        return this.add(source, 0, source.length);
    }
}

