/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.internal.ui.preferences.CFileTypesPreferenceBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CFileTypesPropertyPage
extends PropertyPage {
    private Button fUseWorkspace;
    private Button fUseProject;
    private CFileTypesPreferenceBlock fPrefsBlock;

    protected Control createContents(Composite parent) {
        Composite topPane = new Composite(parent, 0);
        topPane.setLayout((Layout)new GridLayout());
        topPane.setLayoutData((Object)new GridData(1808));
        Composite radioPane = new Composite(topPane, 0);
        radioPane.setLayout((Layout)new GridLayout());
        radioPane.setLayoutData((Object)new GridData(768));
        this.fUseWorkspace = new Button(radioPane, 16);
        this.fUseWorkspace.setText(PreferencesMessages.getString("CFileTypesPropertyPage.useWorkspaceSettings"));
        this.fUseWorkspace.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CFileTypesPropertyPage.this.fPrefsBlock.setEnabled(false);
            }
        });
        this.fUseProject = new Button(radioPane, 16);
        this.fUseProject.setText(PreferencesMessages.getString("CFileTypesPropertyPage.useProjectSettings"));
        this.fUseProject.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CFileTypesPropertyPage.this.fPrefsBlock.setEnabled(true);
            }
        });
        IProject project = this.getProject();
        ICFileTypeResolver resolver = CCorePlugin.getDefault().getFileTypeResolver(project);
        IResolverModel model = CCorePlugin.getDefault().getResolverModel();
        boolean custom = model.getResolver() != model.getResolver(project);
        Composite blockPane = new Composite(topPane, 0);
        blockPane.setLayout((Layout)new GridLayout());
        blockPane.setLayoutData((Object)new GridData(1808));
        this.fPrefsBlock = new CFileTypesPreferenceBlock(resolver);
        this.fPrefsBlock.createControl(blockPane);
        this.fUseWorkspace.setSelection(!custom);
        this.fUseProject.setSelection(custom);
        this.fPrefsBlock.setEnabled(custom);
        WorkbenchHelp.setHelp((Control)topPane, (String)"org.eclipse.cdt.ui.std_prop_file_types");
        return topPane;
    }

    protected void performDefaults() {
        this.fUseWorkspace.setSelection(true);
        this.fUseProject.setSelection(false);
        this.fPrefsBlock.setEnabled(false);
        super.performDefaults();
    }

    public boolean performOk() {
        IResolverModel model = this.getResolverModel();
        if (this.fUseProject.getSelection()) {
            if (this.fPrefsBlock.performOk()) {
                model.setResolver(this.getProject(), this.fPrefsBlock.getResolver());
            }
        } else {
            model.setResolver(this.getProject(), null);
        }
        return super.performOk();
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        IProject project = null;
        if (element != null && element instanceof IProject) {
            project = (IProject)element;
        }
        return project;
    }

    private IResolverModel getResolverModel() {
        return CCorePlugin.getDefault().getResolverModel();
    }
}

