/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Expression;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarCreateInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class ExpressionManager
extends Manager
implements ICDIExpressionManager {
    private List expList;
    MIVarChange[] noChanges = new MIVarChange[0];

    public ExpressionManager(Session session) {
        super(session, true);
        this.expList = Collections.synchronizedList(new ArrayList());
    }

    void removeMIVar(MIVar miVar) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarDelete var = factory.createMIVarDelete(miVar.getVarName());
        try {
            mi.postCommand(var);
            var.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void removeExpression(String varName) throws CDIException {
        Expression[] exps = this.expList.toArray(new Expression[0]);
        int i = 0;
        while (i < exps.length) {
            if (exps[i].getMIVar().getVarName().equals(varName)) {
                this.expList.remove(exps[i]);
                this.removeMIVar(exps[i].getMIVar());
            }
            ++i;
        }
    }

    public ICDIExpression createExpression(String name) throws CDIException {
        Expression expression = null;
        try {
            Session session = (Session)this.getSession();
            ICDITarget currentTarget = session.getCurrentTarget();
            MISession mi = session.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIVarCreate var = factory.createMIVarCreate(name);
            mi.postCommand(var);
            MIVarCreateInfo info = var.getMIVarCreateInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            VariableObject varObj = new VariableObject(currentTarget, name, null, 0, 0);
            expression = new Expression(varObj, info.getMIVar());
            this.expList.add(expression);
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return expression;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIExpression createExpression(ICDIStackFrame frame, String name) throws CDIException {
        Expression expression = null;
        Session session = (Session)this.getSession();
        ICDITarget currentTarget = session.getCurrentTarget();
        ICDIThread currentThread = currentTarget.getCurrentThread();
        ICDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        frame.getThread().setCurrentStackFrame(frame, false);
        try {
            try {
                MISession mi = session.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var);
                MIVarCreateInfo info = var.getMIVarCreateInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                ICDITarget tgt = frame.getThread().getTarget();
                VariableObject varObj = new VariableObject(tgt, name, frame, 0, 0);
                expression = new Expression(varObj, info.getMIVar());
                this.expList.add(expression);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        currentThread.setCurrentStackFrame(currentFrame, false);
        return expression;
    }

    public ICDIExpression[] getExpressions() throws CDIException {
        return this.expList.toArray(new ICDIExpression[0]);
    }

    public void destroyExpression(ICDIExpression expression) throws CDIException {
        if (expression instanceof Expression) {
            Expression exp = (Expression)expression;
            MIVarDeletedEvent del = new MIVarDeletedEvent(exp.getMIVar().getVarName());
            Session session = (Session)this.getSession();
            MISession mi = session.getMISession();
            mi.fireEvent(del);
        }
    }

    public Variable getExpression(String varName) {
        Expression[] exps = this.expList.toArray(new Expression[0]);
        int i = 0;
        while (i < exps.length) {
            if (exps[i].getMIVar().getVarName().equals(varName)) {
                return exps[i];
            }
            Variable v = exps[i].getChild(varName);
            if (v != null) {
                return v;
            }
            ++i;
        }
        return null;
    }

    public void update() throws CDIException {
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>();
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        Expression[] exps = this.expList.toArray(new Expression[0]);
        int i = 0;
        while (i < exps.length) {
            String varName = exps[i].getMIVar().getVarName();
            MIVarChange[] changes = this.noChanges;
            MIVarUpdate update = factory.createMIVarUpdate(varName);
            try {
                mi.postCommand(update);
                MIVarUpdateInfo info = update.getMIVarUpdateInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                changes = info.getMIVarChanges();
            }
            catch (MIException mIException) {
                eventList.add(new MIVarDeletedEvent(varName));
            }
            int j = 0;
            while (j < changes.length) {
                String n = changes[j].getVarName();
                if (changes[j].isInScope()) {
                    eventList.add(new MIVarChangedEvent(n));
                }
                ++j;
            }
            ++i;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }
}

