/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISignalManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Signal;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIHandle;
import org.eclipse.cdt.debug.mi.core.command.MIInfoSignals;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfoSignalsInfo;
import org.eclipse.cdt.debug.mi.core.output.MISigHandle;

public class SignalManager
extends Manager
implements ICDISignalManager {
    MISigHandle[] noSigs = new MISigHandle[0];
    List signalsList = null;

    public SignalManager(Session session) {
        super(session, false);
    }

    MISigHandle[] getMISignals() throws CDIException {
        MISigHandle[] miSigs = this.noSigs;
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIInfoSignals sigs = factory.createMIInfoSignals();
        try {
            mi.postCommand(sigs);
            MIInfoSignalsInfo info = sigs.getMIInfoSignalsInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            miSigs = info.getMISignals();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return miSigs;
    }

    MISigHandle getMISignal(String name) throws CDIException {
        MISigHandle sig = null;
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIInfoSignals sigs = factory.createMIInfoSignals(name);
        try {
            mi.postCommand(sigs);
            MIInfoSignalsInfo info = sigs.getMIInfoSignalsInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            MISigHandle[] miSigs = info.getMISignals();
            if (miSigs.length > 0) {
                sig = miSigs[0];
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return sig;
    }

    private boolean hasSignalChanged(ICDISignal sig, MISigHandle miSignal) {
        return !sig.getName().equals(miSignal.getName()) || sig.isStopSet() != miSignal.isStop() || sig.isIgnore() != !miSignal.isPass();
    }

    public ICDISignal findSignal(String name) {
        ICDISignal sig = null;
        if (this.signalsList != null) {
            ICDISignal[] sigs = this.signalsList.toArray(new ICDISignal[0]);
            int i = 0;
            while (i < sigs.length) {
                if (sigs[i].getName().equals(name)) {
                    sig = sigs[i];
                    break;
                }
                ++i;
            }
        }
        return sig;
    }

    public ICDISignal getSignal(String name) {
        ICDISignal sig = this.findSignal(name);
        if (sig == null) {
            MISigHandle miSig = null;
            try {
                miSig = this.getMISignal(name);
                sig = new Signal(this, miSig);
                if (this.signalsList != null) {
                    this.signalsList.add(sig);
                }
            }
            catch (CDIException cDIException) {
                miSig = new MISigHandle(name, false, false, false, name);
                sig = new Signal(this, miSig);
            }
        }
        return sig;
    }

    public void handle(ICDISignal sig, boolean isIgnore, boolean isStop) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        StringBuffer buffer = new StringBuffer(sig.getName());
        buffer.append(" ");
        if (isIgnore) {
            buffer.append("ignore");
        } else {
            buffer.append("noignore");
        }
        buffer.append(" ");
        if (isStop) {
            buffer.append("stop");
        } else {
            buffer.append("nostop");
        }
        MIHandle handle = factory.createMIHandle(buffer.toString());
        try {
            mi.postCommand(handle);
            handle.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        ((Signal)sig).getMISignal().handle(isIgnore, isStop);
        mi.fireEvent(new MISignalChangedEvent(sig.getName()));
    }

    public ICDISignal[] getSignals() throws CDIException {
        if (this.signalsList == null) {
            this.update();
        }
        return this.signalsList.toArray(new ICDISignal[0]);
    }

    public void update() throws CDIException {
        Session session = (Session)this.getSession();
        MISigHandle[] miSigs = this.getMISignals();
        ArrayList<MISignalChangedEvent> eventList = new ArrayList<MISignalChangedEvent>(miSigs.length);
        if (this.signalsList == null) {
            this.signalsList = Collections.synchronizedList(new ArrayList(5));
        }
        int i = 0;
        while (i < miSigs.length) {
            ICDISignal sig = this.findSignal(miSigs[i].getName());
            if (sig != null) {
                if (this.hasSignalChanged(sig, miSigs[i])) {
                    ((Signal)sig).setMISignal(miSigs[i]);
                    eventList.add(new MISignalChangedEvent(miSigs[i].getName()));
                }
            } else {
                this.signalsList.add(new Signal(this, miSigs[i]));
            }
            ++i;
        }
        MISession mi = session.getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }
}

