/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.util;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class CModelUtil {
    public static ITranslationUnit toWorkingCopy(ITranslationUnit unit) {
        ITranslationUnit workingCopy;
        if (!unit.isWorkingCopy() && (workingCopy = EditorUtility.getWorkingCopy(unit)) != null) {
            return workingCopy;
        }
        return unit;
    }

    public static ITranslationUnit toOriginal(ITranslationUnit unit) {
        if (unit.isWorkingCopy()) {
            return ((IWorkingCopy)unit).getOriginalElement();
        }
        return unit;
    }

    public static ISourceRoot getSourceRoot(ICElement element) {
        ICElement root = element;
        while (root != null) {
            if (root instanceof ISourceRoot) {
                return (ISourceRoot)root;
            }
            ICElement parent = root.getAncestor(12);
            if (parent == root) {
                return null;
            }
            root = parent;
        }
        return null;
    }

    public static boolean isReferenced(ISourceRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject project = resource.getProject();
            IProject container = root.getCProject().getProject();
            return !container.equals((Object)project);
        }
        return false;
    }
}

