/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTNode;

public class ASTElaboratedTypeSpecifier
extends ASTNode
implements IASTElaboratedTypeSpecifier {
    private NamedOffsets offsets = new NamedOffsets();
    private final String typeName;
    private final ASTClassKind classKind;
    private final ASTQualifiedNamedElement qualifiedName;

    public ASTElaboratedTypeSpecifier(IASTScope scope, ASTClassKind elaboratedClassKind, String typeName, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, int endOffset, int endingLine) {
        this.classKind = elaboratedClassKind;
        this.typeName = typeName;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.setEndingOffsetAndLineNumber(endOffset, endingLine);
        this.qualifiedName = new ASTQualifiedNamedElement(scope, typeName);
    }

    public String getName() {
        return this.typeName;
    }

    public ASTClassKind getClassKind() {
        return this.classKind;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public boolean isResolved() throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptElaboratedForewardDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setNameEndOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }
}

