/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.Offsets;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.quick.IASTQScope;

public class ASTLinkageSpecification
extends ASTDeclaration
implements IASTDeclaration,
IASTLinkageSpecification,
IASTQScope {
    private final String linkage;
    private List declarations = new ArrayList();
    private Offsets offsets = new Offsets();

    public ASTLinkageSpecification(IASTScope scope, String linkage, int startingOffset, int startingLine) {
        super(scope);
        this.linkage = linkage;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
    }

    public String getLinkageString() {
        return this.linkage;
    }

    public Iterator getDeclarations() {
        return this.declarations.iterator();
    }

    public void addDeclaration(IASTDeclaration declaration) {
        this.declarations.add(declaration);
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.enterLinkageSpecification(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.exitLinkageSpecification(this);
        }
        catch (Exception exception) {}
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }
}

