/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.pst.ExtensibleSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class BasicSymbol
extends ExtensibleSymbol
implements ISymbol {
    private String _name;
    private TypeInfo _typeInfo;
    private int _depth;
    private boolean _isInvisible = false;
    private boolean _isTemplateMember = false;
    private ISymbol _instantiatedSymbol = null;

    public BasicSymbol(ParserSymbolTable table, String name) {
        super(table);
        this._name = name;
        this._typeInfo = new TypeInfo();
    }

    public BasicSymbol(ParserSymbolTable table, String name, ISymbolASTExtension obj) {
        super(table, obj);
        this._name = name;
        this._typeInfo = new TypeInfo();
    }

    public BasicSymbol(ParserSymbolTable table, String name, TypeInfo.eType typeInfo) {
        super(table);
        this._name = name;
        this._typeInfo = new TypeInfo(typeInfo, 0, null);
    }

    public ISymbol instantiate(ITemplateSymbol template, Map argMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember() && !this.getContainingSymbol().isTemplateMember()) {
            return null;
        }
        ISymbol newSymbol = (ISymbol)this.clone();
        newSymbol.setTypeInfo(TemplateEngine.instantiateTypeInfo(newSymbol.getTypeInfo(), template, argMap));
        newSymbol.setInstantiatedSymbol(this);
        return newSymbol;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setContainingSymbol(IContainerSymbol scope) {
        super.setContainingSymbol(scope);
        this._depth = scope.getDepth() + 1;
    }

    public void setType(TypeInfo.eType t) {
        this.getTypeInfo().setType(t);
    }

    public TypeInfo.eType getType() {
        return this.getTypeInfo().getType();
    }

    public boolean isType(TypeInfo.eType type) {
        return this.getTypeInfo().isType(type, TypeInfo.t_undef);
    }

    public boolean isType(TypeInfo.eType type, TypeInfo.eType upperType) {
        return this.getTypeInfo().isType(type, upperType);
    }

    public ISymbol getTypeSymbol() {
        ISymbol symbol = this.getTypeInfo().getTypeSymbol();
        if (symbol != null && symbol.getTypeInfo().isForwardDeclaration() && symbol.getTypeSymbol() != null) {
            return symbol.getTypeSymbol();
        }
        return symbol;
    }

    public void setTypeSymbol(ISymbol type) {
        this.getTypeInfo().setTypeSymbol(type);
    }

    public TypeInfo getTypeInfo() {
        return this._typeInfo;
    }

    public void setTypeInfo(TypeInfo info) {
        this._typeInfo = info;
    }

    public boolean isForwardDeclaration() {
        return this.getTypeInfo().isForwardDeclaration();
    }

    public void setIsForwardDeclaration(boolean forward) {
        this.getTypeInfo().setIsForwardDeclaration(forward);
    }

    public int compareCVQualifiersTo(ISymbol symbol) {
        int size2;
        int size = symbol.getTypeInfo().hasPtrOperators() ? symbol.getTypeInfo().getPtrOperators().size() : 0;
        int n = size2 = this.getTypeInfo().hasPtrOperators() ? this.getTypeInfo().getPtrOperators().size() : 0;
        if (size != size2) {
            return size2 - size;
        }
        if (size == 0) {
            return 0;
        }
        TypeInfo.PtrOp op1 = null;
        TypeInfo.PtrOp op2 = null;
        int i = 0;
        while (i > size) {
            op1 = (TypeInfo.PtrOp)symbol.getTypeInfo().getPtrOperators().get(i);
            if (op1.compareCVTo(op2 = (TypeInfo.PtrOp)this.getTypeInfo().getPtrOperators().get(i)) != 0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public List getPtrOperators() {
        return this.getTypeInfo().getPtrOperators();
    }

    public void addPtrOperator(TypeInfo.PtrOp ptrOp) {
        this.getTypeInfo().addPtrOperator(ptrOp);
    }

    public void preparePtrOperatros(int numPtrOps) {
        this.getTypeInfo().preparePtrOperators(numPtrOps);
    }

    public int getDepth() {
        return this._depth;
    }

    public boolean isTemplateMember() {
        return this._isTemplateMember;
    }

    public void setIsTemplateMember(boolean isMember) {
        this._isTemplateMember = isMember;
    }

    public boolean isTemplateInstance() {
        return this._instantiatedSymbol != null;
    }

    public ISymbol getInstantiatedSymbol() {
        return this._instantiatedSymbol;
    }

    public void setInstantiatedSymbol(ISymbol symbol) {
        this._instantiatedSymbol = symbol;
    }

    public boolean getIsInvisible() {
        return this._isInvisible;
    }

    public void setIsInvisible(boolean invisible) {
        this._isInvisible = invisible;
    }

    public Object clone() {
        BasicSymbol s = (BasicSymbol)super.clone();
        s._typeInfo = new TypeInfo(s._typeInfo);
        return s;
    }
}

