/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class TypeFilter {
    private Set acceptedTypes = new HashSet();
    private Set acceptedKinds = new HashSet();
    private boolean lookingInThis = false;

    public TypeFilter() {
    }

    public TypeFilter(Set types) {
        this.acceptedTypes.addAll(types);
    }

    public TypeFilter(TypeInfo.eType type) {
        this.acceptedTypes.add(type);
    }

    public TypeFilter(IASTNode.LookupKind kind) {
        this.acceptedKinds.add(kind);
        this.populatedAcceptedTypes(kind);
    }

    public void addAcceptedType(TypeInfo.eType type) {
        this.acceptedTypes.add(type);
    }

    public void addAcceptedType(IASTNode.LookupKind kind) {
        this.populatedAcceptedTypes(kind);
        this.acceptedKinds.add(kind);
    }

    public boolean willAccept(TypeInfo.eType type) {
        return this.acceptedTypes.contains(TypeInfo.t_any) || this.acceptedTypes.contains(type);
    }

    public boolean shouldAccept(ISymbol symbol) {
        return this.shouldAccept(symbol, symbol.getTypeInfo());
    }

    public boolean shouldAccept(ISymbol symbol, TypeInfo typeInfo) {
        boolean symbolIsLocal;
        if (this.acceptedTypes.contains(TypeInfo.t_any)) {
            return true;
        }
        if (this.acceptedKinds.isEmpty()) {
            return this.acceptedTypes.contains(typeInfo.getType());
        }
        IContainerSymbol container = symbol.getContainingSymbol();
        boolean symbolIsMember = container.isType(TypeInfo.t_class, TypeInfo.t_union);
        boolean bl = symbolIsLocal = container.isType(TypeInfo.t_constructor, TypeInfo.t_function) || container.isType(TypeInfo.t_block);
        if (typeInfo.isType(TypeInfo.t_function)) {
            return this.acceptedKinds.contains(IASTNode.LookupKind.FUNCTIONS) && !symbolIsMember || this.acceptedKinds.contains(IASTNode.LookupKind.METHODS) && symbolIsMember;
        }
        if (typeInfo.isType(TypeInfo.t_type) && typeInfo.checkBit(256)) {
            return this.acceptedKinds.contains(IASTNode.LookupKind.TYPEDEFS) || this.acceptedKinds.contains(IASTNode.LookupKind.TYPES);
        }
        if (typeInfo.isType(TypeInfo.t_type) || typeInfo.isType(TypeInfo.t__Bool, TypeInfo.t_void)) {
            return this.acceptedKinds.contains(IASTNode.LookupKind.VARIABLES) && !symbolIsMember && !symbolIsLocal || this.acceptedKinds.contains(IASTNode.LookupKind.LOCAL_VARIABLES) && !symbolIsMember && symbolIsLocal || this.acceptedKinds.contains(IASTNode.LookupKind.FIELDS) && symbolIsMember;
        }
        return this.acceptedTypes.contains(typeInfo.getType());
    }

    private void populatedAcceptedTypes(IASTNode.LookupKind kind) {
        if (kind == IASTNode.LookupKind.ALL) {
            this.acceptedTypes.add(TypeInfo.t_any);
        } else if (kind == IASTNode.LookupKind.STRUCTURES) {
            this.acceptedTypes.add(TypeInfo.t_class);
            this.acceptedTypes.add(TypeInfo.t_struct);
            this.acceptedTypes.add(TypeInfo.t_union);
        } else if (kind == IASTNode.LookupKind.STRUCTS) {
            this.acceptedTypes.add(TypeInfo.t_struct);
        } else if (kind == IASTNode.LookupKind.UNIONS) {
            this.acceptedTypes.add(TypeInfo.t_union);
        } else if (kind == IASTNode.LookupKind.CLASSES) {
            this.acceptedTypes.add(TypeInfo.t_class);
        } else if (kind == IASTNode.LookupKind.CONSTRUCTORS) {
            this.acceptedTypes.add(TypeInfo.t_constructor);
        } else if (kind == IASTNode.LookupKind.NAMESPACES) {
            this.acceptedTypes.add(TypeInfo.t_namespace);
        } else if (kind == IASTNode.LookupKind.ENUMERATIONS) {
            this.acceptedTypes.add(TypeInfo.t_enumeration);
        } else if (kind == IASTNode.LookupKind.ENUMERATORS) {
            this.acceptedTypes.add(TypeInfo.t_enumerator);
        } else if (kind == IASTNode.LookupKind.TYPES) {
            this.acceptedTypes.add(TypeInfo.t_class);
            this.acceptedTypes.add(TypeInfo.t_struct);
            this.acceptedTypes.add(TypeInfo.t_union);
            this.acceptedTypes.add(TypeInfo.t_enumeration);
        }
    }

    public void setLookingInThis(boolean inThis) {
        this.lookingInThis = inThis;
    }

    public boolean isLookingInThis() {
        return this.lookingInThis;
    }
}

