/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.IResumeWithoutSignal;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.CExpressionTarget;
import org.eclipse.cdt.debug.internal.core.CGlobalVariableManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class CStackFrame
extends CDebugElement
implements ICStackFrame,
IRestart,
IResumeWithoutSignal,
ICDIEventListener {
    private ICDIStackFrame fCDIStackFrame;
    private ICDIStackFrame fLastCDIStackFrame;
    private CThread fThread;
    private List fVariables;
    private boolean fRefreshVariables = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public CStackFrame(CThread thread, ICDIStackFrame cdiFrame) {
        super((CDebugTarget)thread.getDebugTarget());
        this.setCDIStackFrame(cdiFrame);
        this.setThread(thread);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        ICGlobalVariable[] globals = this.getGlobals();
        List vars = this.getVariables0();
        ArrayList<ICGlobalVariable> all = new ArrayList<ICGlobalVariable>(globals.length + vars.size());
        all.addAll(Arrays.asList(globals));
        all.addAll(vars);
        return all.toArray(new IVariable[all.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        ((CThread)this.getThread()).switchToFrame(this);
        if (this.fVariables == null) {
            List vars = this.getAllCDIVariableObjects();
            this.fVariables = new ArrayList(vars.size());
            Iterator it = vars.iterator();
            while (it.hasNext()) {
                this.fVariables.add(new CModificationVariable(this, (ICDIVariableObject)it.next()));
            }
        } else if (this.refreshVariables()) {
            this.updateVariables();
        }
        this.setRefreshVariables(false);
        return this.fVariables;
    }

    protected void updateVariables() throws DebugException {
        List locals = this.getAllCDIVariableObjects();
        int index = 0;
        while (index < this.fVariables.size()) {
            ICDIVariableObject varObject = this.findVariable(locals, (CVariable)this.fVariables.get(index));
            if (varObject != null) {
                locals.remove(varObject);
                ++index;
                continue;
            }
            this.fVariables.remove(index);
        }
        Iterator newOnes = locals.iterator();
        while (newOnes.hasNext()) {
            this.fVariables.add(new CModificationVariable(this, (ICDIVariableObject)newOnes.next()));
        }
    }

    protected void setThread(CThread thread) {
        this.fThread = thread;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables0().size() > 0;
    }

    public int getLineNumber() throws DebugException {
        if (this.isSuspended()) {
            ISourceLocator locator = ((CDebugTarget)this.getDebugTarget()).getSourceLocator();
            if (locator != null && locator instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)locator;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iAdaptable.getAdapter((Class)clazz) != null) {
                    IAdaptable iAdaptable2 = (IAdaptable)locator;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return ((ICSourceLocator)iAdaptable2.getAdapter((Class)clazz2)).getLineNumber(this);
                }
            }
            if (this.getCDIStackFrame() != null && this.getCDIStackFrame().getLocation() != null) {
                return this.getCDIStackFrame().getLocation().getLineNumber();
            }
        }
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        ICDILocation location = this.getCDIStackFrame().getLocation();
        String func = "";
        String file = "";
        String line = "";
        if (location.getFunction() != null && location.getFunction().trim().length() > 0) {
            func = String.valueOf(func) + location.getFunction() + "() ";
        }
        if (location.getFile() != null && location.getFile().trim().length() > 0) {
            file = location.getFile();
            if (location.getLineNumber() != 0) {
                line = NumberFormat.getInstance().format(new Integer(location.getLineNumber()));
            }
        } else {
            return func;
        }
        return MessageFormat.format(CoreModelMessages.getString("CStackFrame.0"), func, file, line);
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return ((CDebugTarget)this.getDebugTarget()).getRegisterGroups();
    }

    public boolean hasRegisterGroups() throws DebugException {
        return ((CDebugTarget)this.getDebugTarget()).getRegisterGroups().length > 0;
    }

    public void handleDebugEvents(ICDIEvent[] events) {
    }

    public boolean canStepInto() {
        try {
            return this.exists() && this.isTopStackFrame() && this.getThread().canStepInto();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepOver() {
        try {
            return this.exists() && this.getThread().canStepOver();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepReturn() {
        try {
            if (!this.exists()) {
                return false;
            }
            List frames = ((CThread)this.getThread()).computeStackFrames();
            if (frames != null && !frames.isEmpty()) {
                boolean bottomFrame = this.equals(frames.get(frames.size() - 1));
                return !bottomFrame && this.getThread().canStepReturn();
            }
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return false;
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        if (this.canStepInto()) {
            this.getThread().stepInto();
        }
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.getThread().stepOver();
        } else {
            this.getThread().stepOver();
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.getThread().stepReturn();
        } else {
            this.getThread().stepReturn();
        }
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        boolean exists = false;
        try {
            exists = this.exists();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return exists && this.getThread().canTerminate() || this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.getThread().canTerminate()) {
            this.getThread().terminate();
        } else {
            this.getDebugTarget().terminate();
        }
    }

    protected ICDIStackFrame getCDIStackFrame() {
        return this.fCDIStackFrame;
    }

    protected void setCDIStackFrame(ICDIStackFrame frame) {
        this.fLastCDIStackFrame = frame != null ? frame : this.fCDIStackFrame;
        this.fCDIStackFrame = frame;
        this.setRefreshVariables(true);
    }

    protected ICDIStackFrame getLastCDIStackFrame() {
        return this.fLastCDIStackFrame;
    }

    protected static boolean equalFrame(ICDIStackFrame frameOne, ICDIStackFrame frameTwo) {
        if (frameOne == null || frameTwo == null) {
            return false;
        }
        ICDILocation loc1 = frameOne.getLocation();
        ICDILocation loc2 = frameTwo.getLocation();
        if (loc1 == null || loc2 == null) {
            return false;
        }
        if (loc1.getFile() != null && loc1.getFile().length() > 0 && loc2.getFile() != null && loc2.getFile().length() > 0 && loc1.getFile().equals(loc2.getFile()) && loc1.getFunction() != null && loc1.getFunction().length() > 0 && loc2.getFunction() != null && loc2.getFunction().length() > 0 && loc1.getFunction().equals(loc2.getFunction())) {
            return true;
        }
        if (!(loc1.getFile() != null && loc1.getFile().length() >= 1 || loc2.getFile() != null && loc2.getFile().length() >= 1 || loc1.getFunction() == null || loc1.getFunction().length() <= 0 || loc2.getFunction() == null || loc2.getFunction().length() <= 0 || !loc1.getFunction().equals(loc2.getFunction()))) {
            return true;
        }
        return !(loc1.getFile() != null && loc1.getFile().length() >= 1 || loc2.getFile() != null && loc2.getFile().length() >= 1 || loc1.getFunction() != null && loc1.getFunction().length() >= 1 || loc2.getFunction() != null && loc2.getFunction().length() >= 1 || loc1.getAddress() != loc2.getAddress());
    }

    protected boolean exists() throws DebugException {
        return ((CThread)this.getThread()).computeStackFrames().indexOf(this) != -1;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToAddress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz3) {
            return this;
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.eclipse.cdt.debug.core.model.ICStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz4) {
            return this;
        }
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("org.eclipse.debug.core.model.IStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz5) {
            return this;
        }
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz6) {
            return this.getCDIStackFrame();
        }
        return super.getAdapter(adapter);
    }

    protected void dispose() {
        this.getCDISession().getEventManager().removeEventListener(this);
        this.disposeAllVariables();
    }

    protected List getCDILocalVariableObjects() throws DebugException {
        ArrayList<ICDIVariableObject> list = new ArrayList<ICDIVariableObject>();
        try {
            list.addAll(Arrays.asList(this.getCDISession().getVariableManager().getLocalVariableObjects(this.getCDIStackFrame())));
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
        return list;
    }

    protected List getCDIArgumentObjects() throws DebugException {
        ArrayList<ICDIArgumentObject> list = new ArrayList<ICDIArgumentObject>();
        try {
            list.addAll(Arrays.asList(this.getCDISession().getVariableManager().getArgumentObjects(this.getCDIStackFrame())));
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
        return list;
    }

    protected List getAllCDIVariableObjects() throws DebugException {
        ArrayList list = new ArrayList();
        list.addAll(this.getCDIArgumentObjects());
        list.addAll(this.getCDILocalVariableObjects());
        return list;
    }

    protected boolean isTopStackFrame() throws DebugException {
        IStackFrame tos = this.getThread().getTopStackFrame();
        return tos != null && tos.equals(this);
    }

    protected void disposeAllVariables() {
        if (this.fVariables == null) {
            return;
        }
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((CVariable)it.next()).dispose();
        }
        this.fVariables = null;
    }

    public long getAddress() {
        return this.getCDIStackFrame().getLocation().getAddress();
    }

    public String getFile() {
        return this.getCDIStackFrame().getLocation().getFile();
    }

    public String getFunction() {
        return this.getCDIStackFrame().getLocation().getFunction();
    }

    public int getLevel() {
        return this.getCDIStackFrame().getLevel();
    }

    public int getFrameLineNumber() {
        return this.getCDIStackFrame().getLocation().getLineNumber();
    }

    protected synchronized void preserve() {
        this.preserveVariables();
    }

    private void preserveVariables() {
        if (this.fVariables == null) {
            return;
        }
        try {
            Iterator it = this.fVariables.iterator();
            while (it.hasNext()) {
                ((CVariable)it.next()).setChanged(false);
            }
        }
        catch (DebugException e) {
            CDebugCorePlugin.log(e);
        }
    }

    protected ICDIVariableObject findVariable(List list, CVariable var) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ICDIVariableObject newVarObject = (ICDIVariableObject)it.next();
            if (!var.sameVariableObject(newVarObject)) continue;
            return newVarObject;
        }
        return null;
    }

    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && ((IRestart)this.getDebugTarget()).canRestart();
    }

    public void restart() throws DebugException {
        if (this.canRestart()) {
            ((IRestart)this.getDebugTarget()).restart();
        }
    }

    private void setRefreshVariables(boolean refresh) {
        this.fRefreshVariables = refresh;
    }

    private boolean refreshVariables() {
        return this.fRefreshVariables;
    }

    public boolean canResumeWithoutSignal() {
        return this.getDebugTarget() instanceof IResumeWithoutSignal && ((IResumeWithoutSignal)this.getDebugTarget()).canResumeWithoutSignal();
    }

    public void resumeWithoutSignal() throws DebugException {
        if (this.canResumeWithoutSignal()) {
            ((IResumeWithoutSignal)this.getDebugTarget()).resumeWithoutSignal();
        }
    }

    public IValue evaluateExpression(String expression) throws DebugException {
        CExpressionTarget target;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.cdt.debug.internal.core.CExpressionTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (target = (CExpressionTarget)iDebugTarget.getAdapter((Class)clazz)) != null ? target.evaluateExpression(expression) : null;
    }

    private ICGlobalVariable[] getGlobals() {
        CGlobalVariableManager gvm = ((CDebugTarget)this.getDebugTarget()).getGlobalVariableManager();
        if (gvm != null) {
            return gvm.getGlobals();
        }
        return new ICGlobalVariable[0];
    }
}

