/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class FieldDeclarationPattern
extends CSearchPattern {
    private char[][] qualifications;
    private char[][] decodedQualifications;
    private char[] simpleName;
    private char[] decodedSimpleName;
    private ICSearchConstants.SearchFor searchFor;

    public FieldDeclarationPattern(char[] name, char[][] qual, int matchMode, ICSearchConstants.SearchFor sfor, ICSearchConstants.LimitTo limitTo, boolean caseSensitive) {
        super(matchMode, caseSensitive, limitTo);
        this.qualifications = qual;
        this.searchFor = sfor;
        this.simpleName = name;
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        if (node instanceof IASTField) {
            if (this.searchFor != ICSearchConstants.FIELD || !this.canAccept(limit)) {
                return 0;
            }
        } else if (node instanceof IASTVariable) {
            if (this.searchFor != ICSearchConstants.VAR || !this.canAccept(limit)) {
                return 0;
            }
        } else if (node instanceof IASTEnumerator) {
            if (this.searchFor != ICSearchConstants.ENUMTOR || !this.canAccept(limit)) {
                return 0;
            }
        } else if (node instanceof IASTParameterDeclaration) {
            if (this.searchFor != ICSearchConstants.VAR || !this.canAccept(limit)) {
                return 0;
            }
        } else if (node instanceof IASTTemplateParameter) {
            if (this.searchFor != ICSearchConstants.VAR || !this.canAccept(limit)) {
                return 0;
            }
        } else {
            return 0;
        }
        String nodeName = ((IASTOffsetableNamedElement)node).getName();
        if (this.simpleName != null && !this.matchesName(this.simpleName, nodeName.toCharArray())) {
            return 0;
        }
        String[] fullName = null;
        if (node instanceof IASTEnumerator) {
            IASTEnumerationSpecifier enumeration = ((IASTEnumerator)node).getOwnerEnumerationSpecifier();
            fullName = enumeration.getFullyQualifiedName();
            String[] enumeratorFullName = new String[fullName.length];
            System.arraycopy(fullName, 0, enumeratorFullName, 0, fullName.length);
            enumeratorFullName[fullName.length - 1] = nodeName;
            fullName = enumeratorFullName;
        } else if (node instanceof IASTQualifiedNameElement) {
            fullName = ((IASTQualifiedNameElement)node).getFullyQualifiedName();
        }
        if (fullName != null) {
            char[][] qualName = new char[fullName.length - 1][];
            int i = 0;
            while (i < fullName.length - 1) {
                qualName[i] = fullName[i].toCharArray();
                ++i;
            }
            if (!this.matchQualifications(this.qualifications, qualName)) {
                return 0;
            }
        }
        return 2;
    }

    public char[] indexEntryPrefix() {
        if (this.searchFor == ICSearchConstants.FIELD) {
            return AbstractIndexer.bestFieldPrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        if (this.searchFor == ICSearchConstants.VAR) {
            return AbstractIndexer.bestVariablePrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        if (this.searchFor == ICSearchConstants.ENUMTOR) {
            return AbstractIndexer.bestEnumeratorPrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        return null;
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
        this.decodedQualifications = null;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int firstSlash = 0;
        int slash = 0;
        if (this.searchFor == ICSearchConstants.FIELD) {
            firstSlash = CharOperation.indexOf('/', word, 0);
            slash = CharOperation.indexOf('/', word, firstSlash + 1);
        } else if (this.searchFor == ICSearchConstants.VAR) {
            int realStart = CharOperation.indexOf('/', word, 0);
            firstSlash = CharOperation.indexOf('/', word, realStart + 1);
            slash = CharOperation.indexOf('/', word, firstSlash + 1);
        } else if (this.searchFor == ICSearchConstants.ENUMTOR) {
            firstSlash = CharOperation.indexOf('/', word, 0);
            slash = CharOperation.indexOf('/', word, firstSlash + 1);
        }
        this.decodedSimpleName = CharOperation.subarray(word, firstSlash + 1, slash);
        if (slash != -1 && slash + 1 < size) {
            char[][] temp = CharOperation.splitOn('/', CharOperation.subarray(word, slash + 1, size));
            this.decodedQualifications = new char[temp.length][];
            int i = 0;
            while (i < temp.length) {
                this.decodedQualifications[i] = temp[temp.length - i - 1];
                ++i;
            }
        }
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, ICSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = file.getPath())) {
                requestor.acceptFieldDeclaration(path, this.decodedSimpleName, this.decodedQualifications);
            }
            ++i;
        }
    }

    protected boolean matchIndexEntry() {
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedQualifications);
    }
}

