/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public class MIInfoThreadsInfo
extends MIInfo {
    protected int[] threadIds;
    protected int currentThreadId;

    public MIInfoThreadsInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public int[] getThreadIds() {
        return this.threadIds;
    }

    public int getCurrentThread() {
        return this.currentThreadId;
    }

    protected void parse() {
        ArrayList aList = new ArrayList();
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord cons = (MIStreamRecord)oobs[i];
                    String str = cons.getString();
                    this.parseThreadInfo(str.trim(), aList);
                }
                ++i;
            }
        }
        this.threadIds = new int[aList.size()];
        int i = 0;
        while (i < aList.size()) {
            this.threadIds[i] = (Integer)aList.get(i);
            ++i;
        }
        Arrays.sort(this.threadIds);
    }

    protected void parseThreadInfo(String str, List aList) {
        if (str.length() > 0) {
            boolean isCurrentThread = false;
            if (str.charAt(0) == '*') {
                isCurrentThread = true;
                str = str.substring(1).trim();
            }
            if (str.length() > 0 && Character.isDigit(str.charAt(0))) {
                int i = 1;
                while (i < str.length() && Character.isDigit(str.charAt(i))) {
                    ++i;
                }
                String number = str.substring(0, i);
                try {
                    Integer num = Integer.valueOf(number);
                    aList.add(num);
                    if (isCurrentThread) {
                        this.currentThreadId = num;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }
}

