/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.StreamMonitor;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DefaultExternalScannerInfoProvider
implements IExternalScannerInfoProvider,
IMarkerGenerator {
    private static final String EXTERNAL_SI_PROVIDER_ERROR = "ExternalScannerInfoProvider.Provider_Error";
    private static final String EXTERNAL_SI_PROVIDER_CONSOLE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".ExternalScannerInfoProviderConsole";
    private IPath fWorkingDirectory;
    private IPath fCompileCommand;
    private String[] fCompileArguments;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invokeProvider(IProgressMonitor monitor, IProject currentProject, IScannerConfigBuilderInfo buildInfo, List targetSpecificOptions, IScannerInfoCollector collector) {
        if (targetSpecificOptions == null) {
            targetSpecificOptions = new ArrayList();
        }
        if (!this.initialize(currentProject, buildInfo)) {
            return false;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MakeMessages.getString("ExternalScannerInfoProvider.Reading_Specs"), 100);
        try {
            try {
                IConsole console = CCorePlugin.getDefault().getConsole(EXTERNAL_SI_PROVIDER_CONSOLE_ID);
                console.start(currentProject);
                Object cos = console.getOutputStream();
                monitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Reading_Specs"));
                String errMsg = null;
                CommandLauncher launcher = new CommandLauncher();
                launcher.showCommand(true);
                String[] compileArguments = this.fCompileArguments;
                if (buildInfo.isDefaultESIProviderCmd()) {
                    compileArguments = this.prepareArguments(targetSpecificOptions);
                }
                String ca = this.coligate(compileArguments);
                monitor.subTask(String.valueOf(MakeMessages.getString("ExternalScannerInfoProvider.Invoking_Command")) + this.fCompileCommand.toString() + ca);
                cos = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 70), (OutputStream)cos, 100);
                OutputStream sniffer = ScannerInfoConsoleParserFactory.getESIProviderOutputSniffer((OutputStream)cos, currentProject, buildInfo, collector);
                TraceUtil.outputTrace("Default provider running command:", String.valueOf(this.fCompileCommand.toString()) + ca, "");
                Process p = launcher.execute(this.fCompileCommand, compileArguments, this.setEnvironment(launcher), this.fWorkingDirectory);
                if (p != null) {
                    try {
                        p.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    if (launcher.waitAndRead(sniffer, sniffer, (IProgressMonitor)new SubProgressMonitor(monitor, 0)) != 0) {
                        errMsg = launcher.getErrorMessage();
                    }
                    monitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Parsing_Output"));
                } else {
                    errMsg = launcher.getErrorMessage();
                }
                if (errMsg != null) {
                    String errorDesc = MakeMessages.getFormattedString(EXTERNAL_SI_PROVIDER_ERROR, String.valueOf(this.fCompileCommand.toString()) + ca);
                    this.addMarker((IResource)currentProject, -1, errorDesc, 1, null);
                }
                monitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Creating_Markers"));
                sniffer.close();
                ((OutputStream)cos).close();
            }
            catch (Exception e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var15_18 = null;
        }
        monitor.done();
        return true;
    }

    private boolean initialize(IProject currentProject, IScannerConfigBuilderInfo buildInfo) {
        boolean rc = false;
        this.fWorkingDirectory = currentProject.getLocation();
        String targetFile = "dummy";
        try {
            if (currentProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                targetFile = "specs.cpp";
            } else if (currentProject.hasNature("org.eclipse.cdt.core.cnature")) {
                targetFile = "specs.c";
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e.getStatus());
        }
        IPath path2File = MakeCorePlugin.getWorkingDirectory().append(targetFile);
        if (!path2File.toFile().exists()) {
            GCCScannerConfigUtil.createSpecs();
        }
        this.fCompileCommand = buildInfo.getESIProviderCommand();
        if (this.fCompileCommand != null) {
            this.fCompileArguments = ScannerConfigUtil.tokenizeStringWithQuotes(buildInfo.getESIProviderArguments());
            int i = 0;
            while (i < this.fCompileArguments.length) {
                this.fCompileArguments[i] = this.fCompileArguments[i].replaceAll("\\$\\{plugin_state_location\\}", MakeCorePlugin.getWorkingDirectory().toString());
                this.fCompileArguments[i] = this.fCompileArguments[i].replaceAll("\\$\\{specs_file\\}", targetFile);
                ++i;
            }
            rc = true;
        }
        return rc;
    }

    private String[] prepareArguments(List tso) {
        String[] rv = null;
        int nTokens = 0;
        if (this.fCompileArguments != null && this.fCompileArguments.length > 0) {
            nTokens = this.fCompileArguments.length;
            rv = new String[nTokens + tso.size()];
            System.arraycopy(this.fCompileArguments, 0, rv, 0, nTokens);
        } else {
            rv = new String[tso.size()];
        }
        int i = 0;
        while (i < tso.size()) {
            rv[nTokens + i] = (String)tso.get(i);
            ++i;
        }
        return rv;
    }

    private String coligate(String[] array) {
        StringBuffer sb = new StringBuffer(128);
        int i = 0;
        while (i < array.length) {
            sb.append(' ');
            sb.append(array[i]);
            ++i;
        }
        String ca = sb.toString();
        return ca;
    }

    private String[] setEnvironment(CommandLauncher launcher) {
        Properties props = launcher.getEnvironment();
        props.put("CWD", this.fWorkingDirectory.toOSString());
        props.put("PWD", this.fWorkingDirectory.toOSString());
        String[] env = null;
        ArrayList<String> envList = new ArrayList<String>();
        Enumeration<?> names = props.propertyNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                envList.add(String.valueOf(key) + "=" + props.getProperty(key));
            }
            env = envList.toArray(new String[envList.size()]);
        }
        return env;
    }

    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        try {
            IMarker[] cur = file.findMarkers("org.eclipse.cdt.core.problem", false, 1);
            if (cur != null && cur.length > 0) {
                int i = 0;
                while (i < cur.length) {
                    int line = (Integer)cur[i].getAttribute("location");
                    int sev = (Integer)cur[i].getAttribute("severity");
                    String mesg = (String)cur[i].getAttribute("message");
                    if (line == lineNumber && sev == this.mapMarkerSeverity(severity) && mesg.equals(errorDesc)) {
                        return;
                    }
                    ++i;
                }
            }
            IMarker marker = file.createMarker("org.eclipse.cdt.core.problem");
            marker.setAttribute("location", lineNumber);
            marker.setAttribute("message", (Object)errorDesc);
            marker.setAttribute("severity", this.mapMarkerSeverity(severity));
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("charStart", -1);
            marker.setAttribute("charEnd", -1);
            if (errorVar != null) {
                marker.setAttribute("problem.variable", (Object)errorVar);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((IStatus)e.getStatus());
        }
    }

    int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }
}

