/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GeneratedMakefileBuilder
extends ACBuilder {
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String BUILD_FINISHED = "ManagedMakeBuilder.message.finished";
    private static final String CONSOLE_HEADER = "ManagedMakeBuilder.message.console.header";
    private static final String ERROR_HEADER = "GeneratedmakefileBuilder error [";
    private static final String MAKE = "ManagedMakeBuilder.message.make";
    private static final String MARKERS = "ManagedMakeBuilder.message.creating.markers";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String NOTHING_BUILT = "ManagedMakeBuilder.message.no.build";
    private static final String REFRESH = "ManagedMakeBuilder.message.updating";
    private static final String REFRESH_ERROR = "ManagedMakeBuilder.message.error.refresh";
    private static final String TRACE_FOOTER = "]: ";
    private static final String TRACE_HEADER = "GeneratedmakefileBuilder trace [";
    private static final String TYPE_CLEAN = "ManagedMakeBuilder.type.clean";
    private static final String TYPE_FULL = "ManagedMakeBuilder.type.full";
    private static final String TYPE_INC = "ManagedMakeBuider.type.incremental";
    public static boolean VERBOSE = false;
    private IConsole console;
    protected Vector generationProblems;
    protected IProject[] referencedProjects;
    protected List resourcesToBuild;
    protected List ruleList;

    public static void outputTrace(String resourceName, String message) {
        if (VERBOSE) {
            System.out.println(TRACE_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    public static void outputError(String resourceName, String message) {
        if (VERBOSE) {
            System.err.println(ERROR_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    private void addBuilderMarkers(ErrorParserManager epm) {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        Iterator iter = this.getGenerationProblems().iterator();
        while (iter.hasNext()) {
            IStatus stat = (IStatus)iter.next();
            IResource location = root.findMember(stat.getMessage());
            if (stat.getCode() != 0) continue;
            epm.generateMarker(location, -1, ManagedMakeMessages.getResourceString("MakefileGenerator.error.spaces"), 1, null);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.referencedProjects = this.getProject().getReferencedProjects();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (info == null) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information was not found");
            return this.referencedProjects;
        }
        String targetID = info.getDefaultTarget().getParent().getId();
        IManagedBuilderMakefileGenerator generator = ManagedBuildManager.getMakefileGenerator(targetID);
        generator.initialize(this.getProject(), info, monitor);
        if (kind == 6 || info.needsRebuild()) {
            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Full build needed/requested");
            this.fullBuild(info, generator, monitor);
        } else if (kind == 9 && info.needsRebuild()) {
            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Autobuild requested, full build needed");
            this.fullBuild(info, generator, monitor);
        } else {
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(info);
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Incremental build requested, full build needed");
                this.fullBuild(info, generator, monitor);
            } else {
                delta.accept((IResourceDeltaVisitor)visitor);
                if (visitor.shouldBuild()) {
                    GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Incremental build requested");
                    this.incrementalBuild(delta, info, generator, monitor);
                }
            }
        }
        info.setRebuildState(false);
        return this.referencedProjects;
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Build cancelled");
            this.forgetLastBuiltState();
            throw new OperationCanceledException();
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.referencedProjects = this.getProject().getReferencedProjects();
        GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Clean build requested");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (info == null) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information was not found");
            return;
        }
        IPath buildDirPath = this.getProject().getLocation().append(info.getConfigurationName());
        IWorkspace workspace = CCorePlugin.getWorkspace();
        IContainer buildDir = workspace.getRoot().getContainerForLocation(buildDirPath);
        if (buildDir == null || !buildDir.isAccessible()) {
            GeneratedMakefileBuilder.outputError(buildDir.getName(), "Could not delete the build directory");
            return;
        }
        try {
            String status = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.clean.deleting.output", buildDir.getName());
            monitor.subTask(status);
            workspace.delete(new IResource[]{buildDir}, true, monitor);
        }
        catch (CoreException coreException) {
            String status = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.clean.build.clean", buildDir.getName());
            monitor.subTask(status);
            String targetID = info.getDefaultTarget().getParent().getId();
            IManagedBuilderMakefileGenerator generator = ManagedBuildManager.getMakefileGenerator(targetID);
            generator.initialize(this.getProject(), info, monitor);
            this.cleanBuild(info, generator, monitor);
        }
    }

    protected void cleanBuild(IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) {
        IPath buildDir = generator.getBuildWorkingDir();
        if (buildDir == null) {
            buildDir = new Path(info.getConfigurationName());
        }
        IPath makefilePath = this.getProject().getLocation().append(buildDir.append(generator.getMakefileName()));
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile makefile = root.getFileForLocation(makefilePath);
        if (buildDir != null && makefile != null && makefile.isAccessible()) {
            String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
            monitor.subTask(statusMsg);
            this.checkCancel(monitor);
            this.invokeMake(15, buildDir, info, generator, monitor);
        }
    }

    protected void fullBuild(IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.checkCancel(monitor);
        String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.rebuild.makefiles", this.getProject().getName());
        monitor.subTask(statusMsg);
        String targetID = info.getDefaultTarget().getParent().getId();
        generator = ManagedBuildManager.getMakefileGenerator(targetID);
        generator.initialize(this.getProject(), info, monitor);
        MultiStatus result = generator.regenerateMakefiles();
        if (result.getCode() == 2 || result.getCode() == 1) {
            IStatus[] kids = result.getChildren();
            int index = 0;
            while (index < kids.length) {
                IStatus status = kids[index];
                if (status.getCode() == 1) {
                    return;
                }
                this.getGenerationProblems().add(status);
                ++index;
            }
        }
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
        monitor.subTask(statusMsg);
        IPath topBuildDir = generator.getBuildWorkingDir();
        if (topBuildDir == null) {
            statusMsg = ManagedMakeMessages.getFormattedString(NOTHING_BUILT, this.getProject().getName());
            monitor.subTask(statusMsg);
            return;
        }
        this.invokeMake(6, topBuildDir, info, generator, monitor);
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.regen.deps", this.getProject().getName());
        monitor.subTask(statusMsg);
        generator.regenerateDependencies(false);
        statusMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, this.getProject().getName());
        monitor.subTask(statusMsg);
    }

    public IManagedDependencyGenerator getDependencyCalculator(String toolId) {
        try {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(ManagedBuilderCorePlugin.getUniqueIdentifier(), "dependencyCalculator");
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement element = configElements[j];
                        if (element.getName().equals("tool") && element.getAttribute("id").equals(toolId) && element.getAttribute("dependencyCalculator") != null) {
                            return (IManagedDependencyGenerator)element.createExecutableExtension("dependencyCalculator");
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private Vector getGenerationProblems() {
        if (this.generationProblems == null) {
            this.generationProblems = new Vector();
        }
        return this.generationProblems;
    }

    protected String[] getMakeTargets(int buildType) {
        ArrayList<String> args = new ArrayList<String>();
        switch (buildType) {
            case 15: {
                args.add("clean");
                break;
            }
            case 6: {
                args.add("clean");
            }
            case 10: {
                args.add("all");
            }
        }
        return args.toArray(new String[args.size()]);
    }

    protected List getResourcesToBuild() {
        if (this.resourcesToBuild == null) {
            this.resourcesToBuild = new ArrayList();
        }
        return this.resourcesToBuild;
    }

    protected List getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new ArrayList();
        }
        return this.ruleList;
    }

    public IPath getWorkingDirectory() {
        return this.getProject().getLocation();
    }

    protected void incrementalBuild(IResourceDelta delta, IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.checkCancel(monitor);
        String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.update.makefiles", this.getProject().getName());
        monitor.subTask(statusMsg);
        MultiStatus result = generator.generateMakefiles(delta);
        if (result.getCode() == 2 || result.getCode() == 1) {
            IStatus[] kids = result.getChildren();
            int index = 0;
            while (index < kids.length) {
                IStatus status = kids[index];
                if (status.getCode() == 1) {
                    return;
                }
                this.getGenerationProblems().add(status);
                ++index;
            }
        }
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
        monitor.subTask(statusMsg);
        Path buildDir = new Path(info.getConfigurationName());
        if (buildDir == null) {
            statusMsg = ManagedMakeMessages.getFormattedString(NOTHING_BUILT, this.getProject().getName());
            monitor.subTask(statusMsg);
            return;
        }
        this.invokeMake(10, (IPath)buildDir, info, generator, monitor);
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.updating.deps", this.getProject().getName());
        monitor.subTask(statusMsg);
        generator.generateDependencies();
        statusMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, this.getProject().getName());
        monitor.subTask(statusMsg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invokeMake(int buildType, IPath buildDir, IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) {
        block33: {
            block32: {
                block31: {
                    IProject currentProject = this.getProject();
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        try {
                            ArrayList<String> makeArgs;
                            ConsoleOutputStream consoleOutStream;
                            StringBuffer buf;
                            Path makeCommand;
                            IPath workingDirectory;
                            block34: {
                                int i;
                                String[] args;
                                workingDirectory = this.getWorkingDirectory().append(buildDir);
                                IWorkspace workspace = currentProject.getWorkspace();
                                if (workspace == null) {
                                    Object var32_9 = null;
                                    this.getGenerationProblems().clear();
                                    return;
                                }
                                IWorkspaceRoot root = workspace.getRoot();
                                if (root == null) {
                                    break block31;
                                }
                                IPath makefile = workingDirectory.addTrailingSeparator().append(generator.getMakefileName());
                                if (root.getFileForLocation(makefile) == null) {
                                    break block32;
                                }
                                makeCommand = new Path(info.getMakeCommand());
                                if (makeCommand == null) break block33;
                                String[] msgs = new String[]{makeCommand.toString(), currentProject.getName()};
                                monitor.subTask(ManagedMakeMessages.getFormattedString(MAKE, msgs));
                                buf = new StringBuffer();
                                consoleOutStream = this.getConsole().getOutputStream();
                                String[] consoleHeader = new String[3];
                                switch (buildType) {
                                    case 6: {
                                        consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_FULL);
                                        break;
                                    }
                                    case 10: {
                                        consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_INC);
                                        break;
                                    }
                                    case 15: {
                                        consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_CLEAN);
                                        break;
                                    }
                                }
                                consoleHeader[1] = info.getConfigurationName();
                                consoleHeader[2] = currentProject.getName();
                                buf.append(System.getProperty("line.separator", "\n"));
                                buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader));
                                buf.append(System.getProperty("line.separator", "\n"));
                                buf.append(System.getProperty("line.separator", "\n"));
                                consoleOutStream.write(buf.toString().getBytes());
                                consoleOutStream.flush();
                                this.removeAllMarkers(currentProject);
                                int i2 = 0;
                                while (true) {
                                    if (i2 >= this.referencedProjects.length) {
                                        makeArgs = new ArrayList<String>();
                                        String arg = info.getMakeArguments();
                                        if (arg.length() > 0) {
                                            args = arg.split("\\s");
                                            i = 0;
                                            break;
                                        }
                                        break block34;
                                    }
                                    IProject project = this.referencedProjects[i2];
                                    this.removeAllMarkers(project);
                                    ++i2;
                                }
                                while (i < args.length) {
                                    makeArgs.add(args[i]);
                                    ++i;
                                }
                            }
                            makeArgs.addAll(Arrays.asList(this.getMakeTargets(buildType)));
                            String[] makeTargets = makeArgs.toArray(new String[makeArgs.size()]);
                            String errMsg = null;
                            CommandLauncher launcher = new CommandLauncher();
                            launcher.showCommand(true);
                            Properties props = launcher.getEnvironment();
                            props.put("CWD", workingDirectory.toOSString());
                            props.put("PWD", workingDirectory.toOSString());
                            String[] env = null;
                            ArrayList<String> envList = new ArrayList<String>();
                            Enumeration<?> names = props.propertyNames();
                            if (names != null) {
                                while (true) {
                                    if (!names.hasMoreElements()) {
                                        env = envList.toArray(new String[envList.size()]);
                                        break;
                                    }
                                    String key = (String)names.nextElement();
                                    envList.add(String.valueOf(key) + "=" + props.getProperty(key));
                                }
                            }
                            String[] errorParsers = info.getDefaultTarget().getErrorParserList();
                            ErrorParserManager epm = new ErrorParserManager(this.getProject(), workingDirectory, (IMarkerGenerator)this, errorParsers);
                            epm.setOutputStream((OutputStream)consoleOutStream);
                            OutputStream stdout = epm.getOutputStream();
                            OutputStream stderr = epm.getOutputStream();
                            Process proc = launcher.execute((IPath)makeCommand, makeTargets, env, workingDirectory);
                            if (proc != null) {
                                try {
                                    proc.getOutputStream().close();
                                }
                                catch (IOException iOException) {}
                                if (launcher.waitAndRead(stdout, stderr, (IProgressMonitor)new SubProgressMonitor(monitor, -1)) != 0) {
                                    errMsg = launcher.getErrorMessage();
                                }
                                monitor.subTask(ManagedMakeMessages.getResourceString(REFRESH));
                                try {
                                    currentProject.refreshLocal(2, null);
                                    int j = 0;
                                    while (j < this.referencedProjects.length) {
                                        IProject project = this.referencedProjects[j];
                                        project.refreshLocal(2, null);
                                        ++j;
                                    }
                                }
                                catch (CoreException coreException) {
                                    monitor.subTask(ManagedMakeMessages.getResourceString(REFRESH_ERROR));
                                }
                            } else {
                                errMsg = launcher.getErrorMessage();
                            }
                            buf = new StringBuffer();
                            if (errMsg != null && errMsg.length() > 0) {
                                String errorDesc = ManagedMakeMessages.getResourceString(BUILD_ERROR);
                                buf.append(errorDesc);
                                buf.append(System.getProperty("line.separator", "\n"));
                                buf.append("(").append(errMsg).append(")");
                            } else {
                                String successMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, currentProject.getName());
                                buf.append(successMsg);
                                buf.append(System.getProperty("line.separator", "\n"));
                            }
                            consoleOutStream.write(buf.toString().getBytes());
                            consoleOutStream.flush();
                            stdout.close();
                            stderr.close();
                            monitor.subTask(ManagedMakeMessages.getResourceString(MARKERS));
                            this.addBuilderMarkers(epm);
                            epm.reportProblems();
                        }
                        catch (Exception exception) {
                            this.forgetLastBuiltState();
                        }
                        break block33;
                    }
                    catch (Throwable throwable) {
                        Object var32_12 = null;
                        this.getGenerationProblems().clear();
                        throw throwable;
                    }
                }
                Object var32_10 = null;
                this.getGenerationProblems().clear();
                return;
            }
            Object var32_11 = null;
            this.getGenerationProblems().clear();
            return;
        }
        Object var32_13 = null;
        this.getGenerationProblems().clear();
    }

    private IConsole getConsole() {
        if (this.console == null) {
            this.console = CCorePlugin.getDefault().getConsole();
            this.console.start(this.getProject());
        }
        return this.console;
    }

    private void removeAllMarkers(IProject project) {
        IMarker[] markers;
        if (project == null || !project.isAccessible()) {
            return;
        }
        IWorkspace workspace = project.getWorkspace();
        try {
            markers = project.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        }
        catch (CoreException coreException) {
            return;
        }
        if (markers != null) {
            try {
                workspace.deleteMarkers(markers);
            }
            catch (CoreException coreException) {
                return;
            }
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private String buildGoalName;
        private IManagedBuildInfo buildInfo;
        private boolean buildNeeded = true;
        private List reservedNames;

        public ResourceDeltaVisitor(IManagedBuildInfo info) {
            this.buildInfo = info;
            String ext = this.buildInfo.getBuildArtifactExtension();
            this.buildGoalName = ext.length() > 0 ? String.valueOf(this.buildInfo.getOutputPrefix(ext)) + this.buildInfo.getBuildArtifactName() + "." + ext : this.buildInfo.getBuildArtifactName();
            this.reservedNames = Arrays.asList(".cdtbuild", ".cdtproject", ".project");
        }

        private boolean isGeneratedResource(IResource resource) {
            IPath path = resource.getProjectRelativePath();
            String[] configNames = this.buildInfo.getConfigurationNames();
            int i = 0;
            while (i < configNames.length) {
                String name = configNames[i];
                Path root = new Path(name);
                if (root.isPrefixOf(path)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isProjectFile(IResource resource) {
            return this.reservedNames.contains(resource.getName());
        }

        public boolean shouldBuild() {
            return this.buildNeeded;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource != null && resource.getProject() == GeneratedMakefileBuilder.this.getProject()) {
                IResourceDelta[] kids = delta.getAffectedChildren();
                int index = kids.length - 1;
                while (index >= 0) {
                    IResource changedResource = kids[index].getResource();
                    if (changedResource instanceof IFolder) {
                        return true;
                    }
                    String name = changedResource.getName();
                    String ext = changedResource.getFileExtension();
                    if (name.equals(this.buildGoalName)) {
                        this.buildNeeded = true;
                        break;
                    }
                    if (resource.isDerived()) {
                        this.buildNeeded |= false;
                    } else if (this.isGeneratedResource(changedResource)) {
                        this.buildNeeded |= false;
                    } else {
                        if (this.buildInfo.buildsFileType(ext) || this.buildInfo.isHeaderFile(ext)) {
                            this.buildNeeded = true;
                            break;
                        }
                        this.buildNeeded = this.isProjectFile(changedResource) ? (this.buildNeeded |= false) : true;
                    }
                    --index;
                }
                return false;
            }
            return true;
        }
    }
}

