/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class VariableFormatActionDelegate
implements IObjectActionDelegate {
    private int fFormat = 0;
    private ICVariable[] fVariables = null;

    public VariableFormatActionDelegate(int format) {
        this.fFormat = format;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        ICVariable[] vars = this.getVariables();
        if (vars != null && vars.length > 0) {
            final MultiStatus ms = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, "", null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        VariableFormatActionDelegate.this.doAction(VariableFormatActionDelegate.this.getVariables());
                    }
                    catch (DebugException e) {
                        ms.merge(e.getStatus());
                    }
                }
            });
            if (!ms.isOK()) {
                IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null) {
                    CDebugUIPlugin.errorDialog(ActionMessages.getString("VariableFormatActionDelegate.0"), (IStatus)ms);
                } else {
                    CDebugUIPlugin.log((IStatus)ms);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList list = new ArrayList();
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Iterator i = ssel.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof ICVariable)) continue;
                ICVariable var = (ICVariable)o;
                boolean enabled = var.isEditable();
                action.setEnabled(enabled);
                if (!enabled) continue;
                action.setChecked(var.getFormat() == this.fFormat);
                list.add(o);
            }
            this.setVariables(list.toArray(new ICVariable[list.size()]));
        } else {
            action.setChecked(false);
            action.setEnabled(false);
        }
    }

    protected void doAction(ICVariable[] vars) throws DebugException {
        int i = 0;
        while (i < vars.length) {
            vars[i].setFormat(this.fFormat);
            ++i;
        }
    }

    protected ICVariable[] getVariables() {
        return this.fVariables;
    }

    private void setVariables(ICVariable[] variables) {
        this.fVariables = variables;
    }
}

