/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.impl.Util;
import org.eclipse.cdt.internal.core.sourcedependency.Node;

public class IncludeEntry {
    protected char[] fFile;
    protected int fId;
    protected int fNumRefs;
    protected int[] fRefs;
    protected ArrayList fParent;
    protected ArrayList fChild;
    protected int fNumParent;
    protected int fNumChild;

    public IncludeEntry(int id) {
        this(CharOperation.NO_CHAR, id);
    }

    public IncludeEntry(char[] file, int id) {
        this.fFile = file;
        this.fNumRefs = 0;
        this.fRefs = new int[1];
        this.fId = id;
        this.fParent = new ArrayList(5);
        this.fChild = new ArrayList(5);
        this.fNumParent = 0;
        this.fNumChild = 0;
    }

    public int addRef(int fileNum) {
        if (this.fNumRefs > 0 && this.fRefs[this.fNumRefs - 1] == fileNum) {
            return 0;
        }
        if (this.fNumRefs < this.fRefs.length) {
            this.fRefs[this.fNumRefs++] = fileNum;
            return 0;
        }
        int newSize = this.fNumRefs < 4 ? 4 : this.fNumRefs * 2;
        this.fRefs = new int[newSize];
        System.arraycopy(this.fRefs, 0, this.fRefs, 0, this.fNumRefs);
        this.fRefs[this.fNumRefs++] = fileNum;
        return (newSize - this.fNumRefs + 1) * 4;
    }

    public void addParent(int fileRef, int parentId) {
        Node newParent = new Node(fileRef, parentId);
        this.fParent.add(newParent);
        ++this.fNumParent;
    }

    public void addRefs(int[] refs) {
        int[] newRefs = new int[this.fNumRefs + refs.length];
        int pos1 = 0;
        int pos2 = 0;
        int posNew = 0;
        int r1 = 0;
        int r2 = 0;
        while (pos1 < this.fNumRefs || pos2 < refs.length) {
            int compare;
            if (pos1 >= this.fNumRefs) {
                r2 = refs[pos2];
                compare = -1;
            } else if (pos2 >= refs.length) {
                compare = 1;
                r1 = this.fRefs[pos1];
            } else {
                r1 = this.fRefs[pos1];
                r2 = refs[pos2];
                compare = r2 - r1;
            }
            if (compare > 0) {
                newRefs[posNew] = r1;
                ++posNew;
                ++pos1;
                continue;
            }
            if (r2 != 0) {
                newRefs[posNew] = r2;
                ++posNew;
            }
            ++pos2;
        }
        this.fRefs = newRefs;
        this.fNumRefs = posNew;
    }

    public void addChild(int fileRef, int parentId) {
        Node newChild = new Node(fileRef, parentId);
        this.fChild.add(newChild);
        ++this.fNumChild;
    }

    public int getNumRefs() {
        return this.fNumRefs;
    }

    public int getRef(int i) {
        if (i < this.fNumRefs) {
            return this.fRefs[i];
        }
        throw new IndexOutOfBoundsException();
    }

    public int[] getRefs() {
        int[] result = new int[this.fNumRefs];
        System.arraycopy(this.fRefs, 0, result, 0, this.fNumRefs);
        return result;
    }

    public char[] getFile() {
        return this.fFile;
    }

    public void mapRefs(int[] mappings) {
        int position = 0;
        int i = 0;
        while (i < this.fNumRefs) {
            int map = -1;
            if (this.fRefs[i] >= 0 && this.fRefs[i] < mappings.length) {
                map = mappings[this.fRefs[i]];
            }
            if (map != -1 && map != 0) {
                this.fRefs[position++] = map;
            }
            ++i;
        }
        this.fNumRefs = position;
        this.fRefs = new int[this.fNumRefs];
        System.arraycopy(this.fRefs, 0, this.fRefs, 0, this.fNumRefs);
        Util.sort(this.fRefs);
    }

    public void reset(char[] word) {
        int i = this.fNumRefs;
        while (i-- > 0) {
            this.fRefs[i] = 0;
        }
        this.fNumRefs = 0;
        this.fFile = word;
    }

    public int getID() {
        return this.fId;
    }

    public String toString() {
        StringBuffer tempBuffer = new StringBuffer();
        tempBuffer.append("<Name: ");
        tempBuffer.append(this.fFile);
        tempBuffer.append(", Id: ");
        tempBuffer.append(this.fId);
        tempBuffer.append(", Refs:{");
        int i = 0;
        while (i < this.fRefs.length) {
            if (i > 0) {
                tempBuffer.append(',');
            }
            tempBuffer.append(' ');
            tempBuffer.append(this.fRefs[i]);
            ++i;
        }
        tempBuffer.append("}, Parents:{");
        Iterator x = this.fParent.iterator();
        while (x.hasNext()) {
            Node tempNode = (Node)x.next();
            tempBuffer.append(tempNode.toString());
            if (!x.hasNext()) continue;
            tempBuffer.append(',');
            tempBuffer.append(' ');
        }
        tempBuffer.append("}, Children:{");
        Iterator y = this.fChild.iterator();
        while (y.hasNext()) {
            Node tempNode = (Node)y.next();
            tempBuffer.append(tempNode.toString());
            if (!y.hasNext()) continue;
            tempBuffer.append(',');
            tempBuffer.append(' ');
        }
        tempBuffer.append("} >");
        return tempBuffer.toString();
    }
}

