/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Enumeration;
import java.util.Map;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.IBufferChangedListener;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class Openable
extends Parent
implements IOpenable,
IBufferChangedListener {
    protected IResource resource;

    public Openable(ICElement parent, IPath path, int type) {
        this(parent, (IResource)ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path), path.lastSegment(), type);
    }

    public Openable(ICElement parent, IResource resource, int type) {
        this(parent, resource, resource.getName(), type);
    }

    public Openable(ICElement parent, IResource res, String name, int type) {
        super(parent, name, type);
        this.resource = res;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void bufferChanged(BufferChangedEvent event) {
        if (event.getBuffer().isClosed()) {
            CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(event.getBuffer());
        } else {
            CModelManager.getDefault().getElementsOutOfSynchWithBuffers().put(this, this);
        }
    }

    protected abstract boolean buildStructure(OpenableInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws CModelException;

    protected void closeBuffer() {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer buffer = null;
        buffer = this.getBufferManager().getBuffer(this);
        if (buffer != null) {
            buffer.close();
            buffer.removeBufferChangedListener(this);
        }
    }

    protected void closing(Object info) throws CModelException {
        this.closeBuffer();
    }

    public IBuffer getBuffer() throws CModelException {
        if (this.hasBuffer()) {
            IBuffer buffer;
            if (!this.isOpen()) {
                this.getElementInfo();
            }
            if ((buffer = this.getBufferManager().getBuffer(this)) == null) {
                buffer = this.openBuffer(null);
            }
            return buffer;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.getBufferManager().getDefaultBufferFactory();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean hasUnsavedChanges() throws CModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer buf = this.getBuffer();
        if (buf != null && buf.hasUnsavedChanges()) {
            return true;
        }
        if (this.fType == 10 || this.fType == 11) {
            Enumeration openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                ICElement owner;
                IBuffer buffer = (IBuffer)openBuffers.nextElement();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf(owner = (ICElement)((Object)buffer.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() throws CModelException {
        return true;
    }

    public boolean isOpen() {
        return CModelManager.getDefault().getInfo(this) != null;
    }

    protected boolean isSourceElement() {
        return false;
    }

    public void makeConsistent(IProgressMonitor pm) throws CModelException {
        this.makeConsistent(pm, false);
    }

    /*
     * Exception decompiling
     */
    public void makeConsistent(IProgressMonitor monitor, boolean forced) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 140->144)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void open(IProgressMonitor pm) throws CModelException {
        this.getElementInfo(pm);
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        return null;
    }

    protected void openParent(Object childInfo, Map newElements, IProgressMonitor pm) throws CModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    protected void generateInfos(Object info, Map newElements, IProgressMonitor monitor) throws CModelException {
        if (CModelManager.VERBOSE) {
            System.out.println("OPENING Element (" + Thread.currentThread() + "): " + this);
        }
        this.openParent(info, newElements, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        newElements.put(this, info);
        try {
            OpenableInfo openableInfo = (OpenableInfo)info;
            boolean isStructureKnown = this.buildStructure(openableInfo, monitor, newElements, this.getResource());
            openableInfo.setIsStructureKnown(isStructureKnown);
        }
        catch (CModelException e) {
            newElements.remove(this);
            throw e;
        }
        CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this);
    }

    public void save(IProgressMonitor pm, boolean force) throws CModelException {
        if (this.isReadOnly() || this.getResource().isReadOnly()) {
            throw new CModelException(new CModelStatus(976, this));
        }
        IBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
        }
    }

    public SourceRoot getSourceRoot() {
        ICElement current = this;
        do {
            if (!(current instanceof SourceRoot)) continue;
            return (SourceRoot)current;
        } while ((current = current.getParent()) != null);
        return null;
    }
}

