/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.elf.AR;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.ElfHelper;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryObject;
import org.eclipse.core.runtime.IPath;

public class ARMember
extends ElfBinaryObject {
    AR.ARHeader header;

    public ARMember(IBinaryParser parser, IPath p, AR.ARHeader h) throws IOException {
        super(parser, p);
        this.header = h;
    }

    public InputStream getContents() {
        InputStream stream = null;
        if (this.path != null && this.header != null) {
            try {
                stream = new ByteArrayInputStream(this.header.getObjectData());
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return "";
    }

    protected ElfHelper getElfHelper() throws IOException {
        if (this.header != null) {
            return new ElfHelper(this.header.getElf());
        }
        throw new IOException(CCorePlugin.getResourceString("Util.exception.noFileAssociation"));
    }

    protected void addSymbols(Elf.Symbol[] array, int type, Addr2line addr2line, CPPFilt cppfilt, List list) {
        int i = 0;
        while (i < array.length) {
            Symbol sym = new Symbol(this);
            sym.type = type;
            sym.name = array[i].toString();
            sym.addr = array[i].st_value;
            list.add(sym);
            ++i;
        }
    }
}

