/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTConstructorMemberInitializer;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.DeclarationWrapper;
import org.eclipse.cdt.internal.core.parser.IDeclarator;
import org.eclipse.cdt.internal.core.parser.IDeclaratorOwner;
import org.eclipse.cdt.internal.core.parser.IParameterCollection;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;

public class Declarator
implements IParameterCollection,
IDeclaratorOwner,
IDeclarator {
    private static final int DEFAULT_ARRAYLIST_SIZE = 4;
    private static final String EMPTY_STRING = "";
    private final IDeclaratorOwner owner;
    private ITokenDuple pointerOperatorNameDuple = null;
    private ITokenDuple namedDuple = null;
    private IASTExpression constructorExpression = null;
    private Declarator ownedDeclarator = null;
    private IASTInitializerClause initializerClause = null;
    private IASTExceptionSpecification exceptionSpecification = null;
    private IASTExpression bitFieldExpression = null;
    private int flag = 0;
    protected static final int IS_FUNCTION = 32;
    protected static final int HAS_TRY_BLOCK = 64;
    protected static final int HAS_FUNCTION_BODY = 128;
    protected static final int IS_PURE_VIRTUAL = 256;
    protected static final int IS_VAR_ARGS = 512;
    protected static final int IS_VOLATILE = 1024;
    protected static final int IS_CONST = 2048;
    private List ptrOps = Collections.EMPTY_LIST;
    private List parameters = Collections.EMPTY_LIST;
    private List arrayModifiers = Collections.EMPTY_LIST;
    private List constructorMemberInitializers = Collections.EMPTY_LIST;

    protected void setBit(boolean b, int mask) {
        this.flag = b ? (this.flag |= mask) : (this.flag &= ~mask);
    }

    protected boolean checkBit(int mask) {
        return (this.flag & mask) != 0;
    }

    public Declarator(IDeclaratorOwner owner) {
        this.owner = owner;
    }

    public String getName() {
        if (this.namedDuple == null) {
            return EMPTY_STRING;
        }
        return this.namedDuple.toString();
    }

    public int getNameEndOffset() {
        if (this.namedDuple == null) {
            return -1;
        }
        return this.namedDuple.getEndOffset();
    }

    public int getNameLine() {
        if (this.namedDuple == null) {
            return -1;
        }
        return this.namedDuple.getLineNumber();
    }

    public int getNameStartOffset() {
        if (this.namedDuple == null) {
            return -1;
        }
        return this.namedDuple.getStartOffset();
    }

    public IDeclaratorOwner getOwner() {
        return this.owner;
    }

    public List getPointerOperators() {
        return this.ptrOps;
    }

    public void addPointerOperator(ASTPointerOperator ptrOp) {
        if (this.ptrOps == Collections.EMPTY_LIST) {
            this.ptrOps = new ArrayList(4);
        }
        this.ptrOps.add(ptrOp);
    }

    public List getParameters() {
        return this.parameters;
    }

    public void addParameter(DeclarationWrapper param) {
        if (this.parameters == Collections.EMPTY_LIST) {
            this.parameters = new ArrayList(4);
        }
        this.parameters.add(param);
    }

    public IASTInitializerClause getInitializerClause() {
        return this.initializerClause;
    }

    public void setInitializerClause(IASTInitializerClause expression) {
        this.initializerClause = expression;
    }

    public Declarator getOwnedDeclarator() {
        return this.ownedDeclarator;
    }

    public void setOwnedDeclarator(Declarator declarator) {
        this.ownedDeclarator = declarator;
    }

    public void setName(ITokenDuple duple) {
        this.namedDuple = duple;
    }

    public IASTExceptionSpecification getExceptionSpecification() {
        return this.exceptionSpecification;
    }

    public boolean isConst() {
        return this.checkBit(2048);
    }

    public boolean isVolatile() {
        return this.checkBit(1024);
    }

    public void setExceptionSpecification(IASTExceptionSpecification specification) {
        this.exceptionSpecification = specification;
    }

    public void setConst(boolean b) {
        this.setBit(b, 2048);
    }

    public void setVolatile(boolean b) {
        this.setBit(b, 1024);
    }

    public void setPureVirtual(boolean b) {
        this.setBit(b, 256);
    }

    public boolean isPureVirtual() {
        return this.checkBit(256);
    }

    public void addArrayModifier(IASTArrayModifier arrayMod) {
        if (this.arrayModifiers == Collections.EMPTY_LIST) {
            this.arrayModifiers = new ArrayList(4);
        }
        this.arrayModifiers.add(arrayMod);
    }

    public List getArrayModifiers() {
        return this.arrayModifiers;
    }

    public IASTExpression getBitFieldExpression() {
        return this.bitFieldExpression;
    }

    public void setBitFieldExpression(IASTExpression expression) {
        this.bitFieldExpression = expression;
    }

    public void setConstructorExpression(IASTExpression astExpression) {
        this.constructorExpression = astExpression;
    }

    public IASTExpression getConstructorExpression() {
        return this.constructorExpression;
    }

    public void addConstructorMemberInitializer(IASTConstructorMemberInitializer initializer) {
        if (this.constructorMemberInitializers == Collections.EMPTY_LIST) {
            this.constructorMemberInitializers = new ArrayList(4);
        }
        this.constructorMemberInitializers.add(initializer);
    }

    public List getConstructorMemberInitializers() {
        return this.constructorMemberInitializers;
    }

    public boolean isFunction() {
        return this.checkBit(32);
    }

    public void setIsFunction(boolean b) {
        this.setBit(b, 32);
    }

    public Iterator getDeclarators() {
        if (this.ownedDeclarator == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        ArrayList<Declarator> l = new ArrayList<Declarator>(1);
        l.add(this.ownedDeclarator);
        return l.iterator();
    }

    public DeclarationWrapper getDeclarationWrapper() {
        Declarator d = this;
        while (d.getOwner() instanceof Declarator) {
            d = (Declarator)d.getOwner();
        }
        return (DeclarationWrapper)d.getOwner();
    }

    public ITokenDuple getNameDuple() {
        return this.namedDuple;
    }

    public void setPointerOperatorName(ITokenDuple nameDuple) {
        this.pointerOperatorNameDuple = nameDuple;
    }

    public ITokenDuple getPointerOperatorNameDuple() {
        return this.pointerOperatorNameDuple;
    }

    public boolean hasFunctionBody() {
        return this.checkBit(128);
    }

    public void setHasFunctionBody(boolean b) {
        this.setBit(b, 128);
    }

    public void setFunctionTryBlock(boolean b) {
        this.setBit(b, 64);
    }

    public boolean hasFunctionTryBlock() {
        return this.checkBit(64);
    }

    public void setIsVarArgs(boolean b) {
        this.setBit(b, 512);
    }

    public boolean isVarArgs() {
        return this.checkBit(512);
    }

    public IASTScope getScope() {
        return this.getDeclarationWrapper().getScope();
    }
}

