/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.SelectionUtil;
import org.eclipse.cdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.cdt.ui.wizards.ICPathContainerPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectContainerPage
extends WizardPage
implements ICPathContainerPage {
    private int[] fFilterType;
    private TableViewer viewer;
    private ICProject fCProject;

    protected ProjectContainerPage(int[] filterType) {
        super("projectContainerPage");
        this.setTitle(CPathEntryMessages.getString("ProjectContainerPage.title"));
        this.setDescription(CPathEntryMessages.getString("ProjectContainerPage.description"));
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fFilterType = filterType;
        this.validatePage();
    }

    public void initialize(ICProject project, IPathEntry[] currentEntries) {
        this.fCProject = project;
    }

    public boolean finish() {
        return true;
    }

    public IPathEntry[] getContainerEntries() {
        ISelection selection;
        ICProject project;
        if (this.viewer != null && (project = (ICProject)SelectionUtil.getSingleElement(selection = this.viewer.getSelection())) != null) {
            return new IPathEntry[]{CoreModel.newProjectEntry((IPath)project.getPath())};
        }
        return new IPathEntry[0];
    }

    public void setSelection(IPathEntry containerEntry) {
        if (containerEntry != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)containerEntry));
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(CPathEntryMessages.getString("ProjectContainerPage.label"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(container, 2820);
        this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectContainerPage.this.validatePage();
            }
        });
        gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !element.equals(ProjectContainerPage.this.fCProject);
            }
        });
        this.setControl((Control)container);
        this.initializeView();
        this.validatePage();
    }

    private void initializeView() {
        ArrayList<ICProject> list = new ArrayList<ICProject>();
        try {
            List<IPathEntry> current = Arrays.asList(this.fCProject.getRawPathEntries());
            ICProject[] cProjects = CoreModel.getDefault().getCModel().getCProjects();
            int i = 0;
            while (i < cProjects.length) {
                boolean added = false;
                if (!cProjects[i].equals(this.fCProject) && !current.contains(CoreModel.newProjectEntry((IPath)cProjects[i].getPath()))) {
                    IPathEntry[] projEntries = cProjects[i].getRawPathEntries();
                    int j = 0;
                    while (j < projEntries.length) {
                        int k = 0;
                        while (k < this.fFilterType.length) {
                            if (projEntries[j].getEntryKind() == this.fFilterType[k] && projEntries[j].isExported()) {
                                list.add(cProjects[i]);
                                added = true;
                                break;
                            }
                            ++k;
                        }
                        if (added) break;
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        this.viewer.setInput(list);
    }

    private void validatePage() {
        this.setPageComplete(this.getSelected() != null);
    }

    private IPathEntry getSelected() {
        return this.getContainerEntries().length > 0 ? this.getContainerEntries()[0] : null;
    }
}

