/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.browser.typeinfo;

import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TypeInfoLabelProvider
extends LabelProvider {
    public static final int SHOW_TYPE_ONLY = 1;
    public static final int SHOW_ENCLOSING_TYPE_ONLY = 2;
    public static final int SHOW_FULLY_QUALIFIED = 4;
    public static final int SHOW_PATH = 8;
    private static final Image HEADER_ICON = CPluginImages.get("org.eclipse.cdt.ui.h_file_obj.gif");
    private static final Image SOURCE_ICON = CPluginImages.get("org.eclipse.cdt.ui.c_file_obj.gif");
    private static final Image NAMESPACE_ICON = CPluginImages.get("org.eclipse.cdt.ui.namespace_obj.gif");
    private static final Image TEMPLATE_ICON = CPluginImages.get("org.eclipse.cdt.ui.template_obj.gif");
    private static final Image CLASS_ICON = CPluginImages.get("org.eclipse.cdt.ui.class_obj.gif");
    private static final Image STRUCT_ICON = CPluginImages.get("org.eclipse.cdt.ui.struct_obj.gif");
    private static final Image TYPEDEF_ICON = CPluginImages.get("org.eclipse.cdt.ui.typedef_obj.gif");
    private static final Image UNION_ICON = CPluginImages.get("org.eclipse.cdt.ui.union_obj.gif");
    private static final Image ENUM_ICON = CPluginImages.get("org.eclipse.cdt.ui.enum_obj.gif");
    private static final Image UNKNOWN_TYPE_ICON = CPluginImages.get("org.eclipse.cdt.ui.unknown_type_obj.gif");
    private int fFlags;

    public TypeInfoLabelProvider(int flags) {
        this.fFlags = flags;
    }

    private boolean isSet(int flag) {
        return (this.fFlags & flag) != 0;
    }

    public String getText(Object element) {
        if (!(element instanceof ITypeInfo)) {
            return super.getText(element);
        }
        ITypeInfo typeRef = (ITypeInfo)element;
        IQualifiedTypeName qualifiedName = typeRef.getQualifiedTypeName();
        StringBuffer buf = new StringBuffer();
        if (this.isSet(1)) {
            String name = typeRef.getName();
            if (name != null && name.length() > 0) {
                buf.append(name);
            }
        } else if (this.isSet(2)) {
            IQualifiedTypeName parentName = qualifiedName.getEnclosingTypeName();
            if (parentName != null) {
                buf.append(parentName.getFullyQualifiedName());
            } else {
                buf.append(TypeInfoMessages.getString("TypeInfoLabelProvider.globalScope"));
            }
        } else if (this.isSet(4)) {
            buf.append(qualifiedName.getFullyQualifiedName());
        }
        if (this.isSet(8)) {
            IPath path = null;
            ITypeReference ref = typeRef.getResolvedReference();
            if (ref != null) {
                path = ref.getPath();
            } else {
                IProject project = typeRef.getEnclosingProject();
                if (project != null) {
                    path = project.getFullPath();
                }
            }
            if (path != null) {
                buf.append(TypeInfoMessages.getString("TypeInfoLabelProvider.dash"));
                buf.append(path.toString());
            }
        }
        return buf.toString();
    }

    public Image getImage(Object element) {
        if (!(element instanceof ITypeInfo)) {
            return super.getImage(element);
        }
        ITypeInfo typeRef = (ITypeInfo)element;
        if (this.isSet(2)) {
            ITypeInfo parentInfo = typeRef.getEnclosingType();
            if (parentInfo != null) {
                return TypeInfoLabelProvider.getTypeIcon(parentInfo.getCElementType());
            }
            IPath path = null;
            ITypeReference ref = typeRef.getResolvedReference();
            if (ref != null) {
                path = ref.getPath();
                if (CoreModel.isValidHeaderUnitName((IProject)typeRef.getEnclosingProject(), (String)path.lastSegment())) {
                    return HEADER_ICON;
                }
            }
            return SOURCE_ICON;
        }
        return TypeInfoLabelProvider.getTypeIcon(typeRef.getCElementType());
    }

    public static Image getTypeIcon(int type) {
        switch (type) {
            case 61: {
                return NAMESPACE_ICON;
            }
            case 73: {
                return TEMPLATE_ICON;
            }
            case 64: {
                return CLASS_ICON;
            }
            case 65: {
                return STRUCT_ICON;
            }
            case 66: {
                return UNION_ICON;
            }
            case 63: {
                return ENUM_ICON;
            }
            case 78: {
                return TYPEDEF_ICON;
            }
        }
        return UNKNOWN_TYPE_ICON;
    }
}

