/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IndexerOptionDialogPage
extends DialogPage {
    private static final String ENABLE_PREPROCESSOR_PROBLEMS = CUIMessages.getString("IndexerOptions.enablePreprocessor");
    private static final String ENABLE_SEMANTIC_PROBLEMS = CUIMessages.getString("IndexerOptions.enableSemantic");
    private static final String ENABLE_SYNTACTIC_PROBLEMS = CUIMessages.getString("IndexerOptions.enableSyntactic");
    private static final String ENABLE_INDEXING = CUIMessages.getString("IndexerOptions.enableIndexing");
    private static final String INDEXER = CUIMessages.getString("IndexerOptions.indexer");
    private static final String INDEXER_PROBLEMS = CUIMessages.getString("IndexerOptions.problemReporting");
    private Button indexerEnabled;
    private Button preprocessorProblemsEnabled;
    private Button syntacticProblemsEnabled;
    private Button semanticProblemsEnabled;

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        Group group = new Group(result, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(INDEXER);
        this.indexerEnabled = this.createCheckButton((Composite)group, ENABLE_INDEXING);
        Group problemsGroup = new Group(result, 0);
        problemsGroup.setLayout((Layout)new GridLayout());
        problemsGroup.setLayoutData((Object)new GridData(768));
        problemsGroup.setText(INDEXER_PROBLEMS);
        this.preprocessorProblemsEnabled = this.createCheckButton((Composite)problemsGroup, ENABLE_PREPROCESSOR_PROBLEMS);
        this.semanticProblemsEnabled = this.createCheckButton((Composite)problemsGroup, ENABLE_SEMANTIC_PROBLEMS);
        this.syntacticProblemsEnabled = this.createCheckButton((Composite)problemsGroup, ENABLE_SYNTACTIC_PROBLEMS);
        this.setControl((Control)result);
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    public void setIndexerValue(boolean value) {
        this.indexerEnabled.setSelection(value);
    }

    public void setIndexerProblemValues(int value) {
        this.preprocessorProblemsEnabled.setSelection((value & 1) != 0);
        if (this.syntacticProblemsEnabled != null) {
            this.syntacticProblemsEnabled.setSelection((value & 4) != 0);
        }
        this.semanticProblemsEnabled.setSelection((value & 2) != 0);
    }

    public boolean getIndexerValue() {
        return this.indexerEnabled.getSelection();
    }

    public int getIndexerProblemsValues() {
        int result = 0;
        result |= this.preprocessorProblemsEnabled.getSelection() ? 1 : 0;
        if (this.syntacticProblemsEnabled != null) {
            result |= this.syntacticProblemsEnabled.getSelection() ? 4 : 0;
        }
        return result |= this.semanticProblemsEnabled.getSelection() ? 2 : 0;
    }

    public void persistIndexerValues(IProject project) {
        ICDescriptor descriptor = null;
        Element rootElement = null;
        IProject newProject = null;
        try {
            newProject = project;
            descriptor = CCorePlugin.getDefault().getCProjectDescription(newProject, true);
            rootElement = descriptor.getProjectData("cdt_indexer");
            Node child = rootElement.getFirstChild();
            while (child != null) {
                rootElement.removeChild(child);
                child = rootElement.getFirstChild();
            }
            Document doc = rootElement.getOwnerDocument();
            boolean indexProject = this.getIndexerValue();
            int problemValues = this.getIndexerProblemsValues();
            IndexerOptionDialogPage.saveIndexerEnabled(indexProject, rootElement, doc);
            IndexerOptionDialogPage.saveIndexerProblemsEnabled(problemValues, rootElement, doc);
            descriptor.saveProjectData();
            project.setSessionProperty(IndexManager.activationKey, (Object)new Boolean(indexProject));
            project.setSessionProperty(IndexManager.problemsActivationKey, (Object)new Integer(problemValues));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static void saveIndexerEnabled(boolean indexerEnabled, Element rootElement, Document doc) {
        Element indexEnabled = doc.createElement("indexEnabled");
        Boolean tempValue = new Boolean(indexerEnabled);
        indexEnabled.setAttribute("indexValue", tempValue.toString());
        rootElement.appendChild(indexEnabled);
    }

    private static void saveIndexerProblemsEnabled(int problemValues, Element rootElement, Document doc) {
        Element enabled = doc.createElement("indexerProblemsEnabled");
        Integer tempValue = new Integer(problemValues);
        enabled.setAttribute("indexProblemsValue", tempValue.toString());
        rootElement.appendChild(enabled);
    }
}

