/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ErrorParserBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedProjectOptionBlock;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public class ManagedBuilderPropertyPage
extends PropertyPage
implements ICOptionContainer {
    protected ManagedProjectOptionBlock fOptionBlock;
    protected ITarget displayedTarget;
    private static final String MSG_CLOSEDPROJECT = "MngMakeProjectPropertyPage.closedproject";

    public void setContainer(IPreferencePageContainer preferencePageContainer) {
        super.setContainer(preferencePageContainer);
        if (this.fOptionBlock == null) {
            this.fOptionBlock = new ManagedProjectOptionBlock(this);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        IProject project = this.getProject();
        if (!project.isOpen()) {
            this.contentForClosedProject(composite);
        } else {
            this.contentForCProject(composite);
        }
        return composite;
    }

    private void contentForCProject(Composite parent) {
        this.fOptionBlock.createContents(parent);
    }

    private void contentForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(ManagedBuilderUIMessages.getResourceString(MSG_CLOSEDPROJECT));
        label.setFont(parent.getFont());
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ManagedBuilderPropertyPage.this.fOptionBlock.performApply(monitor);
            }
        };
        ITarget target = this.getSelectedTarget();
        if (target != this.displayedTarget) {
            return true;
        }
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            ManagedBuilderUIPlugin.errorDialog(this.getShell(), ManagedBuilderUIMessages.getResourceString("ManagedProjectPropertyPage.internalError"), e1.toString(), e1);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        IProject project = this.getProject();
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)false);
        return true;
    }

    public IProject getProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fOptionBlock.setVisible(visible);
        if (visible) {
            ErrorParserBlock errorParsers = this.fOptionBlock.getErrorParserBlock();
            errorParsers.updateValues();
            this.displayedTarget = this.getSelectedTarget();
        }
    }

    protected ITarget getSelectedTarget() {
        IProject project = this.getProject();
        ITarget target = ManagedBuildManager.getSelectedTarget((IProject)project);
        if (target == null) {
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            target = info.getDefaultTarget();
            ManagedBuildManager.setSelectedTarget((IProject)project, (ITarget)target);
        }
        return target;
    }

    public void updateContainer() {
        this.fOptionBlock.update();
        this.setValid(this.fOptionBlock.isValid());
        this.setErrorMessage(this.fOptionBlock.getErrorMessage());
    }

    protected void performDefaults() {
        this.fOptionBlock.performDefaults();
        super.performDefaults();
    }

    public boolean isValid() {
        this.updateContainer();
        return super.isValid();
    }

    public Preferences getPreferences() {
        return null;
    }
}

