/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.extension.IScannerExtension;
import org.eclipse.cdt.internal.core.parser.ast.ASTCompletionNode;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.problem.IProblemFactory;
import org.eclipse.cdt.internal.core.parser.scanner.BranchTracker;
import org.eclipse.cdt.internal.core.parser.scanner.ContextStack;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerData;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerProblemFactory;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerUtility;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayIntMap;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayObjectMap;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner2.ExpressionEvaluator;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.MacroExpansionToken;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.parser.token.ImagedExpansionToken;
import org.eclipse.cdt.internal.core.parser.token.ImagedToken;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.core.parser.token.SimpleToken;

public class Scanner2
implements IScanner,
IScannerData {
    private ISourceElementRequestor requestor;
    private ParserLanguage language;
    protected IParserLogService log;
    private IScannerExtension scannerExtension;
    private CharArrayObjectMap definitions = new CharArrayObjectMap(512);
    private String[] includePaths;
    int count;
    private ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
    private final Map fileCache = new HashMap(100);
    private static final int bufferInitialSize = 8;
    private int bufferStackPos = -1;
    private char[][] bufferStack = new char[8][];
    private Object[] bufferData = new Object[8];
    private int[] bufferPos = new int[8];
    private int[] bufferLimit = new int[8];
    private int[] lineNumbers = new int[8];
    private int[] lineOffsets = new int[8];
    private Object[] callbackStack = new Object[8];
    private int callbackPos = -1;
    private int branchStackPos = -1;
    private int[] branches = new int[8];
    private static final int BRANCH_IF = 1;
    private static final int BRANCH_ELIF = 2;
    private static final int BRANCH_ELSE = 3;
    private static final int BRANCH_END = 4;
    private static String[] emptyStringArray = new String[0];
    private static char[] emptyCharArray = new char[0];
    private static EndOfFileException EOF = new EndOfFileException();
    PrintStream dlog;
    private ParserMode parserMode;
    private List workingCopies;
    private IToken lastToken;
    private IToken nextToken;
    private boolean finished = false;
    private static final String EMPTY_STRING = "";
    private static final char[] EMPTY_STRING_CHAR_ARRAY = new char[0];
    private static final ScannerProblemFactory spf = new ScannerProblemFactory();
    private static final ObjectStyleMacro __cplusplus = new ObjectStyleMacro("__cplusplus".toCharArray(), "1".toCharArray());
    private static final ObjectStyleMacro __STDC__ = new ObjectStyleMacro("__STDC__".toCharArray(), "1".toCharArray());
    private static final ObjectStyleMacro __inline__ = new ObjectStyleMacro("__inline__".toCharArray(), "inline".toCharArray());
    private static final ObjectStyleMacro __extension__ = new ObjectStyleMacro("__extension__".toCharArray(), emptyCharArray);
    private static final ObjectStyleMacro __asm__ = new ObjectStyleMacro("__asm__".toCharArray(), "asm".toCharArray());
    private static final ObjectStyleMacro __restrict__ = new ObjectStyleMacro("__restrict__".toCharArray(), "restrict".toCharArray());
    private static final ObjectStyleMacro __restrict = new ObjectStyleMacro("__restrict".toCharArray(), "restrict".toCharArray());
    private static final ObjectStyleMacro __volatile__ = new ObjectStyleMacro("__volatile__".toCharArray(), "volatile".toCharArray());
    private static final ObjectStyleMacro __const__ = new ObjectStyleMacro("__const__".toCharArray(), "const".toCharArray());
    private static final ObjectStyleMacro __const = new ObjectStyleMacro("__const".toCharArray(), "const".toCharArray());
    private static final ObjectStyleMacro __signed__ = new ObjectStyleMacro("__signed__".toCharArray(), "signed".toCharArray());
    private static final ObjectStyleMacro __cdecl = new ObjectStyleMacro("__cdecl".toCharArray(), emptyCharArray);
    private static final FunctionStyleMacro __attribute__ = new FunctionStyleMacro("__attribute__".toCharArray(), emptyCharArray, new char[][]{"arg".toCharArray()});
    private static final FunctionStyleMacro __declspec = new FunctionStyleMacro("__declspec".toCharArray(), emptyCharArray, new char[][]{"arg".toCharArray()});
    private static final FunctionStyleMacro _Pragma = new FunctionStyleMacro("_Pragma".toCharArray(), emptyCharArray, new char[][]{"arg".toCharArray()});
    private IASTFactory astFactory;
    private int offsetBoundary = -1;
    private static CharArrayIntMap keywords;
    private static CharArrayIntMap ppKeywords;
    private static final int ppIf = 0;
    private static final int ppIfdef = 1;
    private static final int ppIfndef = 2;
    private static final int ppElif = 3;
    private static final int ppElse = 4;
    private static final int ppEndif = 5;
    private static final int ppInclude = 6;
    private static final int ppDefine = 7;
    private static final int ppUndef = 8;
    private static final int ppError = 9;
    private static final int ppInclude_next = 10;
    private static final char[] TAB;
    private static final char[] SPACE;

    static {
        TAB = new char[]{'\t'};
        SPACE = new char[]{' '};
        keywords = new CharArrayIntMap(139, -1);
        keywords.put("auto".toCharArray(), 57);
        keywords.put("break".toCharArray(), 61);
        keywords.put("case".toCharArray(), 62);
        keywords.put("char".toCharArray(), 64);
        keywords.put("const".toCharArray(), 67);
        keywords.put("continue".toCharArray(), 70);
        keywords.put("default".toCharArray(), 71);
        keywords.put("do".toCharArray(), 73);
        keywords.put("double".toCharArray(), 74);
        keywords.put("else".toCharArray(), 76);
        keywords.put("enum".toCharArray(), 77);
        keywords.put("extern".toCharArray(), 80);
        keywords.put("float".toCharArray(), 82);
        keywords.put("for".toCharArray(), 83);
        keywords.put("goto".toCharArray(), 85);
        keywords.put("if".toCharArray(), 86);
        keywords.put("inline".toCharArray(), 87);
        keywords.put("int".toCharArray(), 88);
        keywords.put("long".toCharArray(), 89);
        keywords.put("register".toCharArray(), 101);
        keywords.put("return".toCharArray(), 103);
        keywords.put("short".toCharArray(), 104);
        keywords.put("signed".toCharArray(), 108);
        keywords.put("sizeof".toCharArray(), 105);
        keywords.put("static".toCharArray(), 106);
        keywords.put("struct".toCharArray(), 109);
        keywords.put("switch".toCharArray(), 110);
        keywords.put("typedef".toCharArray(), 116);
        keywords.put("union".toCharArray(), 119);
        keywords.put("unsigned".toCharArray(), 120);
        keywords.put("void".toCharArray(), 123);
        keywords.put("volatile".toCharArray(), 124);
        keywords.put("while".toCharArray(), 126);
        keywords.put("restrict".toCharArray(), 137);
        keywords.put("_Bool".toCharArray(), 134);
        keywords.put("_Complex".toCharArray(), 135);
        keywords.put("_Imaginary".toCharArray(), 136);
        keywords.put("asm".toCharArray(), 56);
        keywords.put("bool".toCharArray(), 60);
        keywords.put("catch".toCharArray(), 63);
        keywords.put("class".toCharArray(), 65);
        keywords.put("const_cast".toCharArray(), 69);
        keywords.put("delete".toCharArray(), 72);
        keywords.put("dynamic_cast".toCharArray(), 75);
        keywords.put("explicit".toCharArray(), 78);
        keywords.put("export".toCharArray(), 79);
        keywords.put("false".toCharArray(), 81);
        keywords.put("friend".toCharArray(), 84);
        keywords.put("mutable".toCharArray(), 90);
        keywords.put("namespace".toCharArray(), 91);
        keywords.put("new".toCharArray(), 92);
        keywords.put("operator".toCharArray(), 95);
        keywords.put("private".toCharArray(), 98);
        keywords.put("protected".toCharArray(), 99);
        keywords.put("public".toCharArray(), 100);
        keywords.put("reinterpret_cast".toCharArray(), 102);
        keywords.put("static_cast".toCharArray(), 107);
        keywords.put("template".toCharArray(), 111);
        keywords.put("this".toCharArray(), 112);
        keywords.put("throw".toCharArray(), 113);
        keywords.put("true".toCharArray(), 114);
        keywords.put("try".toCharArray(), 115);
        keywords.put("typeid".toCharArray(), 117);
        keywords.put("typename".toCharArray(), 118);
        keywords.put("using".toCharArray(), 121);
        keywords.put("virtual".toCharArray(), 122);
        keywords.put("wchar_t".toCharArray(), 125);
        keywords.put("and".toCharArray(), 54);
        keywords.put("and_eq".toCharArray(), 55);
        keywords.put("bitand".toCharArray(), 58);
        keywords.put("bitor".toCharArray(), 59);
        keywords.put("compl".toCharArray(), 66);
        keywords.put("not".toCharArray(), 93);
        keywords.put("not_eq".toCharArray(), 94);
        keywords.put("or".toCharArray(), 96);
        keywords.put("or_eq".toCharArray(), 97);
        keywords.put("xor".toCharArray(), 127);
        keywords.put("xor_eq".toCharArray(), 128);
        ppKeywords = new CharArrayIntMap(16, -1);
        ppKeywords.put("if".toCharArray(), 0);
        ppKeywords.put("ifdef".toCharArray(), 1);
        ppKeywords.put("ifndef".toCharArray(), 2);
        ppKeywords.put("elif".toCharArray(), 3);
        ppKeywords.put("else".toCharArray(), 4);
        ppKeywords.put("endif".toCharArray(), 5);
        ppKeywords.put("include".toCharArray(), 6);
        ppKeywords.put("define".toCharArray(), 7);
        ppKeywords.put("undef".toCharArray(), 8);
        ppKeywords.put("error".toCharArray(), 9);
        ppKeywords.put("include_next".toCharArray(), 10);
    }

    public Scanner2(CodeReader reader, IScannerInfo info, ISourceElementRequestor requestor, ParserMode parserMode, ParserLanguage language, IParserLogService log, IScannerExtension extension, List workingCopies) {
        this.scannerExtension = extension;
        this.requestor = requestor;
        this.parserMode = parserMode;
        this.language = language;
        this.log = log;
        this.workingCopies = workingCopies;
        if (reader.filename != null) {
            this.fileCache.put(reader.filename, reader);
        }
        this.pushContext(reader.buffer, reader);
        this.setupBuiltInMacros();
        if (info.getDefinedSymbols() != null) {
            Map symbols = info.getDefinedSymbols();
            String[] keys = symbols.keySet().toArray(emptyStringArray);
            int i = 0;
            while (i < keys.length) {
                String symbolName = keys[i];
                Object value = symbols.get(symbolName);
                if (value instanceof String) {
                    this.addDefinition(symbolName, this.scannerExtension.initializeMacroValue(this, (String)value));
                } else if (value instanceof IMacroDescriptor) {
                    this.addDefinition(symbolName, (IMacroDescriptor)value);
                }
                ++i;
            }
        }
        this.includePaths = info.getIncludePaths();
    }

    private void pushContext(char[] buffer) {
        if (++this.bufferStackPos == this.bufferStack.length) {
            int size = this.bufferStack.length * 2;
            char[][] oldBufferStack = this.bufferStack;
            this.bufferStack = new char[size][];
            System.arraycopy(oldBufferStack, 0, this.bufferStack, 0, oldBufferStack.length);
            Object[] oldBufferData = this.bufferData;
            this.bufferData = new Object[size];
            System.arraycopy(oldBufferData, 0, this.bufferData, 0, oldBufferData.length);
            int[] oldBufferPos = this.bufferPos;
            this.bufferPos = new int[size];
            System.arraycopy(oldBufferPos, 0, this.bufferPos, 0, oldBufferPos.length);
            int[] oldBufferLimit = this.bufferLimit;
            this.bufferLimit = new int[size];
            System.arraycopy(oldBufferLimit, 0, this.bufferLimit, 0, oldBufferLimit.length);
            int[] oldLineNumbers = this.lineNumbers;
            this.lineNumbers = new int[size];
            System.arraycopy(oldLineNumbers, 0, this.lineNumbers, 0, oldLineNumbers.length);
            int[] oldLineOffsets = this.lineOffsets;
            this.lineOffsets = new int[size];
            System.arraycopy(oldLineOffsets, 0, this.lineOffsets, 0, oldLineOffsets.length);
        }
        this.bufferStack[this.bufferStackPos] = buffer;
        this.bufferPos[this.bufferStackPos] = -1;
        this.bufferLimit[this.bufferStackPos] = buffer.length;
        this.lineNumbers[this.bufferStackPos] = 1;
        this.lineOffsets[this.bufferStackPos] = 0;
    }

    private void pushContext(char[] buffer, Object data) {
        if (data instanceof InclusionData) {
            boolean isCircular = false;
            int i = 0;
            while (i < this.bufferStackPos) {
                if (this.bufferData[i] instanceof CodeReader && CharArrayUtils.equals(((CodeReader)this.bufferData[i]).filename, ((InclusionData)data).reader.filename)) {
                    isCircular = true;
                    break;
                }
                if (this.bufferData[i] instanceof InclusionData && CharArrayUtils.equals(((InclusionData)this.bufferData[i]).reader.filename, ((InclusionData)data).reader.filename)) {
                    isCircular = true;
                    break;
                }
                ++i;
            }
            if (isCircular) {
                this.handleProblem(0x200000B, ((InclusionData)data).inclusion.getStartingOffset(), ((InclusionData)data).inclusion.getFilename());
                return;
            }
        }
        this.pushContext(buffer);
        this.bufferData[this.bufferStackPos] = data;
        if (data instanceof InclusionData) {
            this.pushCallback(data);
        }
    }

    private void popContext() {
        this.bufferStack[this.bufferStackPos] = null;
        if (this.bufferData[this.bufferStackPos] instanceof InclusionData) {
            this.pushCallback(((InclusionData)this.bufferData[this.bufferStackPos]).inclusion);
        }
        this.bufferData[this.bufferStackPos] = null;
        --this.bufferStackPos;
    }

    private void pushCallback(Object obj) {
        if (++this.callbackPos == this.callbackStack.length) {
            Object[] temp = new Object[this.callbackStack.length << 1];
            System.arraycopy(this.callbackStack, 0, temp, 0, this.callbackStack.length);
            this.callbackStack = temp;
        }
        this.callbackStack[this.callbackPos] = obj;
    }

    private void popCallbacks() {
        Object obj = null;
        int i = 0;
        while (i <= this.callbackPos) {
            obj = this.callbackStack[i];
            if (obj instanceof InclusionData) {
                this.requestor.enterInclusion(((InclusionData)obj).inclusion);
            } else if (obj instanceof IASTInclusion) {
                this.requestor.exitInclusion((IASTInclusion)obj);
            } else if (obj instanceof IASTMacro) {
                this.requestor.acceptMacro((IASTMacro)obj);
            } else if (obj instanceof IProblem) {
                this.requestor.acceptProblem((IProblem)obj);
            }
            ++i;
        }
        this.callbackPos = -1;
    }

    public void addDefinition(String key, IMacroDescriptor macroToBeAdded) {
    }

    public void addDefinition(String key, String value) {
        char[] ckey = key.toCharArray();
        this.definitions.put(ckey, new ObjectStyleMacro(ckey, value.toCharArray()));
    }

    public int getCount() {
        return this.count;
    }

    public IMacroDescriptor getDefinition(String key) {
        return (IMacroDescriptor)this.definitions.get(key.toCharArray());
    }

    public Map getDefinitions() {
        CharArrayObjectMap objMap = this.getRealDefinitions();
        int size = objMap.size();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(size);
        int i = 0;
        while (i < size) {
            hashMap.put(String.valueOf(objMap.keyAt(i)), objMap.getAt(i));
            ++i;
        }
        return hashMap;
    }

    public CharArrayObjectMap getRealDefinitions() {
        return this.definitions;
    }

    public int getDepth() {
        return 0;
    }

    public String[] getIncludePaths() {
        return this.includePaths;
    }

    public boolean isOnTopContext() {
        return this.bufferStackPos <= 0;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public IToken nextToken() throws ScannerException, EndOfFileException {
        if (this.nextToken == null && !this.finished) {
            this.nextToken = this.fetchToken();
            if (this.nextToken == null) {
                this.finished = true;
            }
        }
        if (this.callbackPos != -1) {
            this.popCallbacks();
        }
        if (this.finished) {
            if (this.offsetBoundary == -1) {
                throw EOF;
            }
            this.throwOLRE();
        }
        if (this.lastToken != null) {
            this.lastToken.setNext(this.nextToken);
        }
        IToken oldToken = this.lastToken;
        this.lastToken = this.nextToken;
        this.nextToken = this.fetchToken();
        if (this.nextToken == null) {
            this.finished = true;
            return this.lastToken;
        }
        if (this.nextToken.getType() == 139) {
            IToken token2 = this.fetchToken();
            if (token2 == null) {
                this.nextToken = null;
                this.finished = true;
                return this.lastToken;
            }
            char[] pb = CharArrayUtils.concat(this.lastToken.getCharImage(), token2.getCharImage());
            this.pushContext(pb);
            this.lastToken = oldToken;
            this.nextToken = null;
            return this.nextToken();
        }
        if (this.lastToken.getType() == 130) {
            if (this.nextToken == null) return this.lastToken;
            if (this.nextToken.getType() != 130 && this.nextToken.getType() != 131) {
                return this.lastToken;
            }
        } else {
            if (this.lastToken.getType() != 131) return this.lastToken;
            if (true) {
                if (this.nextToken == null) return this.lastToken;
                if (this.nextToken.getType() != 130 && this.nextToken.getType() != 131) return this.lastToken;
            }
        }
        do {
            int tokenType = 130;
            if (this.lastToken.getType() == 131 || this.nextToken.getType() == 131) {
                tokenType = 131;
            }
            this.lastToken = this.newToken(tokenType, CharArrayUtils.concat(this.lastToken.getCharImage(), this.nextToken.getCharImage()));
            if (oldToken != null) {
                oldToken.setNext(this.lastToken);
            }
            this.nextToken = this.fetchToken();
            if (this.nextToken == null) return this.lastToken;
        } while (this.nextToken.getType() == 130 || this.nextToken.getType() == 131);
        return this.lastToken;
    }

    private void throwOLRE() throws OffsetLimitReachedException {
        if (this.lastToken != null && this.lastToken.getEndOffset() != this.offsetBoundary) {
            throw new OffsetLimitReachedException(null);
        }
        throw new OffsetLimitReachedException(this.lastToken);
    }

    private IToken fetchToken() throws ScannerException, EndOfFileException {
        ++this.count;
        block39: while (this.bufferStackPos >= 0) {
            this.skipOverWhiteSpace();
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 1;
            if (this.bufferPos[n] >= this.bufferLimit[this.bufferStackPos]) {
                this.popContext();
                continue;
            }
            char[] buffer = this.bufferStack[this.bufferStackPos];
            int limit = this.bufferLimit[this.bufferStackPos];
            int pos = this.bufferPos[this.bufferStackPos];
            switch (buffer[pos]) {
                case '\n': {
                    break;
                }
                case 'L': {
                    if (pos + 1 < limit && buffer[pos + 1] == '\"') {
                        return this.scanString();
                    }
                    if (pos + 1 < limit && buffer[pos + 1] == '\'') {
                        return this.scanCharLiteral(true);
                    }
                    IToken t = this.scanIdentifier();
                    if (t instanceof MacroExpansionToken) continue block39;
                    return t;
                }
                case '\"': {
                    return this.scanString();
                }
                case '\'': {
                    return this.scanCharLiteral(false);
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    IToken t = this.scanIdentifier();
                    if (t instanceof MacroExpansionToken) continue block39;
                    return t;
                }
                case '\\': {
                    IToken t;
                    if (pos + 1 < limit && (buffer[pos + 1] == 'u' || buffer[pos + 1] == 'U')) {
                        t = this.scanIdentifier();
                        if (t instanceof MacroExpansionToken) continue block39;
                        return t;
                    }
                    this.handleProblem(0x1000001, this.bufferPos[this.bufferStackPos], new char[]{'\\'});
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.scanNumber();
                }
                case '.': {
                    if (pos + 1 < limit) {
                        switch (buffer[pos + 1]) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                return this.scanNumber();
                            }
                            case '.': {
                                if (pos + 2 < limit && buffer[pos + 2] == '.') {
                                    int n2 = this.bufferStackPos;
                                    this.bufferPos[n2] = this.bufferPos[n2] + 2;
                                    return this.newToken(48);
                                }
                            }
                            case '*': {
                                int n3 = this.bufferStackPos;
                                this.bufferPos[n3] = this.bufferPos[n3] + 1;
                                return this.newToken(49);
                            }
                        }
                    }
                    return this.newToken(50);
                }
                case '#': {
                    if (pos + 1 < limit && buffer[pos + 1] == '#') {
                        int n4 = this.bufferStackPos;
                        this.bufferPos[n4] = this.bufferPos[n4] + 1;
                        return this.newToken(139);
                    }
                    this.handlePPDirective(pos);
                    break;
                }
                case '{': {
                    return this.newToken(12);
                }
                case '}': {
                    return this.newToken(13);
                }
                case '[': {
                    return this.newToken(10);
                }
                case ']': {
                    return this.newToken(11);
                }
                case '(': {
                    return this.newToken(8);
                }
                case ')': {
                    return this.newToken(9);
                }
                case ';': {
                    return this.newToken(5);
                }
                case ':': {
                    if (pos + 1 < limit && buffer[pos + 1] == ':') {
                        int n5 = this.bufferStackPos;
                        this.bufferPos[n5] = this.bufferPos[n5] + 1;
                        return this.newToken(3);
                    }
                    return this.newToken(4);
                }
                case '?': {
                    return this.newToken(7);
                }
                case '+': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '+') {
                            int n6 = this.bufferStackPos;
                            this.bufferPos[n6] = this.bufferPos[n6] + 1;
                            return this.newToken(15);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n7 = this.bufferStackPos;
                            this.bufferPos[n7] = this.bufferPos[n7] + 1;
                            return this.newToken(14);
                        }
                    }
                    return this.newToken(16);
                }
                case '-': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '>') {
                            if (pos + 2 < limit && buffer[pos + 2] == '*') {
                                int n8 = this.bufferStackPos;
                                this.bufferPos[n8] = this.bufferPos[n8] + 2;
                                return this.newToken(19);
                            }
                            int n9 = this.bufferStackPos;
                            this.bufferPos[n9] = this.bufferPos[n9] + 1;
                            return this.newToken(20);
                        }
                        if (buffer[pos + 1] == '-') {
                            int n10 = this.bufferStackPos;
                            this.bufferPos[n10] = this.bufferPos[n10] + 1;
                            return this.newToken(18);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n11 = this.bufferStackPos;
                            this.bufferPos[n11] = this.bufferPos[n11] + 1;
                            return this.newToken(17);
                        }
                    }
                    return this.newToken(21);
                }
                case '*': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n12 = this.bufferStackPos;
                        this.bufferPos[n12] = this.bufferPos[n12] + 1;
                        return this.newToken(22);
                    }
                    return this.newToken(23);
                }
                case '/': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n13 = this.bufferStackPos;
                        this.bufferPos[n13] = this.bufferPos[n13] + 1;
                        return this.newToken(51);
                    }
                    return this.newToken(52);
                }
                case '%': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n14 = this.bufferStackPos;
                        this.bufferPos[n14] = this.bufferPos[n14] + 1;
                        return this.newToken(24);
                    }
                    return this.newToken(25);
                }
                case '^': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n15 = this.bufferStackPos;
                        this.bufferPos[n15] = this.bufferPos[n15] + 1;
                        return this.newToken(26);
                    }
                    return this.newToken(27);
                }
                case '&': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '&') {
                            int n16 = this.bufferStackPos;
                            this.bufferPos[n16] = this.bufferPos[n16] + 1;
                            return this.newToken(29);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n17 = this.bufferStackPos;
                            this.bufferPos[n17] = this.bufferPos[n17] + 1;
                            return this.newToken(28);
                        }
                    }
                    return this.newToken(30);
                }
                case '|': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '|') {
                            int n18 = this.bufferStackPos;
                            this.bufferPos[n18] = this.bufferPos[n18] + 1;
                            return this.newToken(32);
                        }
                        if (buffer[pos + 1] == '=') {
                            int n19 = this.bufferStackPos;
                            this.bufferPos[n19] = this.bufferPos[n19] + 1;
                            return this.newToken(31);
                        }
                    }
                    return this.newToken(33);
                }
                case '~': {
                    return this.newToken(34);
                }
                case '!': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n20 = this.bufferStackPos;
                        this.bufferPos[n20] = this.bufferPos[n20] + 1;
                        return this.newToken(35);
                    }
                    return this.newToken(36);
                }
                case '=': {
                    if (pos + 1 < limit && buffer[pos + 1] == '=') {
                        int n21 = this.bufferStackPos;
                        this.bufferPos[n21] = this.bufferPos[n21] + 1;
                        return this.newToken(37);
                    }
                    return this.newToken(38);
                }
                case '<': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '=') {
                            int n22 = this.bufferStackPos;
                            this.bufferPos[n22] = this.bufferPos[n22] + 1;
                            return this.newToken(41);
                        }
                        if (buffer[pos + 1] == '<') {
                            if (pos + 2 < limit && buffer[pos + 2] == '=') {
                                int n23 = this.bufferStackPos;
                                this.bufferPos[n23] = this.bufferPos[n23] + 2;
                                return this.newToken(47);
                            }
                            int n24 = this.bufferStackPos;
                            this.bufferPos[n24] = this.bufferPos[n24] + 1;
                            return this.newToken(40);
                        }
                    }
                    return this.newToken(42);
                }
                case '>': {
                    if (pos + 1 < limit) {
                        if (buffer[pos + 1] == '=') {
                            int n25 = this.bufferStackPos;
                            this.bufferPos[n25] = this.bufferPos[n25] + 1;
                            return this.newToken(45);
                        }
                        if (buffer[pos + 1] == '>') {
                            if (pos + 2 < limit && buffer[pos + 2] == '=') {
                                int n26 = this.bufferStackPos;
                                this.bufferPos[n26] = this.bufferPos[n26] + 2;
                                return this.newToken(43);
                            }
                            int n27 = this.bufferStackPos;
                            this.bufferPos[n27] = this.bufferPos[n27] + 1;
                            return this.newToken(44);
                        }
                    }
                    return this.newToken(46);
                }
                case ',': {
                    return this.newToken(6);
                }
                default: {
                    IToken t;
                    if (!Character.isLetter(buffer[pos]) || (t = this.scanIdentifier()) instanceof MacroExpansionToken) continue block39;
                    return t;
                }
            }
        }
        return null;
    }

    private IToken newToken(int signal) {
        return new SimpleToken(signal, this.bufferPos[this.bufferStackPos] + 1, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[this.bufferStackPos] + 1));
    }

    private IToken newToken(int signal, char[] buffer) {
        if (this.bufferData[this.bufferStackPos] instanceof ObjectStyleMacro || this.bufferData[this.bufferStackPos] instanceof FunctionStyleMacro) {
            int mostRelevant = this.bufferStackPos;
            while (mostRelevant >= 0) {
                if (this.bufferData[mostRelevant] instanceof InclusionData || this.bufferData[mostRelevant] instanceof CodeReader) break;
                --mostRelevant;
            }
            if (this.bufferData[this.bufferStackPos] instanceof ObjectStyleMacro) {
                return new ImagedExpansionToken(signal, buffer, this.bufferPos[mostRelevant], ((ObjectStyleMacro)this.bufferData[this.bufferStackPos]).name.length, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[this.bufferStackPos] + 1));
            }
            return new ImagedExpansionToken(signal, buffer, this.bufferPos[mostRelevant], ((FunctionStyleMacro)this.bufferData[this.bufferStackPos]).name.length, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[this.bufferStackPos] + 1));
        }
        return new ImagedToken(signal, buffer, this.bufferPos[this.bufferStackPos] + 1, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[this.bufferStackPos] + 1));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private IToken scanIdentifier() {
        int len;
        int start;
        boolean escapedNewline;
        char[] buffer;
        block13: {
            int n;
            int limit;
            block12: {
                buffer = this.bufferStack[this.bufferStackPos];
                escapedNewline = false;
                start = this.bufferPos[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                len = 1;
                if (!true) break block12;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block13;
            }
            do {
                char c;
                if ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
                    ++len;
                } else if (c == '\\' && this.bufferPos[this.bufferStackPos] + 1 < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
                    int n2 = this.bufferStackPos;
                    this.bufferPos[n2] = this.bufferPos[n2] + 1;
                    len += 2;
                    escapedNewline = true;
                } else {
                    if (c != '\\' || this.bufferPos[this.bufferStackPos] + 1 >= limit || buffer[this.bufferPos[this.bufferStackPos] + 1] != 'u' && buffer[this.bufferPos[this.bufferStackPos] + 1] != 'U') break;
                    int n3 = this.bufferStackPos;
                    this.bufferPos[n3] = this.bufferPos[n3] + 1;
                    len += 2;
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
        Object expObject = this.definitions.get(buffer, start, len);
        if (expObject != null && !this.isLimitReached()) {
            int stackPos = this.bufferStackPos;
            while (stackPos >= 0) {
                if (this.bufferData[stackPos] != null && this.bufferData[stackPos] instanceof ObjectStyleMacro && CharArrayUtils.equals(buffer, start, len, ((ObjectStyleMacro)this.bufferData[stackPos]).name)) {
                    expObject = null;
                    break;
                }
                --stackPos;
            }
        }
        if (expObject != null && !this.isLimitReached()) {
            if (expObject instanceof FunctionStyleMacro) {
                this.handleFunctionStyleMacro((FunctionStyleMacro)expObject, true);
                return new MacroExpansionToken();
            }
            if (expObject instanceof ObjectStyleMacro) {
                ObjectStyleMacro expMacro = (ObjectStyleMacro)expObject;
                char[] expText = expMacro.expansion;
                if (expText.length <= 0) return new MacroExpansionToken();
                this.pushContext(expText, expMacro);
                return new MacroExpansionToken();
            }
            if (!(expObject instanceof char[])) return new MacroExpansionToken();
            char[] expText = (char[])expObject;
            if (expText.length <= 0) return new MacroExpansionToken();
            this.pushContext(expText);
            return new MacroExpansionToken();
        }
        char[] result = escapedNewline ? this.removedEscapedNewline(buffer, start, len) : null;
        int tokenType = escapedNewline ? keywords.get(result, 0, result.length) : keywords.get(buffer, start, len);
        if (tokenType != Scanner2.keywords.undefined) return this.newToken(tokenType);
        result = result != null ? result : CharArrayUtils.extract(buffer, start, len);
        return this.newToken(1, result);
    }

    private final boolean isLimitReached() {
        char c;
        if (this.offsetBoundary == -1 || this.bufferStackPos != 0) {
            return false;
        }
        if (this.bufferPos[this.bufferStackPos] == this.offsetBoundary - 1) {
            return true;
        }
        return this.bufferPos[this.bufferStackPos] == this.offsetBoundary && ((c = this.bufferStack[this.bufferStackPos][this.bufferPos[this.bufferStackPos]]) == '\n' || c == ' ' || c == '\t' || c == '\r');
    }

    /*
     * Unable to fully structure code
     */
    private IToken scanString() {
        buffer = this.bufferStack[this.bufferStackPos];
        tokenType = 130;
        if (buffer[this.bufferPos[this.bufferStackPos]] == 'L') {
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 1;
            tokenType = 131;
        }
        stringStart = this.bufferPos[this.bufferStackPos] + 1;
        stringLen = 0;
        escaped = false;
        foundClosingQuote = false;
        if (true) ** GOTO lbl26
        do {
            block6: {
                ++stringLen;
                c = buffer[this.bufferPos[this.bufferStackPos]];
                if (c != '\"') break block6;
                if (!escaped) {
                    foundClosingQuote = true;
                    break;
                }
                ** GOTO lbl25
            }
            if (c == '\\') {
                escaped = escaped == false;
            } else {
                if (c == '\n' && !escaped) break;
lbl25:
                // 2 sources

                escaped = false;
            }
lbl26:
            // 3 sources

            v1 = this.bufferStackPos;
        } while ((this.bufferPos[v1] = this.bufferPos[v1] + 1) < this.bufferLimit[this.bufferStackPos]);
        result = CharArrayUtils.extract(buffer, stringStart, --stringLen);
        if (!foundClosingQuote) {
            this.handleProblem(0x1000002, stringStart, result);
        }
        return this.newToken(tokenType, result);
    }

    /*
     * Unable to fully structure code
     */
    private IToken scanCharLiteral(boolean b) {
        buffer = this.bufferStack[this.bufferStackPos];
        start = this.bufferPos[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        tokenType = 132;
        length = 1;
        if (buffer[this.bufferPos[this.bufferStackPos]] == 'L') {
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 1;
            tokenType = 133;
            ++length;
        }
        if (start >= limit) {
            return this.newToken(tokenType, Scanner2.emptyCharArray);
        }
        escaped = false;
        if (true) ** GOTO lbl27
        do {
            block7: {
                ++length;
                pos = this.bufferPos[this.bufferStackPos];
                if (buffer[pos] != '\'') break block7;
                if (!escaped) {
                    break;
                }
                ** GOTO lbl-1000
            }
            if (buffer[pos] == '\\') {
                escaped = escaped == false;
            } else lbl-1000:
            // 2 sources

            {
                escaped = false;
            }
lbl27:
            // 3 sources

            v1 = this.bufferStackPos;
        } while ((this.bufferPos[v1] = this.bufferPos[v1] + 1) < limit);
        if (this.bufferPos[this.bufferStackPos] == limit) {
            this.handleProblem(0x1000001, start, CharArrayUtils.extract(buffer, start, length));
            return this.newToken(tokenType, Scanner2.emptyCharArray);
        }
        image = length > 0 ? CharArrayUtils.extract(buffer, start, length) : Scanner2.emptyCharArray;
        return this.newToken(tokenType, image);
    }

    private void handleProblem(int id, int startOffset, char[] arg) {
        if (this.parserMode == ParserMode.COMPLETION_PARSE) {
            return;
        }
        IProblem p = spf.createProblem(id, startOffset, this.bufferPos[this.bufferStackPos], this.getLineNumber(this.bufferPos[this.bufferStackPos]), this.getCurrentFilename(), arg != null ? arg : emptyCharArray, false, true);
        this.pushCallback(p);
    }

    protected int getLineNumber(int offset) {
        int startingPoint;
        if (this.parserMode == ParserMode.COMPLETION_PARSE) {
            return -1;
        }
        int index = this.getCurrentFileIndex();
        if (offset >= this.bufferLimit[index]) {
            return -1;
        }
        int lineNum = this.lineNumbers[index];
        int i = startingPoint = this.lineOffsets[index];
        while (i < offset) {
            if (this.bufferStack[index][i] == '\n') {
                ++lineNum;
            }
            ++i;
        }
        if (startingPoint < offset) {
            this.lineNumbers[index] = lineNum;
            this.lineOffsets[index] = offset;
        }
        return lineNum;
    }

    /*
     * Unable to fully structure code
     */
    private IToken scanNumber() {
        buffer = this.bufferStack[this.bufferStackPos];
        start = this.bufferPos[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        isFloat = buffer[start] == '.';
        hasExponent = false;
        isHex = false;
        if (buffer[start] != '0' || start + 1 >= limit) ** GOTO lbl72
        switch (buffer[start + 1]) {
            case 'X': 
            case 'x': {
                isHex = true;
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 1;
            }
        }
        if (true) ** GOTO lbl72
        block21: do {
            pos = this.bufferPos[this.bufferStackPos];
            block3 : switch (buffer[pos]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    if (isFloat) {
                        this.handleProblem(0x1000004, start, null);
                        break block21;
                    }
                    isFloat = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (isHex) break;
                    if (hasExponent || pos + 1 >= limit) break block21;
                    switch (buffer[pos + 1]) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            isFloat = true;
                            hasExponent = true;
                            v1 = this.bufferStackPos;
                            this.bufferPos[v1] = this.bufferPos[v1] + 1;
                            break block3;
                        }
                    }
                    break block21;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': {
                    if (isHex) break;
                    v2 = this.bufferStackPos;
                    this.bufferPos[v2] = this.bufferPos[v2] - 1;
                    break block21;
                }
                case 'F': 
                case 'f': {
                    if (isHex) break;
                    v3 = this.bufferStackPos;
                    this.bufferPos[v3] = this.bufferPos[v3] + 1;
                    break block21;
                }
                case 'P': 
                case 'p': {
                    if (!isFloat || !isHex) {
                        v4 = this.bufferStackPos;
                        this.bufferPos[v4] = this.bufferPos[v4] - 1;
                        break block21;
                    }
                    if (hasExponent || pos + 1 >= limit) break block21;
                    switch (buffer[pos + 1]) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            isFloat = true;
                            hasExponent = true;
                            v5 = this.bufferStackPos;
                            this.bufferPos[v5] = this.bufferPos[v5] + 1;
                            break block3;
                        }
                    }
                    break block21;
                }
                case 'L': 
                case 'U': 
                case 'l': 
                case 'u': {
                    if (true) ** GOTO lbl68
                    do {
                        switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                            case 'L': 
                            case 'U': 
                            case 'l': 
                            case 'u': {
                                break;
                            }
                            default: {
                                break block21;
                            }
                        }
lbl68:
                        // 2 sources

                        v6 = this.bufferStackPos;
                    } while ((this.bufferPos[v6] = this.bufferPos[v6] + 1) < limit);
                }
                default: {
                    break block21;
                }
            }
lbl72:
            // 9 sources

            v7 = this.bufferStackPos;
        } while ((this.bufferPos[v7] = this.bufferPos[v7] + 1) < limit);
        v8 = this.bufferStackPos;
        this.bufferPos[v8] = this.bufferPos[v8] - 1;
        result = CharArrayUtils.extract(buffer, start, this.bufferPos[this.bufferStackPos] - start + 1);
        v9 = tokenType = isFloat != false ? 129 : 2;
        if (tokenType == 2 && isHex && result.length == 2) {
            this.handleProblem(0x1000005, start, result);
        }
        return this.newToken(tokenType, result);
    }

    private boolean branchState(int state) {
        if (state != 1 && this.branchStackPos == -1) {
            return false;
        }
        switch (state) {
            case 1: {
                if (++this.branchStackPos == this.branches.length) {
                    int[] temp = new int[this.branches.length << 1];
                    System.arraycopy(this.branches, 0, temp, 0, this.branches.length);
                    this.branches = temp;
                }
                this.branches[this.branchStackPos] = 1;
                return true;
            }
            case 2: 
            case 3: {
                switch (this.branches[this.branchStackPos]) {
                    case 1: 
                    case 2: {
                        this.branches[this.branchStackPos] = state;
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (this.branches[this.branchStackPos]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        --this.branchStackPos;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void handlePPDirective(int pos) throws ScannerException, EndOfFileException {
        block28: {
            block27: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                startingLineNumber = this.getLineNumber(pos);
                this.skipOverWhiteSpace();
                if (this.isLimitReached()) {
                    this.handleCompletionOnPreprocessorDirective("#");
                }
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 1;
                start = this.bufferPos[v0];
                if (start >= limit || buffer[start] == '\n') {
                    return;
                }
                problem = false;
                c = buffer[start];
                if (c < 'a' || c > 'z') break block27;
                ** GOTO lbl-1000
                while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c == '_') lbl-1000:
                // 2 sources

                {
                    v1 = this.bufferStackPos;
                    this.bufferPos[v1] = this.bufferPos[v1] + 1;
                    if (this.bufferPos[v1] < limit) continue;
                }
                v2 = this.bufferStackPos;
                this.bufferPos[v2] = this.bufferPos[v2] - 1;
                len = this.bufferPos[this.bufferStackPos] - start + 1;
                if (this.isLimitReached()) {
                    this.handleCompletionOnPreprocessorDirective(new String(buffer, pos, len + 1));
                }
                if ((type = Scanner2.ppKeywords.get(buffer, start, len)) == Scanner2.ppKeywords.undefined) break block28;
                switch (type) {
                    case 6: {
                        this.handlePPInclude(pos, false, startingLineNumber);
                        return;
                    }
                    case 10: {
                        this.handlePPInclude(pos, true, startingLineNumber);
                        return;
                    }
                    case 7: {
                        this.handlePPDefine(pos, startingLineNumber);
                        return;
                    }
                    case 8: {
                        this.handlePPUndef();
                        return;
                    }
                    case 1: {
                        this.handlePPIfdef(true);
                        return;
                    }
                    case 2: {
                        this.handlePPIfdef(false);
                        return;
                    }
                    case 0: {
                        start = this.bufferPos[this.bufferStackPos];
                        this.skipToNewLine();
                        len = this.bufferPos[this.bufferStackPos] - start;
                        if (this.isLimitReached()) {
                            this.handleCompletionOnExpression(CharArrayUtils.extract(buffer, start, len));
                        }
                        this.branchState(1);
                        if (this.expressionEvaluator.evaluate(buffer, start, len, this.definitions) == 0L) {
                            if (this.dlog != null) {
                                this.dlog.println("#if <FALSE> " + new String(buffer, start + 1, len - 1));
                            }
                            this.skipOverConditionalCode(true);
                            if (this.isLimitReached()) {
                                this.handleInvalidCompletion();
                            }
                        } else if (this.dlog != null) {
                            this.dlog.println("#if <TRUE> " + new String(buffer, start + 1, len - 1));
                        }
                        return;
                    }
                    case 3: 
                    case 4: {
                        if (this.branchState(type == 4 ? 3 : 2)) {
                            this.skipToNewLine();
                            this.skipOverConditionalCode(false);
                        } else {
                            this.handleProblem(0x2000004, start, Scanner2.ppKeywords.findKey(buffer, start, len));
                            this.skipToNewLine();
                        }
                        if (this.isLimitReached()) {
                            this.handleInvalidCompletion();
                        }
                        return;
                    }
                    case 9: {
                        start = this.bufferPos[this.bufferStackPos];
                        this.skipToNewLine();
                        len = this.bufferPos[this.bufferStackPos] - start;
                        this.handleProblem(0x2000001, start, CharArrayUtils.extract(buffer, start, len));
                        ** break;
                    }
                    case 5: {
                        if (!this.branchState(4)) {
                            this.handleProblem(0x2000004, start, Scanner2.ppKeywords.findKey(buffer, start, len));
                            ** break;
                        }
                        break block28;
                    }
                    default: {
                        problem = true;
                        ** break;
                    }
                }
lbl89:
                // 3 sources

                break block28;
            }
            problem = true;
        }
        if (problem) {
            this.handleProblem(0x2000006, start, null);
        }
        this.skipToNewLine();
    }

    /*
     * Unable to fully structure code
     */
    private void handlePPInclude(int pos2, boolean next, int startingLineNumber) {
        block38: {
            block39: {
                block36: {
                    buffer = this.bufferStack[this.bufferStackPos];
                    limit = this.bufferLimit[this.bufferStackPos];
                    this.skipOverWhiteSpace();
                    startOffset = pos2;
                    v0 = this.bufferStackPos;
                    v1 = this.bufferPos[v0] + 1;
                    this.bufferPos[v0] = v1;
                    pos = v1;
                    if (pos >= limit) {
                        return;
                    }
                    local = false;
                    filename = null;
                    endOffset = startOffset;
                    nameOffset = 0;
                    nameEndOffset = 0;
                    nameLine = 0;
                    endLine = 0;
                    c = buffer[pos];
                    if (c == '\n') {
                        return;
                    }
                    if (c != '\"') break block36;
                    nameLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
                    local = true;
                    start = this.bufferPos[this.bufferStackPos] + 1;
                    length = 0;
                    escaped = false;
                    if (true) ** GOTO lbl41
                    do {
                        block37: {
                            ++length;
                            c = buffer[this.bufferPos[this.bufferStackPos]];
                            if (c != '\"') break block37;
                            if (!escaped) {
                                break;
                            }
                            ** GOTO lbl-1000
                        }
                        if (c == '\\') {
                            escaped = escaped == false;
                        } else lbl-1000:
                        // 2 sources

                        {
                            escaped = false;
                        }
lbl41:
                        // 3 sources

                        v2 = this.bufferStackPos;
                    } while ((this.bufferPos[v2] = this.bufferPos[v2] + 1) < limit);
                    filename = new String(buffer, start, --length);
                    nameOffset = start;
                    nameEndOffset = start + length;
                    endOffset = start + length + 1;
                    break block38;
                }
                if (c != '<') break block39;
                nameLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
                local = false;
                start = this.bufferPos[this.bufferStackPos] + 1;
                length = 0;
                if (true) ** GOTO lbl57
                do {
                    ++length;
lbl57:
                    // 2 sources

                    v3 = this.bufferStackPos;
                } while ((this.bufferPos[v3] = this.bufferPos[v3] + 1) < limit && buffer[this.bufferPos[this.bufferStackPos]] != '>');
                endOffset = start + length + 1;
                nameOffset = start;
                nameEndOffset = start + length;
                filename = new String(buffer, start, length);
                break block38;
            }
            startPos = pos;
            len = 1;
            if (true) ** GOTO lbl76
            do {
                if ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
                    ++len;
                } else {
                    if (c != '\\' || this.bufferPos[this.bufferStackPos] + 1 >= buffer.length || buffer[this.bufferPos[this.bufferStackPos] + 1] != '\n') break;
                    v4 = this.bufferStackPos;
                    this.bufferPos[v4] = this.bufferPos[v4] + 1;
                    len += 2;
                }
lbl76:
                // 3 sources

                v5 = this.bufferStackPos;
            } while ((this.bufferPos[v5] = this.bufferPos[v5] + 1) < limit);
            if ((expObject = this.definitions.get(buffer, startPos, len)) != null) {
                v6 = this.bufferStackPos;
                this.bufferPos[v6] = this.bufferPos[v6] - 1;
                t = null;
                if (expObject instanceof FunctionStyleMacro) {
                    t = this.handleFunctionStyleMacro((FunctionStyleMacro)expObject, false);
                } else if (expObject instanceof ObjectStyleMacro) {
                    t = ((ObjectStyleMacro)expObject).expansion;
                }
                if (t != null) {
                    if (t[t.length - 1] == t[0] && t[0] == '\"') {
                        local = true;
                        filename = new String(t, 1, t.length - 2);
                    } else if (t[0] == '<' && t[t.length - 1] == '>') {
                        local = false;
                        filename = new String(t, 1, t.length - 2);
                    }
                }
            }
        }
        if (filename == null || filename == "") {
            this.handleProblem(0x2000006, startOffset, null);
            return;
        }
        fileNameArray = filename.toCharArray();
        endLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
        this.skipToNewLine();
        if (this.parserMode == ParserMode.QUICK_PARSE) {
            inclusion = this.getASTFactory().createInclusion(fileNameArray, Scanner2.EMPTY_STRING_CHAR_ARRAY, local, startOffset, startingLineNumber, nameOffset, nameEndOffset, nameLine, endOffset, endLine, this.getCurrentFilename());
            this.pushCallback(new InclusionData(null, inclusion));
            this.pushCallback(inclusion);
        } else {
            reader = null;
            if (local && (parentFile = (file = new File(String.valueOf(this.getCurrentFilename()))).getParentFile()) != null) {
                absolutePath = parentFile.getAbsolutePath();
                finalPath = ScannerUtility.createReconciledPath(absolutePath, filename);
                reader = (CodeReader)this.fileCache.get(finalPath);
                if (reader == null) {
                    reader = ScannerUtility.createReaderDuple(finalPath, this.requestor, this.getWorkingCopies());
                }
                if (reader != null) {
                    if (reader.filename != null) {
                        this.fileCache.put(reader.filename, reader);
                    }
                    if (this.dlog != null) {
                        this.dlog.println("#include \"" + finalPath + "\"");
                    }
                    inclusion = this.getASTFactory().createInclusion(fileNameArray, reader.filename, local, startOffset, startingLineNumber, nameOffset, nameEndOffset, nameLine, endOffset, endLine, this.getCurrentFilename());
                    this.pushContext(reader.buffer, new InclusionData(reader, inclusion));
                    return;
                }
            }
            v7 = foundme = next == false;
            if (this.includePaths != null) {
                i = 0;
                while (i < this.includePaths.length) {
                    finalPath = ScannerUtility.createReconciledPath(this.includePaths[i], filename);
                    if (!foundme) {
                        if (finalPath.equals(((InclusionData)this.bufferData[this.bufferStackPos]).reader.filename)) {
                            foundme = true;
                        }
                    } else {
                        reader = (CodeReader)this.fileCache.get(finalPath);
                        if (reader == null) {
                            reader = ScannerUtility.createReaderDuple(finalPath, this.requestor, this.getWorkingCopies());
                        }
                        if (reader != null) {
                            if (reader.filename != null) {
                                this.fileCache.put(reader.filename, reader);
                            }
                            if (this.dlog != null) {
                                this.dlog.println("#include <" + finalPath + ">");
                            }
                            inclusion = this.getASTFactory().createInclusion(fileNameArray, reader.filename, local, startOffset, startingLineNumber, nameOffset, nameEndOffset, nameLine, endOffset, endLine, this.getCurrentFilename());
                            this.pushContext(reader.buffer, new InclusionData(reader, inclusion));
                            return;
                        }
                    }
                    ++i;
                }
            }
            if (reader == null) {
                this.handleProblem(0x2000002, startOffset, fileNameArray);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handlePPDefine(int pos2, int startingLineNumber) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        startingOffset = pos2;
        endingLine = 0;
        nameLine = 0;
        this.skipOverWhiteSpace();
        v0 = this.bufferStackPos;
        v1 = this.bufferPos[v0] + 1;
        this.bufferPos[v0] = v1;
        idstart = v1;
        if (idstart >= limit) {
            return;
        }
        c = buffer[idstart];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isUnicodeIdentifierPart(c))) {
            this.handleProblem(0x2000005, idstart, null);
            this.skipToNewLine();
            return;
        }
        idlen = 1;
        ** GOTO lbl23
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
            ++idlen;
lbl23:
            // 2 sources

            v2 = this.bufferStackPos;
            this.bufferPos[v2] = this.bufferPos[v2] + 1;
            if (this.bufferPos[v2] < limit) continue;
        }
        v3 = this.bufferStackPos;
        this.bufferPos[v3] = this.bufferPos[v3] - 1;
        nameLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
        name = new char[idlen];
        System.arraycopy(buffer, idstart, name, 0, idlen);
        if (this.dlog != null) {
            this.dlog.println("#define " + new String(buffer, idstart, idlen));
        }
        arglist = null;
        pos = this.bufferPos[this.bufferStackPos];
        if (pos + 1 < limit && buffer[pos + 1] == '(') {
            v4 = this.bufferStackPos;
            this.bufferPos[v4] = this.bufferPos[v4] + 1;
            arglist = new char[4][];
            currarg = -1;
            while (this.bufferPos[this.bufferStackPos] < limit) {
                pos = this.bufferPos[this.bufferStackPos];
                this.skipOverWhiteSpace();
                v5 = this.bufferStackPos;
                this.bufferPos[v5] = this.bufferPos[v5] + 1;
                if (this.bufferPos[v5] >= limit) {
                    return;
                }
                c = buffer[this.bufferPos[this.bufferStackPos]];
                if (c == ')') break;
                if (c == ',') continue;
                if (c == '.' && pos + 1 < limit && buffer[pos + 1] == '.' && pos + 2 < limit && buffer[pos + 2] == '.') {
                    v6 = this.bufferStackPos;
                    this.bufferPos[v6] = this.bufferPos[v6] + 2;
                    arglist[++currarg] = "...".toCharArray();
                    continue;
                }
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || Character.isUnicodeIdentifierPart(c))) {
                    this.handleProblem(0x2000005, idstart, name);
                    this.skipToNewLine();
                    return;
                }
                argstart = this.bufferPos[this.bufferStackPos];
                this.skipOverIdentifier();
                if (++currarg == arglist.length) {
                    oldarglist = arglist;
                    arglist = new char[oldarglist.length * 2][];
                    System.arraycopy(oldarglist, 0, arglist, 0, oldarglist.length);
                }
                arglen = this.bufferPos[this.bufferStackPos] - argstart + 1;
                arg = new char[arglen];
                System.arraycopy(buffer, argstart, arg, 0, arglen);
                arglist[currarg] = arg;
            }
        }
        this.skipOverWhiteSpace();
        textstart = this.bufferPos[this.bufferStackPos] + 1;
        textend = textstart - 1;
        encounteredMultilineComment = false;
        while (this.bufferPos[this.bufferStackPos] + 1 < limit && buffer[this.bufferPos[this.bufferStackPos] + 1] != '\n') {
            if (arglist != null && !this.skipOverNonWhiteSpace(true)) {
                v7 = this.bufferStackPos;
                this.bufferPos[v7] = this.bufferPos[v7] + 1;
                if (this.skipOverWhiteSpace()) {
                    encounteredMultilineComment = true;
                }
                isArg = false;
                i = 0;
                while (i < arglist.length && arglist[i] != null) {
                    if (CharArrayUtils.equals(buffer, this.bufferPos[this.bufferStackPos], arglist[i].length, arglist[i])) {
                        isArg = true;
                        break;
                    }
                    ++i;
                }
                if (!isArg) {
                    this.handleProblem(0x200000A, this.bufferPos[this.bufferStackPos], null);
                }
            } else {
                this.skipOverNonWhiteSpace();
            }
            textend = this.bufferPos[this.bufferStackPos];
            if (!this.skipOverWhiteSpace()) continue;
            encounteredMultilineComment = true;
        }
        textlen = textend - textstart + 1;
        endingLine = this.getLineNumber(this.bufferPos[this.bufferStackPos]);
        text = Scanner2.emptyCharArray;
        if (textlen > 0) {
            text = new char[textlen];
            System.arraycopy(buffer, textstart, text, 0, textlen);
        }
        if (encounteredMultilineComment) {
            text = this.removeMultilineCommentFromBuffer(text);
        }
        text = this.removedEscapedNewline(text, 0, text.length);
        this.definitions.put(name, arglist == null ? new ObjectStyleMacro(name, text) : new FunctionStyleMacro(name, text, arglist));
        this.pushCallback(this.getASTFactory().createMacro(name, startingOffset, startingLineNumber, idstart, idstart + idlen, nameLine, textstart + textlen, endingLine, null, this.getCurrentFilename()));
    }

    private char[] removedEscapedNewline(char[] text, int start, int len) {
        if (CharArrayUtils.indexOf('\n', text, start, len) == -1) {
            return text;
        }
        char[] result = new char[text.length];
        Arrays.fill(result, ' ');
        int counter = 0;
        int i = 0;
        while (i < text.length) {
            if (text[i] == '\\' && i + 1 < text.length && text[i + 1] == '\n') {
                ++i;
            } else {
                result[counter++] = text[i];
            }
            ++i;
        }
        return CharArrayUtils.trim(result);
    }

    private char[] removeMultilineCommentFromBuffer(char[] text) {
        char[] result = new char[text.length];
        Arrays.fill(result, ' ');
        int resultCount = 0;
        int i = 0;
        while (i < text.length) {
            if (text[i] == '/' && i + 1 < text.length && text[i + 1] == '*') {
                i += 2;
                while (i < text.length && text[i] != '*' && i + 1 < text.length && text[i + 1] != '/') {
                    ++i;
                }
                ++i;
            } else {
                result[resultCount++] = text[i];
            }
            ++i;
        }
        return CharArrayUtils.trim(result);
    }

    /*
     * Unable to fully structure code
     */
    private void handlePPUndef() throws EndOfFileException {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        this.skipOverWhiteSpace();
        v0 = this.bufferStackPos;
        v1 = this.bufferPos[v0] + 1;
        this.bufferPos[v0] = v1;
        idstart = v1;
        if (idstart >= limit) {
            return;
        }
        c = buffer[idstart];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isUnicodeIdentifierPart(c))) {
            this.skipToNewLine();
            return;
        }
        idlen = 1;
        ** GOTO lbl19
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
            ++idlen;
lbl19:
            // 2 sources

            v2 = this.bufferStackPos;
            this.bufferPos[v2] = this.bufferPos[v2] + 1;
            if (this.bufferPos[v2] < limit) continue;
        }
        v3 = this.bufferStackPos;
        this.bufferPos[v3] = this.bufferPos[v3] - 1;
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition(new String(buffer, idstart, idlen));
        }
        this.skipToNewLine();
        this.definitions.remove(buffer, idstart, idlen);
        if (this.dlog != null) {
            this.dlog.println("#undef " + new String(buffer, idstart, idlen));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handlePPIfdef(boolean positive) throws EndOfFileException {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition("");
        }
        this.skipOverWhiteSpace();
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition("");
        }
        v0 = this.bufferStackPos;
        this.bufferPos[v0] = this.bufferPos[v0] + 1;
        idstart = this.bufferPos[v0];
        if (idstart >= limit) {
            return;
        }
        c = buffer[idstart];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isUnicodeIdentifierPart(c))) {
            this.skipToNewLine();
            return;
        }
        idlen = 1;
        ** GOTO lbl22
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
            ++idlen;
lbl22:
            // 2 sources

            v1 = this.bufferStackPos;
            this.bufferPos[v1] = this.bufferPos[v1] + 1;
            if (this.bufferPos[v1] < limit) continue;
        }
        v2 = this.bufferStackPos;
        this.bufferPos[v2] = this.bufferPos[v2] - 1;
        if (this.isLimitReached()) {
            this.handleCompletionOnDefinition(new String(buffer, idstart, idlen));
        }
        this.skipToNewLine();
        this.branchState(1);
        if (this.definitions.get(buffer, idstart, idlen) != null == positive) {
            if (this.dlog != null) {
                this.dlog.println(String.valueOf(positive != false ? "#ifdef" : "#ifndef") + " <TRUE> " + new String(buffer, idstart, idlen));
            }
            return;
        }
        if (this.dlog != null) {
            this.dlog.println(String.valueOf(positive != false ? "#ifdef" : "#ifndef") + " <FALSE> " + new String(buffer, idstart, idlen));
        }
        this.skipOverConditionalCode(true);
        if (this.isLimitReached()) {
            this.handleInvalidCompletion();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void skipOverConditionalCode(boolean checkelse) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        nesting = 0;
        block6: while (this.bufferPos[this.bufferStackPos] < limit) {
            block13: {
                this.skipOverWhiteSpace();
                v0 = this.bufferStackPos;
                this.bufferPos[v0] = this.bufferPos[v0] + 1;
                if (this.bufferPos[v0] >= limit) {
                    return;
                }
                c = buffer[this.bufferPos[this.bufferStackPos]];
                if (c != '#') break block13;
                this.skipOverWhiteSpace();
                v1 = this.bufferStackPos;
                v2 = this.bufferPos[v1] + 1;
                this.bufferPos[v1] = v2;
                start = v2;
                if (start >= limit || buffer[start] == '\n' || (c = buffer[start]) < 'a' || c > 'z') continue;
                ** GOTO lbl-1000
                while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z') lbl-1000:
                // 2 sources

                {
                    v3 = this.bufferStackPos;
                    this.bufferPos[v3] = this.bufferPos[v3] + 1;
                    if (this.bufferPos[v3] < limit) continue;
                }
                v4 = this.bufferStackPos;
                this.bufferPos[v4] = this.bufferPos[v4] - 1;
                len = this.bufferPos[this.bufferStackPos] - start + 1;
                type = Scanner2.ppKeywords.get(buffer, start, len);
                if (type == Scanner2.ppKeywords.undefined) continue;
                switch (type) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ++nesting;
                        this.branchState(1);
                        break;
                    }
                    case 4: {
                        if (this.branchState(3)) {
                            if (!checkelse || nesting != 0) continue block6;
                            this.skipToNewLine();
                            return;
                        }
                        this.handleProblem(0x2000004, start, Scanner2.ppKeywords.findKey(buffer, start, len));
                        this.skipToNewLine();
                        break;
                    }
                    case 3: {
                        if (this.branchState(2)) {
                            if (!checkelse || nesting != 0) continue block6;
                            start = this.bufferPos[this.bufferStackPos];
                            this.skipToNewLine();
                            len = this.bufferPos[this.bufferStackPos] - start;
                            if (this.expressionEvaluator.evaluate(buffer, start, len, this.definitions) == 0L) break;
                            return;
                        }
                        this.handleProblem(0x2000004, start, Scanner2.ppKeywords.findKey(buffer, start, len));
                        this.skipToNewLine();
                        break;
                    }
                    case 5: {
                        if (this.branchState(4)) {
                            if (nesting > 0) {
                                --nesting;
                                break;
                            }
                            this.skipToNewLine();
                            return;
                        }
                        this.handleProblem(0x2000004, start, Scanner2.ppKeywords.findKey(buffer, start, len));
                        this.skipToNewLine();
                    }
                }
                continue;
            }
            if (c == '\n') continue;
            this.skipToNewLine();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private boolean skipOverWhiteSpace() {
        boolean encounteredMultiLineComment;
        block11: {
            int n;
            int pos;
            int limit;
            char[] buffer;
            block10: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                pos = this.bufferPos[this.bufferStackPos];
                encounteredMultiLineComment = false;
                if (!true) break block10;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block11;
            }
            do {
                block9: {
                    pos = this.bufferPos[this.bufferStackPos];
                    switch (buffer[pos]) {
                        case '\t': 
                        case '\r': 
                        case ' ': {
                            break block9;
                        }
                        case '/': {
                            if (pos + 1 >= limit) break;
                            if (buffer[pos + 1] == '/') {
                                this.skipToNewLine();
                                int n2 = this.bufferStackPos;
                                this.bufferPos[n2] = this.bufferPos[n2] - 1;
                                return false;
                            }
                            if (buffer[pos + 1] != '*') break;
                            int n3 = this.bufferStackPos;
                            this.bufferPos[n3] = this.bufferPos[n3] + 2;
                            while (this.bufferPos[this.bufferStackPos] < limit) {
                                pos = this.bufferPos[this.bufferStackPos];
                                if (buffer[pos] == '*' && pos + 1 < limit && buffer[pos + 1] == '/') {
                                    int n4 = this.bufferStackPos;
                                    this.bufferPos[n4] = this.bufferPos[n4] + 1;
                                    encounteredMultiLineComment = true;
                                    break block9;
                                }
                                int n5 = this.bufferStackPos;
                                this.bufferPos[n5] = this.bufferPos[n5] + 1;
                            }
                            break block9;
                        }
                        case '\\': {
                            if (pos + 1 >= limit || buffer[pos + 1] != '\n') break;
                            int n6 = this.bufferStackPos;
                            this.bufferPos[n6] = this.bufferPos[n6] + 1;
                            break block9;
                        }
                    }
                    int n7 = this.bufferStackPos;
                    this.bufferPos[n7] = this.bufferPos[n7] - 1;
                    return encounteredMultiLineComment;
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        return encounteredMultiLineComment;
    }

    private void skipOverNonWhiteSpace() {
        this.skipOverNonWhiteSpace(false);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private boolean skipOverNonWhiteSpace(boolean stopAtPound) {
        block26: {
            int n;
            int limit;
            char[] buffer;
            block25: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                if (!true) break block25;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block26;
            }
            do {
                block0 : switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        int n2 = this.bufferStackPos;
                        this.bufferPos[n2] = this.bufferPos[n2] - 1;
                        return true;
                    }
                    case '/': {
                        int pos = this.bufferPos[this.bufferStackPos];
                        if ((pos + 1 >= limit || buffer[pos + 1] != '/') && buffer[pos + 1] != '*') break;
                        int n3 = this.bufferStackPos;
                        this.bufferPos[n3] = this.bufferPos[n3] - 1;
                        return true;
                    }
                    case '\\': {
                        int pos = this.bufferPos[this.bufferStackPos];
                        if (pos + 1 >= limit || buffer[pos + 1] != '\n') break;
                        int n4 = this.bufferStackPos;
                        this.bufferPos[n4] = this.bufferPos[n4] - 1;
                        return true;
                    }
                    case '\"': {
                        boolean escaped = false;
                        if (this.bufferPos[this.bufferStackPos] - 1 > 0 && buffer[this.bufferPos[this.bufferStackPos] - 1] == '\\') {
                            escaped = true;
                        }
                        while (true) {
                            int n5 = this.bufferStackPos;
                            this.bufferPos[n5] = this.bufferPos[n5] + 1;
                            if (this.bufferPos[n5] >= this.bufferLimit[this.bufferStackPos]) break block0;
                            switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                                case '\\': {
                                    escaped = !escaped;
                                    break;
                                }
                                case '\"': {
                                    if (!escaped) break block0;
                                    escaped = false;
                                    break;
                                }
                                case '\n': {
                                    if (!escaped) break block0;
                                }
                                case '/': {
                                    if (escaped && this.bufferPos[this.bufferStackPos] + 1 < limit && (buffer[this.bufferPos[this.bufferStackPos] + 1] == '/' || buffer[this.bufferPos[this.bufferStackPos] + 1] == '*')) {
                                        int n6 = this.bufferStackPos;
                                        this.bufferPos[n6] = this.bufferPos[n6] - 1;
                                        return true;
                                    }
                                }
                                default: {
                                    escaped = false;
                                    break;
                                }
                            }
                        }
                    }
                    case '\'': {
                        boolean escaped = false;
                        while (true) {
                            int n7 = this.bufferStackPos;
                            this.bufferPos[n7] = this.bufferPos[n7] + 1;
                            if (this.bufferPos[n7] >= this.bufferLimit[this.bufferStackPos]) break block0;
                            switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                                case '\\': {
                                    escaped = !escaped;
                                    break;
                                }
                                case '\'': {
                                    if (!escaped) break block0;
                                    escaped = false;
                                    break;
                                }
                                default: {
                                    escaped = false;
                                    break;
                                }
                            }
                        }
                    }
                    case '#': {
                        if (!stopAtPound) break;
                        if (buffer[this.bufferPos[this.bufferStackPos] + 1] != '#') {
                            int n8 = this.bufferStackPos;
                            this.bufferPos[n8] = this.bufferPos[n8] - 1;
                            return false;
                        }
                        int n9 = this.bufferStackPos;
                        this.bufferPos[n9] = this.bufferPos[n9] + 1;
                        break;
                    }
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private void skipOverMacroArg() {
        block13: {
            int n;
            int limit;
            char[] buffer;
            block12: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                if (!true) break block12;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block13;
            }
            do {
                block0 : switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '(': 
                    case ')': 
                    case ',': 
                    case '<': 
                    case '>': {
                        int n2 = this.bufferStackPos;
                        this.bufferPos[n2] = this.bufferPos[n2] - 1;
                        return;
                    }
                    case '\\': {
                        int pos = this.bufferPos[this.bufferStackPos];
                        if (pos + 1 >= limit || buffer[pos + 1] != '\n') break;
                        int n3 = this.bufferStackPos;
                        this.bufferPos[n3] = this.bufferPos[n3] - 1;
                        return;
                    }
                    case '\"': {
                        boolean escaped = false;
                        while (true) {
                            int n4 = this.bufferStackPos;
                            this.bufferPos[n4] = this.bufferPos[n4] + 1;
                            if (this.bufferPos[n4] >= this.bufferLimit[this.bufferStackPos]) break block0;
                            switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                                case '\\': {
                                    escaped = !escaped;
                                    break;
                                }
                                case '\"': {
                                    if (!escaped) break block0;
                                    escaped = false;
                                    break;
                                }
                                default: {
                                    escaped = false;
                                    break;
                                }
                            }
                        }
                    }
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
        int n = this.bufferStackPos;
        this.bufferPos[n] = this.bufferPos[n] - 1;
    }

    /*
     * Unable to fully structure code
     */
    private void skipOverIdentifier() {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        ** GOTO lbl-1000
        while ((c = buffer[this.bufferPos[this.bufferStackPos]]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) lbl-1000:
        // 2 sources

        {
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 1;
            if (this.bufferPos[v0] < limit) continue;
        }
        v1 = this.bufferStackPos;
        this.bufferPos[v1] = this.bufferPos[v1] - 1;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private void skipToNewLine() {
        block10: {
            int n;
            boolean escaped;
            int pos;
            int limit;
            char[] buffer;
            block9: {
                buffer = this.bufferStack[this.bufferStackPos];
                limit = this.bufferLimit[this.bufferStackPos];
                int n2 = this.bufferStackPos;
                this.bufferPos[n2] = this.bufferPos[n2] + 1;
                pos = this.bufferPos[n2];
                if (pos < limit && buffer[pos] == '\n') {
                    return;
                }
                escaped = false;
                if (!true) break block9;
                n = this.bufferStackPos;
                if ((this.bufferPos[n] = this.bufferPos[n] + 1) >= limit) break block10;
            }
            do {
                block11: {
                    block0 : switch (buffer[this.bufferPos[this.bufferStackPos]]) {
                        case '/': {
                            pos = this.bufferPos[this.bufferStackPos];
                            if (pos + 1 >= limit || buffer[pos + 1] != '*') break;
                            int n3 = this.bufferStackPos;
                            this.bufferPos[n3] = this.bufferPos[n3] + 1;
                            do {
                                int n4 = this.bufferStackPos;
                                this.bufferPos[n4] = this.bufferPos[n4] + 1;
                                if (this.bufferPos[n4] >= limit) break block0;
                            } while (buffer[pos = this.bufferPos[this.bufferStackPos]] != '*' || pos + 1 >= limit || buffer[pos + 1] != '/');
                            int n5 = this.bufferStackPos;
                            this.bufferPos[n5] = this.bufferPos[n5] + 1;
                            break;
                        }
                        case '\\': {
                            escaped = !escaped;
                            break block11;
                        }
                        case '\n': {
                            if (!escaped) {
                                return;
                            }
                            escaped = false;
                        }
                    }
                    escaped = false;
                }
                n = this.bufferStackPos;
            } while ((this.bufferPos[n] = this.bufferPos[n] + 1) < limit);
        }
    }

    /*
     * Unable to fully structure code
     */
    private char[] handleFunctionStyleMacro(FunctionStyleMacro macro, boolean pushContext) {
        buffer = this.bufferStack[this.bufferStackPos];
        limit = this.bufferLimit[this.bufferStackPos];
        this.skipOverWhiteSpace();
        while (buffer[this.bufferPos[this.bufferStackPos]] == '\\' && this.bufferPos[this.bufferStackPos] + 1 < buffer.length && buffer[this.bufferPos[this.bufferStackPos] + 1] == '\n') {
            v0 = this.bufferStackPos;
            this.bufferPos[v0] = this.bufferPos[v0] + 2;
            this.skipOverWhiteSpace();
        }
        v1 = this.bufferStackPos;
        this.bufferPos[v1] = this.bufferPos[v1] + 1;
        if (this.bufferPos[v1] >= limit || buffer[this.bufferPos[this.bufferStackPos]] != '(') {
            return Scanner2.emptyCharArray;
        }
        arglist = macro.arglist;
        currarg = -1;
        argmap = new CharArrayObjectMap(arglist.length);
        while (this.bufferPos[this.bufferStackPos] < limit) {
            if (++currarg >= arglist.length || arglist[currarg] == null) {
                this.handleProblem(0x2000009, this.bufferPos[this.bufferStackPos], macro.name);
                break;
            }
            this.skipOverWhiteSpace();
            v2 = this.bufferStackPos;
            v3 = this.bufferPos[v2] + 1;
            this.bufferPos[v2] = v3;
            pos = v3;
            c = buffer[pos];
            if (c == ')') break;
            if (c == ',') {
                argmap.put(arglist[currarg], Scanner2.emptyCharArray);
                continue;
            }
            v4 = this.bufferStackPos;
            this.bufferPos[v4] = this.bufferPos[v4] - 1;
            argend = this.bufferPos[this.bufferStackPos];
            argstart = argend + 1;
            argparens = 0;
            while (this.bufferPos[this.bufferStackPos] < limit) {
                this.skipOverMacroArg();
                argend = this.bufferPos[this.bufferStackPos];
                this.skipOverWhiteSpace();
                v5 = this.bufferStackPos;
                this.bufferPos[v5] = this.bufferPos[v5] + 1;
                if (this.bufferPos[v5] >= limit) break;
                c = buffer[this.bufferPos[this.bufferStackPos]];
                if (c == '(' || c == '<') {
                    ++argparens;
                } else if (c == '>') {
                    --argparens;
                } else if (c == ')') {
                    if (argparens == 0) break;
                    --argparens;
                } else if (c == ',') {
                    if (argparens == 0) {
                        break;
                    }
                } else {
                    if (c == '\n') continue;
                    v6 = this.bufferStackPos;
                    this.bufferPos[v6] = this.bufferPos[v6] - 1;
                    continue;
                }
                this.skipOverWhiteSpace();
                ** GOTO lbl72
                while (buffer[this.bufferPos[this.bufferStackPos]] == '\n') {
                    this.skipOverWhiteSpace();
lbl72:
                    // 2 sources

                    v7 = this.bufferStackPos;
                    this.bufferPos[v7] = this.bufferPos[v7] + 1;
                    if (this.bufferPos[v7] < limit) continue;
                }
                v8 = this.bufferStackPos;
                this.bufferPos[v8] = this.bufferPos[v8] - 1;
            }
            arg = Scanner2.emptyCharArray;
            arglen = argend - argstart + 1;
            if (arglen > 0) {
                arg = new char[arglen];
                System.arraycopy(buffer, argstart, arg, 0, arglen);
            }
            arg = this.replaceArgumentMacros(arg);
            argmap.put(arglist[currarg], arg);
            if (c == ')') break;
        }
        numArgs = arglist.length;
        i = 0;
        while (i < arglist.length) {
            if (arglist[i] == null) {
                numArgs = i;
                break;
            }
            ++i;
        }
        if (argmap.size() < numArgs) {
            this.handleProblem(0x2000009, this.bufferPos[this.bufferStackPos], macro.name);
        }
        size = this.expandFunctionStyleMacro(macro.expansion, argmap, null);
        result = new char[size];
        this.expandFunctionStyleMacro(macro.expansion, argmap, result);
        if (pushContext) {
            this.pushContext(result, macro);
        }
        return result;
    }

    private char[] replaceArgumentMacros(char[] arg) {
        Object expObject = this.definitions.get(arg, 0, arg.length);
        if (expObject != null) {
            int stackPos = this.bufferStackPos;
            while (stackPos >= 0) {
                if (this.bufferData[stackPos] != null && this.bufferData[stackPos] instanceof ObjectStyleMacro && CharArrayUtils.equals(arg, ((ObjectStyleMacro)this.bufferData[stackPos]).name)) {
                    expObject = null;
                    break;
                }
                --stackPos;
            }
        }
        if (expObject == null) {
            return arg;
        }
        if (expObject instanceof ObjectStyleMacro) {
            ObjectStyleMacro expMacro = (ObjectStyleMacro)expObject;
            return expMacro.expansion;
        }
        if (expObject instanceof char[]) {
            return (char[])expObject;
        }
        return arg;
    }

    /*
     * Unable to fully structure code
     */
    private int expandFunctionStyleMacro(char[] expansion, CharArrayObjectMap argmap, char[] result) {
        pos = -1;
        lastcopy = -1;
        outpos = 0;
        wsstart = -1;
        limit = expansion.length;
        block8: while (++pos < limit) {
            block57: {
                block58: {
                    c = expansion[pos];
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || Character.isUnicodeIdentifierPart(c)) {
                        wsstart = -1;
                        idstart = pos;
                        while (++pos < limit) {
                            c = expansion[pos];
                            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') && !Character.isUnicodeIdentifierPart(c)) break;
                        }
                        if ((repObject = argmap.get(expansion, idstart, --pos - idstart + 1)) == null) continue;
                        if (++lastcopy < idstart) {
                            n = idstart - lastcopy;
                            if (result != null) {
                                System.arraycopy(expansion, lastcopy, result, outpos, n);
                            }
                            outpos += n;
                        }
                        rep = (char[])repObject;
                        if (result != null) {
                            System.arraycopy(rep, 0, result, outpos, rep.length);
                        }
                        outpos += rep.length;
                        lastcopy = pos;
                        continue;
                    }
                    if (c >= '0' && c < '9') {
                        wsstart = -1;
                        while (++pos < limit) {
                            c = expansion[pos];
                            if ((c < '0' || c > '9') && c != '.' && c != '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue block8;
                        }
                        continue;
                    }
                    if (c == '\"') {
                        wsstart = -1;
                        escaped = false;
                        while (++pos < limit) {
                            c = expansion[pos];
                            if (c == '\"') {
                                if (!escaped) {
                                    continue block8;
                                }
                            } else if (c == '\\') {
                                escaped = escaped == false;
                            }
                            escaped = false;
                        }
                        continue;
                    }
                    if (c == '\'') {
                        wsstart = -1;
                        escaped = false;
                        while (++pos < limit) {
                            c = expansion[pos];
                            if (c == '\'') {
                                if (!escaped) {
                                    continue block8;
                                }
                            } else if (c == '\\') {
                                escaped = escaped == false;
                            }
                            escaped = false;
                        }
                        continue;
                    }
                    if (c == ' ' || c == '\t') {
                        if (wsstart >= 0) continue;
                        wsstart = pos;
                        continue;
                    }
                    if (c == '/' && pos + 1 < limit) {
                        if ((c = expansion[++pos]) == '/') {
                            v0 = n = wsstart < 0 ? pos - 1 - lastcopy : wsstart - ++lastcopy;
                            if (result != null) {
                                System.arraycopy(expansion, lastcopy, result, outpos, n);
                            }
                            outpos += n;
                            lastcopy = expansion.length - 1;
                            continue;
                        }
                        if (c == '*') {
                            if (wsstart < 1) {
                                wsstart = pos - 1;
                            }
                            while (++pos < limit) {
                                if (expansion[pos] != '*' || pos + 1 >= limit || expansion[pos + 1] != '/') continue;
                                ++pos;
                                continue block8;
                            }
                            continue;
                        }
                        wsstart = -1;
                        continue;
                    }
                    if (c == '\\' && pos + 1 < limit && expansion[pos + 1] == 'n') {
                        ++pos;
                        continue;
                    }
                    if (c != '#') break block57;
                    if (pos + 1 >= limit || expansion[pos + 1] != '#') break block58;
                    ++pos;
                    if (wsstart < 0) {
                        wsstart = pos - 1;
                    }
                    block14: while (++pos < limit) {
                        block0 : switch (expansion[pos]) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            case '/': {
                                if (pos + 1 >= limit) ** GOTO lbl109
                                c = expansion[pos + 1];
                                if (c != '/') ** GOTO lbl102
                                pos = expansion.length;
                                ** GOTO lbl109
lbl102:
                                // 1 sources

                                if (c == '*') {
                                    ++pos;
                                    while (++pos < limit) {
                                        if (expansion[pos] != '*' || pos + 1 >= limit || expansion[pos + 1] != '/') continue;
                                        ++pos;
                                        break block0;
                                    }
                                    continue block14;
                                }
                            }
lbl109:
                            // 5 sources

                            default: {
                                break block14;
                            }
                        }
                    }
                    n = wsstart - ++lastcopy;
                    if (n > 0 && result != null) {
                        System.arraycopy(expansion, lastcopy, result, outpos, n);
                    }
                    outpos += n;
                    lastcopy = --pos;
                    wsstart = -1;
                    continue;
                }
                if (++lastcopy < pos) {
                    n = pos - lastcopy;
                    if (result != null) {
                        System.arraycopy(expansion, lastcopy, result, outpos, n);
                    }
                    outpos += n;
                }
                block16: while (++pos < limit) {
                    block4 : switch (expansion[pos]) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '/': {
                            if (pos + 1 >= limit) ** GOTO lbl142
                            c = expansion[pos + 1];
                            if (c != '/') ** GOTO lbl135
                            pos = expansion.length;
                            ** GOTO lbl142
lbl135:
                            // 1 sources

                            if (c == '*') {
                                ++pos;
                                while (++pos < limit) {
                                    if (expansion[pos] != '*' || pos + 1 >= limit || expansion[pos + 1] != '/') continue;
                                    ++pos;
                                    break block4;
                                }
                                continue block16;
                            }
                        }
lbl142:
                        // 5 sources

                        default: {
                            break block16;
                        }
                    }
                }
                c = expansion[pos];
                idstart = pos;
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'X' || c == '_' || Character.isUnicodeIdentifierPart(c)) {
                    while (++pos < limit) {
                        c = expansion[pos];
                        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'X' || c >= '0' && c <= '9' || c == '_') && !Character.isUnicodeIdentifierPart(c)) break;
                    }
                }
                if ((argvalue = (char[])argmap.get(expansion, idstart, idlen = --pos - idstart + 1)) != null) {
                    if (result != null) {
                        result[outpos++] = 34;
                        i = 0;
                        while (i < argvalue.length) {
                            if (argvalue[i] == '\"' || argvalue[i] == '\\') {
                                result[outpos++] = 92;
                            }
                            result[outpos++] = argvalue[i] == '\r' || argvalue[i] == '\n' ? 32 : argvalue[i];
                            ++i;
                        }
                        result[outpos++] = 34;
                    } else {
                        i = 0;
                        while (i < argvalue.length) {
                            if (argvalue[i] == '\"' || argvalue[i] == '\\') {
                                ++outpos;
                            }
                            ++outpos;
                            ++i;
                        }
                        outpos += 2;
                    }
                }
                lastcopy = pos;
                continue;
            }
            wsstart = -1;
        }
        if (wsstart < 0 && ++lastcopy < expansion.length) {
            n = expansion.length - lastcopy;
            if (result != null) {
                System.arraycopy(expansion, lastcopy, result, outpos, n);
            }
            outpos += n;
        }
        return outpos;
    }

    protected void setupBuiltInMacros() {
        this.definitions.put(Scanner2.__STDC__.name, __STDC__);
        if (this.language == ParserLanguage.CPP) {
            this.definitions.put(Scanner2.__cplusplus.name, __cplusplus);
        }
        this.definitions.put(Scanner2.__inline__.name, __inline__);
        this.definitions.put(Scanner2.__cdecl.name, __cdecl);
        this.definitions.put(Scanner2.__const__.name, __const__);
        this.definitions.put(Scanner2.__const.name, __const);
        this.definitions.put(Scanner2.__extension__.name, __extension__);
        this.definitions.put(Scanner2.__attribute__.name, __attribute__);
        this.definitions.put(Scanner2.__declspec.name, __declspec);
        this.definitions.put(Scanner2.__restrict__.name, __restrict__);
        this.definitions.put(Scanner2.__restrict.name, __restrict);
        this.definitions.put(Scanner2.__volatile__.name, __volatile__);
        this.definitions.put(Scanner2.__signed__.name, __signed__);
        if (this.language == ParserLanguage.CPP) {
            this.definitions.put(Scanner2.__asm__.name, __asm__);
        } else {
            this.definitions.put(Scanner2._Pragma.name, _Pragma);
        }
    }

    public IToken nextToken(boolean next) throws ScannerException, EndOfFileException {
        return null;
    }

    public IToken nextTokenForStringizing() throws ScannerException, EndOfFileException {
        return null;
    }

    public void overwriteIncludePath(String[] newIncludePaths) {
    }

    public final void setASTFactory(IASTFactory f) {
        this.astFactory = f;
    }

    public final void setOffsetBoundary(int offset) {
        this.offsetBoundary = offset;
        this.bufferLimit[0] = offset;
    }

    public void setScannerContext(IScannerContext context) {
    }

    public void setThrowExceptionOnBadCharacterRead(boolean throwOnBad) {
    }

    public void setTokenizingMacroReplacementList(boolean b) {
    }

    public final IASTFactory getASTFactory() {
        if (this.astFactory == null) {
            this.astFactory = ParserFactory.createASTFactory(this.parserMode, this.language);
        }
        return this.astFactory;
    }

    public BranchTracker getBranchTracker() {
        return null;
    }

    public ISourceElementRequestor getClientRequestor() {
        return this.requestor;
    }

    public ContextStack getContextStack() {
        return null;
    }

    public Map getFileCache() {
        return null;
    }

    public List getIncludePathNames() {
        return null;
    }

    public CodeReader getInitialReader() {
        return null;
    }

    public ParserLanguage getLanguage() {
        return this.language;
    }

    public IParserLogService getLogService() {
        return this.log;
    }

    public IScannerInfo getOriginalConfig() {
        return null;
    }

    public ParserMode getParserMode() {
        return this.parserMode;
    }

    public Map getPrivateDefinitions() {
        return null;
    }

    public IProblemFactory getProblemFactory() {
        return null;
    }

    public Map getPublicDefinitions() {
        return null;
    }

    public IScanner getScanner() {
        return null;
    }

    public Iterator getWorkingCopies() {
        if (this.workingCopies == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.workingCopies.iterator();
    }

    public ScannerUtility.InclusionDirective parseInclusionDirective(String restOfLine, int offset) throws ScannerUtility.InclusionParseException {
        return null;
    }

    public void setDefinitions(Map map) {
    }

    public void setIncludePathNames(List includePathNames) {
    }

    private final char[] getCurrentFilename() {
        int i = this.bufferStackPos;
        while (i >= 0) {
            if (this.bufferData[i] instanceof InclusionData) {
                return ((InclusionData)this.bufferData[i]).reader.filename;
            }
            if (this.bufferData[i] instanceof CodeReader) {
                return ((CodeReader)this.bufferData[i]).filename;
            }
            --i;
        }
        return emptyCharArray;
    }

    private final int getCurrentFileIndex() {
        int i = this.bufferStackPos;
        while (i >= 0) {
            if (this.bufferData[i] instanceof InclusionData || this.bufferData[i] instanceof CodeReader) {
                return i;
            }
            --i;
        }
        return 0;
    }

    protected void handleCompletionOnDefinition(String definition) throws EndOfFileException {
        ASTCompletionNode node = new ASTCompletionNode(IASTCompletionNode.CompletionKind.MACRO_REFERENCE, null, null, definition, KeywordSets.getKeywords(KeywordSetKey.EMPTY, this.language), EMPTY_STRING, null);
        throw new OffsetLimitReachedException(node);
    }

    protected void handleCompletionOnExpression(char[] buffer) throws EndOfFileException {
        int lastTab;
        IASTCompletionNode.CompletionKind kind = IASTCompletionNode.CompletionKind.MACRO_REFERENCE;
        int lastSpace = CharArrayUtils.lastIndexOf(SPACE, buffer);
        int max = lastSpace > (lastTab = CharArrayUtils.lastIndexOf(TAB, buffer)) ? lastSpace : lastTab;
        char[] prefix = CharArrayUtils.trim(CharArrayUtils.extract(buffer, max, buffer.length - max));
        int i = 0;
        while (i < prefix.length) {
            char c = prefix[i];
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c))) {
                this.handleInvalidCompletion();
            }
            ++i;
        }
        ASTCompletionNode node = new ASTCompletionNode(kind, null, null, new String(prefix), KeywordSets.getKeywords(kind == IASTCompletionNode.CompletionKind.NO_SUCH_KIND ? KeywordSetKey.EMPTY : KeywordSetKey.MACRO, this.language), EMPTY_STRING, null);
        throw new OffsetLimitReachedException(node);
    }

    protected void handleInvalidCompletion() throws EndOfFileException {
        throw new OffsetLimitReachedException(new ASTCompletionNode(IASTCompletionNode.CompletionKind.UNREACHABLE_CODE, null, null, EMPTY_STRING, KeywordSets.getKeywords(KeywordSetKey.EMPTY, this.language), EMPTY_STRING, null));
    }

    protected void handleCompletionOnPreprocessorDirective(String prefix) throws EndOfFileException {
        throw new OffsetLimitReachedException(new ASTCompletionNode(IASTCompletionNode.CompletionKind.PREPROCESSOR_DIRECTIVE, null, null, prefix, KeywordSets.getKeywords(KeywordSetKey.PP_DIRECTIVE, this.language), EMPTY_STRING, null));
    }

    private static class InclusionData {
        public final IASTInclusion inclusion;
        public final CodeReader reader;

        public InclusionData(CodeReader reader, IASTInclusion inclusion) {
            this.reader = reader;
            this.inclusion = inclusion;
        }
    }
}

